/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.metro;

import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.server.Adapter;
import com.sun.xml.ws.api.server.TransportBackChannel;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.api.server.WebServiceContextDelegate;
import com.sun.xml.ws.transport.http.DeploymentDescriptorParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import org.jboss.wsf.stack.metro.MessageStreamConnectionImpl;
import org.jboss.wsf.stack.metro.MessageStreamContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageStreamAdapter
extends Adapter<StreamToolkit> {
    public static final DeploymentDescriptorParser.AdapterFactory<MessageStreamAdapter> FACTORY = new DeploymentDescriptorParser.AdapterFactory<MessageStreamAdapter>(){

        public MessageStreamAdapter createAdapter(String name, String urlPattern, WSEndpoint<?> endpoint) {
            return new MessageStreamAdapter(endpoint);
        }
    };

    public MessageStreamAdapter(WSEndpoint endpoint) {
        super(endpoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(MessageStreamContext context, InputStream in, OutputStream out) throws IOException {
        MessageStreamConnectionImpl connection = new MessageStreamConnectionImpl(context, in, out);
        StreamToolkit tk = (StreamToolkit)((Object)this.pool.take());
        try {
            tk.handle(connection);
            connection.flush();
        }
        finally {
            this.pool.recycle((Object)tk);
            connection.close();
        }
    }

    protected StreamToolkit createToolkit() {
        return new StreamToolkit();
    }

    class StreamToolkit
    extends Adapter.Toolkit
    implements TransportBackChannel {
        private MessageStreamConnectionImpl connection;

        StreamToolkit() {
            super((Adapter)MessageStreamAdapter.this);
        }

        private void handle(MessageStreamConnectionImpl connection) throws IOException {
            this.connection = connection;
            String contentTypeStr = connection.getRequestHeader("Content-Type");
            InputStream in = connection.getInputStream();
            Packet packet = new Packet();
            this.codec.decode(in, contentTypeStr, packet);
            try {
                packet = this.head.process(packet, (WebServiceContextDelegate)connection, (TransportBackChannel)this);
            }
            catch (Exception e) {
                e.printStackTrace();
                connection.setStatus(500);
                return;
            }
            contentTypeStr = this.codec.getStaticContentType(packet).getContentType();
            if (contentTypeStr == null) {
                throw new UnsupportedOperationException();
            }
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Content-Type", contentTypeStr);
            connection.setResponseHeaders(headers);
            this.codec.encode(packet, connection.getOutputStream());
        }

        public void close() {
            this.connection.close();
        }
    }
}

