/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.metro;

import com.sun.tools.ws.wscompile.WsgenTool;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedList;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.WebServiceException;
import org.jboss.logging.Logger;
import org.jboss.util.file.JarUtils;
import org.jboss.wsf.spi.SPIProvider;
import org.jboss.wsf.spi.SPIProviderResolver;
import org.jboss.wsf.spi.management.ServerConfig;
import org.jboss.wsf.spi.management.ServerConfigFactory;

public class WsgenWrapperGenerator {
    private static Logger log = Logger.getLogger(WsgenWrapperGenerator.class);
    private OutputStream outputStream;
    private ServerConfig serverConfig;

    public WsgenWrapperGenerator(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    public ClassLoader generate(String endpoint, ClassLoader classLoader, URL archiveUrl) {
        log.debug((Object)("ImplementationName: " + endpoint));
        log.debug((Object)("Archive file: " + archiveUrl));
        File tempDir = this.getTempDir(archiveUrl);
        log.debug((Object)("Temp directory: " + tempDir));
        if (!WsgenWrapperGenerator.checkWsgenRequirements()) {
            return classLoader;
        }
        WsgenTool wsgen = new WsgenTool(this.outputStream);
        ArrayList<String> args = new ArrayList<String>();
        args.add("-cp");
        args.add(this.getClasspath(classLoader, archiveUrl));
        args.add("-d");
        args.add(tempDir.getAbsolutePath());
        args.add("-verbose");
        args.add(endpoint);
        try {
            log.debug((Object)("Invoking Wsgen with the following parameters: " + args));
            if (!wsgen.run(args.toArray(new String[0]))) {
                throw new WebServiceException("Wsgen invocation failed: see the logs for details.");
            }
            URLClassLoader newClassloader = new URLClassLoader(new URL[]{tempDir.toURL()}, classLoader);
            return newClassloader;
        }
        catch (Exception e) {
            throw new WebServiceException("Unable to generate wrapper classes", (Throwable)e);
        }
    }

    private static boolean checkWsgenRequirements() {
        Class<EndpointReference> epRef = EndpointReference.class;
        Class<XmlSeeAlso> xmlSeeAlso = XmlSeeAlso.class;
        String epRefUrl = epRef.getResource('/' + epRef.getName().replace('.', '/') + ".class").toExternalForm();
        String xmlSeeAlsoUrl = xmlSeeAlso.getResource('/' + xmlSeeAlso.getName().replace('.', '/') + ".class").toExternalForm();
        log.debug((Object)("EndpointReference.class loaded from: " + epRefUrl));
        log.debug((Object)("XmlSeeAlso.class loaded from: " + xmlSeeAlsoUrl));
        if (!epRefUrl.startsWith("jar:") || !xmlSeeAlsoUrl.startsWith("jar:")) {
            log.warn((Object)"[JBWS-2342] wsgen tool does not support jaxws-api and jaxb libraries loaded through vfszip. Try running this with JDK6 so that they're provided by the JDK runtime. Wrapper generation skipped.");
            return false;
        }
        return true;
    }

    private ServerConfig getServerConfig() {
        if (this.serverConfig == null) {
            SPIProvider provider = SPIProviderResolver.getInstance().getProvider();
            ServerConfigFactory spi = (ServerConfigFactory)provider.getSPI(ServerConfigFactory.class);
            this.serverConfig = spi.getServerConfig();
        }
        return this.serverConfig;
    }

    protected String getClasspath(ClassLoader classLoader, URL archiveUrl) {
        URL[] urls;
        StringBuffer sb = new StringBuffer();
        ServerConfig cfg = this.getServerConfig();
        File clientDir = new File(cfg.getHomeDir(), "client");
        File[] libs = clientDir.listFiles();
        if (libs != null && libs.length > 0) {
            for (File lib : libs) {
                sb.append(lib.getAbsolutePath()).append(File.pathSeparator);
            }
            sb.delete(sb.length() - 1, sb.length());
        }
        for (URL url : urls = this.getURLs(classLoader, archiveUrl)) {
            sb.append(File.pathSeparator);
            sb.append(url.getPath());
        }
        return sb.toString();
    }

    protected File getTempDir(URL archiveUrl) {
        String archiveName;
        File tempDir;
        String archivePath;
        File tempJBossWSDir = new File(this.getServerConfig().getServerTempDir(), "jbossws");
        if (!tempJBossWSDir.exists()) {
            tempJBossWSDir.mkdir();
        }
        if ((archivePath = archiveUrl.getPath()).endsWith("/")) {
            archivePath = archivePath.substring(0, archivePath.length() - 1);
        }
        if (!(tempDir = new File(tempJBossWSDir, (archiveName = archivePath.substring(archivePath.lastIndexOf("/"))) + "-" + new Date().getTime())).exists()) {
            tempDir.mkdir();
        }
        return tempDir;
    }

    private URL[] getURLs(ClassLoader classLoader, URL archiveUrl) {
        LinkedList urls;
        block11: {
            urls = new LinkedList();
            try {
                if (archiveUrl.toString().endsWith(".war")) {
                    LinkedList<URL> innerUrlList = new LinkedList<URL>();
                    if (classLoader instanceof URLClassLoader) {
                        innerUrlList.addAll(Arrays.asList(((URLClassLoader)classLoader).getURLs()));
                    }
                    if (innerUrlList.isEmpty()) {
                        File dest = this.getTempDir(archiveUrl);
                        JarUtils.unjar((InputStream)archiveUrl.openStream(), (File)dest);
                        File webInf = new File(dest, "WEB-INF");
                        if (webInf.exists()) {
                            innerUrlList.add(webInf.toURL());
                            innerUrlList.add(new File(webInf, "classes").toURL());
                        }
                    }
                    urls.addAll(innerUrlList);
                    break block11;
                }
                if (archiveUrl.toString().endsWith(".jar") || archiveUrl.toString().endsWith(".jar/")) {
                    if (new File(archiveUrl.getPath()).exists()) {
                        urls.add(archiveUrl);
                    } else {
                        File dest = this.getTempDir(archiveUrl);
                        JarUtils.unjar((InputStream)archiveUrl.openStream(), (File)dest);
                        urls.add(dest.toURL());
                    }
                    break block11;
                }
                if (archiveUrl.toString().endsWith(".war/")) {
                    File webInf = new File(archiveUrl.getFile(), "WEB-INF");
                    if (webInf.exists()) {
                        urls.add(webInf.toURL());
                        urls.add(new File(webInf, "classes").toURL());
                    }
                    break block11;
                }
                throw new WebServiceException("Unsupported deployment archive: " + archiveUrl);
            }
            catch (Exception e) {
                throw new WebServiceException("Cannot get classpath URLs for archive: " + archiveUrl, (Throwable)e);
            }
        }
        return urls.toArray(new URL[0]);
    }
}

