/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.metro;

import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.api.server.WebServiceContextDelegate;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Principal;
import java.util.HashMap;
import java.util.Map;
import org.jboss.wsf.stack.metro.MessageStreamContext;

public class MessageStreamConnectionImpl
implements WebServiceContextDelegate {
    private int status;
    private boolean isClosed;
    private InputStream inputStream;
    private OutputStream outputStream;
    private MessageStreamContext messageContext;
    private Map<String, String> requestHeaders = new HashMap<String, String>();
    private Map<String, String> responseHeaders;

    public MessageStreamConnectionImpl(MessageStreamContext context, InputStream in, OutputStream out) {
        this.outputStream = out;
        this.inputStream = in;
        this.messageContext = context;
        this.populateRequestHeaders();
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int statusCode) {
        this.status = statusCode;
    }

    public Map<String, String> getRequestHeaders() {
        return this.requestHeaders;
    }

    public void setRequestHeaders(Map<String, String> requestHeaders) {
        this.requestHeaders = requestHeaders;
    }

    public String getRequestHeader(String name) {
        return this.requestHeaders.get(name);
    }

    public Map<String, String> getResponseHeaders() {
        return this.responseHeaders;
    }

    public void setResponseHeaders(Map<String, String> responseHeaders) {
        this.responseHeaders = responseHeaders;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public void closeInput() {
        if (this.inputStream != null) {
            try {
                this.inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.inputStream = null;
        }
    }

    public void closeOutput() {
        if (this.outputStream != null) {
            try {
                this.outputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.outputStream = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (!this.isClosed) {
            MessageStreamConnectionImpl messageStreamConnectionImpl = this;
            synchronized (messageStreamConnectionImpl) {
                if (!this.isClosed) {
                    this.isClosed = true;
                    this.closeInput();
                    this.closeOutput();
                }
            }
        }
    }

    public void flush() throws IOException {
        if (this.outputStream != null) {
            this.outputStream.flush();
        }
    }

    public Principal getUserPrincipal(Packet request) {
        throw new UnsupportedOperationException();
    }

    public boolean isUserInRole(Packet request, String role) {
        throw new UnsupportedOperationException();
    }

    public String getEPRAddress(Packet request, WSEndpoint endpoint) {
        throw new UnsupportedOperationException();
    }

    public String getWSDLAddress(Packet request, WSEndpoint endpoint) {
        throw new UnsupportedOperationException();
    }

    private void populateRequestHeaders() {
        for (String s : this.messageContext.getRequestContext().keySet()) {
            this.requestHeaders.put(s, this.messageContext.getRequestContext().get(s));
        }
    }
}

