/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.metro.metadata;

import com.sun.xml.ws.transport.http.ResourceLoader;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.logging.Logger;
import org.jboss.wsf.spi.deployment.UnifiedVirtualFile;

public class VFSResourceLoader
implements ResourceLoader {
    private static final Logger log = Logger.getLogger(VFSResourceLoader.class);
    UnifiedVirtualFile vfs;

    public VFSResourceLoader(UnifiedVirtualFile vfs) {
        this.vfs = vfs;
    }

    public URL getResource(String path) throws MalformedURLException {
        try {
            UnifiedVirtualFile uvf;
            if (path.startsWith("/")) {
                path = path.substring(1, path.length());
            }
            return (uvf = this.vfs.findChild(path)) != null ? uvf.toURL() : null;
        }
        catch (IOException e) {
            throw new MalformedURLException(e.getMessage());
        }
    }

    public URL getCatalogFile() throws MalformedURLException {
        URL resource = null;
        try {
            resource = this.getResource("/WEB-INF/jax-ws-catalog.xml");
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return resource;
    }

    public Set<String> getResourcePaths(String path) {
        HashSet<String> resources = new HashSet<String>();
        resources.addAll(this.getFileResources(path));
        return resources;
    }

    private List<String> getFileResources(String path) {
        ArrayList<String> resources = new ArrayList<String>();
        try {
            if (path.startsWith("/")) {
                path = path.substring(1, path.length());
            }
            List list = this.vfs.findChild(path).getChildren();
            for (UnifiedVirtualFile uvf : list) {
                String name = uvf.getName();
                if (name == null || !name.endsWith(File.separator) && !name.endsWith(".xml") && !name.endsWith(".xsd") && !name.endsWith(".wsdl")) continue;
                resources.add(path + uvf.getName());
            }
        }
        catch (Throwable e) {
            log.error((Object)("Failed to read resource paths from '" + path + "': "), e);
        }
        return resources;
    }
}

