/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.jbws.embedded;

import java.net.URL;
import org.jboss.kernel.Kernel;
import org.jboss.logging.Logger;
import org.jboss.wsf.spi.ComposableRuntime;
import org.jboss.wsf.spi.SPIProvider;
import org.jboss.wsf.spi.SPIProviderResolver;
import org.jboss.wsf.spi.WSFRuntime;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.DeploymentAspectManager;
import org.jboss.wsf.spi.deployment.DeploymentAspectManagerFactory;
import org.jboss.wsf.spi.invocation.InvocationHandlerFactory;
import org.jboss.wsf.spi.invocation.RequestHandlerFactory;
import org.jboss.wsf.spi.management.EndpointRegistry;
import org.jboss.wsf.spi.management.EndpointRegistryFactory;
import org.jboss.wsf.spi.transport.TransportManagerFactory;
import org.jboss.wsf.stack.jbws.embedded.EmbeddedBootstrap;

public class EmbeddableWSFRuntime
implements WSFRuntime,
ComposableRuntime {
    private static final Logger log;
    private SPIProvider spi;
    private Kernel kernel;
    private DeploymentAspectManager deploymentManager;
    private EndpointRegistry endpointRegistry;
    private RequestHandlerFactory rqhFactory;
    private InvocationHandlerFactory ivhFactory;
    private TransportManagerFactory tmFactory;
    public static URL DEFAULT_CONFIG_URL;

    private EmbeddableWSFRuntime(Kernel kernel) {
        this.kernel = kernel;
        this.spi = SPIProviderResolver.getInstance().getProvider();
    }

    public static EmbeddableWSFRuntime bootstrap(URL jbosswsBeansXml) throws Exception {
        log.debug((Object)"Bootstrap runtime from microcontainer config");
        EmbeddedBootstrap bootstrap = new EmbeddedBootstrap();
        bootstrap.run();
        bootstrap.deploy(jbosswsBeansXml);
        Kernel kernel = bootstrap.getKernel();
        EmbeddableWSFRuntime container = new EmbeddableWSFRuntime(kernel);
        container.assemble();
        return container;
    }

    private void assemble() {
        log.info((Object)"Assembling runtime");
        this.setDeploymentAspectManager(((DeploymentAspectManagerFactory)this.spi.getSPI(DeploymentAspectManagerFactory.class)).getDeploymentAspectManager("WSDeploymentAspectManagerJSE"));
        this.setEndpointRegistry(((EndpointRegistryFactory)this.spi.getSPI(EndpointRegistryFactory.class)).getEndpointRegistry());
        this.setTransportManagerFactory((TransportManagerFactory)this.spi.getSPI(TransportManagerFactory.class));
        this.setRequestHandlerFactory((RequestHandlerFactory)this.spi.getSPI(RequestHandlerFactory.class));
        this.setInvocationHandlerFactory((InvocationHandlerFactory)this.spi.getSPI(InvocationHandlerFactory.class));
    }

    public void create(Deployment deployment) {
        this.deploymentManager.create(deployment, (WSFRuntime)this);
    }

    public void start(Deployment deployment) {
        this.deploymentManager.start(deployment, (WSFRuntime)this);
    }

    public void stop(Deployment deployment) {
        this.deploymentManager.stop(deployment, (WSFRuntime)this);
    }

    public void destroy(Deployment deployment) {
        this.deploymentManager.destroy(deployment, (WSFRuntime)this);
    }

    public void setTransportManagerFactory(TransportManagerFactory factory) {
        assert (factory != null);
        log.info((Object)("Using TransportManagerFactory: " + factory));
        this.tmFactory = factory;
    }

    public TransportManagerFactory getTransportManagerFactory() {
        return this.tmFactory;
    }

    public void setEndpointRegistry(EndpointRegistry endpointRegistry) {
        assert (endpointRegistry != null);
        log.info((Object)("Using EndpointRegistry: " + endpointRegistry));
        this.endpointRegistry = endpointRegistry;
    }

    public EndpointRegistry getEndpointRegistry() {
        return this.endpointRegistry;
    }

    public void setDeploymentAspectManager(DeploymentAspectManager deploymentManager) {
        assert (deploymentManager != null);
        log.info((Object)("Using DeploymentAspectManager: " + deploymentManager));
        this.deploymentManager = deploymentManager;
    }

    public DeploymentAspectManager getDeploymentAspectManager() {
        return this.deploymentManager;
    }

    public void setRequestHandlerFactory(RequestHandlerFactory factory) {
        assert (factory != null);
        log.info((Object)("Using RequestHandlerFactory: " + factory));
        this.rqhFactory = factory;
    }

    public RequestHandlerFactory getRequestHandlerFactory() {
        return this.rqhFactory;
    }

    public void setInvocationHandlerFactory(InvocationHandlerFactory factory) {
        assert (factory != null);
        log.info((Object)("Using InvocationHandlerFactory: " + factory));
        this.ivhFactory = factory;
    }

    public InvocationHandlerFactory getInvocationHandlerFactory() {
        return this.ivhFactory;
    }

    static {
        String config;
        log = Logger.getLogger(EmbeddableWSFRuntime.class);
        ClassLoader cl = EmbeddableWSFRuntime.class.getClassLoader();
        DEFAULT_CONFIG_URL = cl.getResource(config = "org/jboss/wsf/stack/jbws/embedded/standalone-config.xml");
        if (null == DEFAULT_CONFIG_URL) {
            throw new RuntimeException("Unable to read config: " + config);
        }
    }
}

