/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.jbws.embedded;

import java.net.URL;
import org.jboss.kernel.plugins.bootstrap.basic.BasicBootstrap;
import org.jboss.kernel.plugins.deployment.xml.BasicXMLDeployer;
import org.jboss.logging.Logger;

public class EmbeddedBootstrap
extends BasicBootstrap {
    protected BasicXMLDeployer deployer;
    private final Logger log = Logger.getLogger(((Object)((Object)this)).getClass());

    public void bootstrap() throws Throwable {
        super.bootstrap();
        this.deployer = new BasicXMLDeployer(this.getKernel());
        Runtime.getRuntime().addShutdownHook(new Shutdown());
    }

    public void deploy(URL url) {
        try {
            this.log.info((Object)("Deploy MC configuration " + url));
            if (this.deployer.getDeploymentNames().contains(url.toString())) {
                System.out.println("Service is already deployed.");
                return;
            }
            this.deployer.deploy(url);
        }
        catch (Throwable t) {
            throw new RuntimeException("Error during deployment: " + url, t);
        }
    }

    public void undeploy(URL url) {
        this.log.info((Object)("Undeploy MC config " + url));
        if (!this.deployer.getDeploymentNames().contains(url.toString())) {
            System.out.println("Service is already undeployed.");
            return;
        }
        try {
            this.deployer.undeploy(url);
        }
        catch (Throwable t) {
            throw new RuntimeException("Error during undeployment: " + url, t);
        }
    }

    protected class Shutdown
    extends Thread {
        protected Shutdown() {
        }

        public void run() {
            EmbeddedBootstrap.this.log.info((Object)"Shutting down");
            EmbeddedBootstrap.this.deployer.shutdown();
        }
    }
}

