/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.jbws.embedded;

import org.jboss.wsf.spi.SPIProvider;
import org.jboss.wsf.spi.SPIProviderResolver;
import org.jboss.wsf.spi.WSFRuntime;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.DeploymentAspect;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.transport.HttpSpec;
import org.jboss.wsf.spi.transport.ListenerRef;
import org.jboss.wsf.spi.transport.Protocol;
import org.jboss.wsf.spi.transport.TransportManager;
import org.jboss.wsf.spi.transport.TransportManagerFactory;
import org.jboss.wsf.spi.transport.TransportSpec;

public class HttpEndpointPublishAspect
extends DeploymentAspect {
    private SPIProvider spi = SPIProviderResolver.getInstance().getProvider();
    private TransportManagerFactory tmf = (TransportManagerFactory)this.spi.getSPI(TransportManagerFactory.class);
    private TransportManager<HttpSpec> http = this.tmf.createTransportManager(Protocol.HTTP);

    public void start(Deployment dep, WSFRuntime runtime) {
        String webcontext = dep.getService().getContextRoot();
        assert (webcontext != null);
        assert (dep.getService().getEndpoints().size() > 0);
        for (Endpoint endpoint : dep.getService().getEndpoints()) {
            String urlPattern = endpoint.getURLPattern();
            HttpSpec spec = new HttpSpec(webcontext, urlPattern);
            ListenerRef ref = this.http.createListener(endpoint, (TransportSpec)spec);
            endpoint.setAddress(ref.getAddress().toString());
            endpoint.addAttachment(ListenerRef.class, (Object)ref);
        }
    }

    public void stop(Deployment dep, WSFRuntime runtime) {
        assert (dep.getService().getEndpoints().size() > 0);
        for (Endpoint endpoint : dep.getService().getEndpoints()) {
            ListenerRef ref = (ListenerRef)endpoint.getAttachment(ListenerRef.class);
            assert (ref != null);
            this.http.destroyListener(ref);
        }
    }
}

