/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.soap;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Properties;

class SAAJFactoryLoader {
    private SAAJFactoryLoader() {
    }

    public static Object loadFactory(String propertyName, String defaultFactory) {
        String filename;
        InputStream inStream;
        Class<?> factoryClass;
        String javaHome;
        File jaxmFile;
        Class<?> factoryClass2;
        Object factory = null;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        PrivilegedAction action = new PropertyAccessAction(propertyName);
        String factoryName = (String)AccessController.doPrivileged(action);
        if (factoryName != null) {
            try {
                factoryClass2 = loader.loadClass(factoryName);
                factory = factoryClass2.newInstance();
            }
            catch (Throwable t) {
                throw new IllegalStateException("Failed to load " + propertyName + ": " + factoryName, t);
            }
        }
        if (factory == null && (jaxmFile = new File((javaHome = (String)AccessController.doPrivileged(action = new PropertyAccessAction("java.home"))) + "/lib/jaxm.properties")).exists()) {
            try {
                action = new PropertyFileAccessAction(jaxmFile.getCanonicalPath());
                Properties jaxmProperties = (Properties)AccessController.doPrivileged(action);
                factoryName = jaxmProperties.getProperty(propertyName);
                if (factoryName != null) {
                    factoryClass = loader.loadClass(factoryName);
                    factory = factoryClass.newInstance();
                }
            }
            catch (Throwable t) {
                throw new IllegalStateException("Failed to load " + propertyName + ": " + factoryName, t);
            }
        }
        if (factory == null && (inStream = loader.getResourceAsStream(filename = "META-INF/services/" + propertyName)) != null) {
            try {
                BufferedReader br = new BufferedReader(new InputStreamReader(inStream, "UTF-8"));
                factoryName = br.readLine();
                br.close();
                if (factoryName != null) {
                    factoryClass = loader.loadClass(factoryName);
                    factory = factoryClass.newInstance();
                }
            }
            catch (Throwable t) {
                throw new IllegalStateException("Failed to load " + propertyName + ": " + factoryName, t);
            }
        }
        if (factory == null && defaultFactory != null) {
            try {
                factoryName = defaultFactory;
                factoryClass2 = loader.loadClass(factoryName);
                factory = factoryClass2.newInstance();
            }
            catch (Throwable t) {
                throw new IllegalStateException("Failed to load " + propertyName + ": " + factoryName, t);
            }
        }
        return factory;
    }

    private static class PropertyFileAccessAction
    implements PrivilegedAction {
        private String filename;

        PropertyFileAccessAction(String filename) {
            this.filename = filename;
        }

        public Object run() {
            try {
                FileInputStream inStream = new FileInputStream(this.filename);
                Properties props = new Properties();
                props.load(inStream);
                return props;
            }
            catch (IOException ex) {
                throw new SecurityException("Cannot load properties: " + this.filename, ex);
            }
        }
    }

    private static class PropertyAccessAction
    implements PrivilegedAction {
        private String name;

        PropertyAccessAction(String name) {
            this.name = name;
        }

        public Object run() {
            return System.getProperty(this.name);
        }
    }
}

