/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.plugins.tools;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.maven.plugin.logging.Log;
import org.jboss.ws.plugins.tools.Util;
import org.jboss.ws.plugins.tools.WSContractConsumerParams;
import org.jboss.ws.plugins.tools.WSContractProviderParams;

public class WSContractDelegate {
    private static final PrintStream PS = System.out;
    private static final String FS = System.getProperty("file.separator");
    private Log log;

    public WSContractDelegate(Log log) {
        this.log = log;
    }

    public void runProvider(WSContractProviderParams params) throws Exception {
        this.log.warn((CharSequence)"run provider");
        this.log.warn((CharSequence)("source=" + params.getSourceDirectory()));
        this.log.warn((CharSequence)("dest=" + params.getOutputDirectory()));
        if (params.isFork() || Util.getJVMMajorVersion() > 8) {
            this.log.warn((CharSequence)"run out of process");
            this.runProviderOutOfProcess(params);
        } else {
            this.log.warn((CharSequence)"run in process");
            this.runProviderInProcess(params);
        }
    }

    private void runProviderInProcess(WSContractProviderParams params) throws Exception {
        URLClassLoader loader = params.getLoader();
        Class<?> providerClass = loader.loadClass("org.jboss.ws.api.tools.WSContractProvider");
        Object provider = providerClass.getMethod("newInstance", new Class[0]).invoke(null, new Object[0]);
        WSContractDelegate.setupProvider(providerClass, provider, params);
        Method m = providerClass.getMethod("provide", String.class);
        m.invoke(provider, params.getEndpointClass());
    }

    private void runProviderOutOfProcess(WSContractProviderParams params) throws Exception {
        List<String> commandList = WSContractDelegate.initCommandList(params.getArgLine(), params.getManifestOnlyJar(), "org.jboss.ws.tools.cmd.WSProvide");
        WSContractDelegate.getProviderCommandLine(commandList, params);
        this.log.warn((CharSequence)("Running command line: " + commandList));
        ProcessBuilder pb = new ProcessBuilder(commandList);
        Process p = pb.start();
        new RT("provider output", p.getInputStream()).start();
        new RT("provider error", p.getErrorStream()).start();
        int result = p.waitFor();
        if (result != 0) {
            throw new Exception("Process terminated with code " + result);
        }
    }

    public void runConsumer(WSContractConsumerParams params, String wsdl) throws Exception {
        this.log.warn((CharSequence)("run consumer " + wsdl));
        this.log.warn((CharSequence)("source=" + params.getSourceDirectory()));
        this.log.warn((CharSequence)("output=" + params.getOutputDirectory()));
        if (params.isFork() || Util.getJVMMajorVersion() > 8) {
            this.log.warn((CharSequence)"run consumer out of process");
            this.runConsumerOutOfProcess(params, wsdl);
        } else {
            this.log.warn((CharSequence)"run consumer in process");
            this.runConsumerInProcess(params, wsdl);
        }
    }

    private void runConsumerInProcess(WSContractConsumerParams params, String wsdl) throws Exception {
        URLClassLoader loader = params.getLoader();
        Class<?> consumerClass = loader.loadClass("org.jboss.ws.api.tools.WSContractConsumer");
        Object consumer = consumerClass.getMethod("newInstance", new Class[0]).invoke(null, new Object[0]);
        WSContractDelegate.setupConsumer(consumerClass, consumer, params);
        Method m = consumerClass.getMethod("consume", String.class);
        m.invoke(consumer, wsdl);
    }

    private void runConsumerOutOfProcess(WSContractConsumerParams params, String wsdl) throws Exception {
        List<String> commandList = WSContractDelegate.initCommandList(params.getArgLine(), params.getManifestOnlyJar(), "org.jboss.ws.tools.cmd.WSConsume");
        WSContractDelegate.getConsumerCommandLine(commandList, params, wsdl);
        this.log.warn((CharSequence)("Running command line: " + commandList));
        ProcessBuilder pb = new ProcessBuilder(commandList);
        Process p = pb.start();
        new RT("consumer output", p.getInputStream()).start();
        new RT("consumer error", p.getErrorStream()).start();
        int result = p.waitFor();
        if (result != 0) {
            throw new Exception("Process terminated with code " + result);
        }
    }

    private static List<String> initCommandList(String argLine, File manifestOnlyJar, String toolClass) throws Exception {
        ArrayList<String> commandList = new ArrayList<String>();
        String fileName = System.getProperty("os.name", "").startsWith("Windows") ? "java.exe" : "java";
        File javaFile = new File(System.getProperty("java.home") + FS + "bin" + FS + fileName);
        commandList.add(javaFile.exists() ? javaFile.getCanonicalPath() : "java");
        if (argLine != null) {
            commandList.add(argLine);
        }
        if (Util.getJVMMajorVersion() > 8) {
            commandList.add("--add-modules=java.compiler");
        }
        commandList.add("-classpath");
        commandList.add(manifestOnlyJar.getCanonicalPath());
        commandList.add(toolClass);
        return commandList;
    }

    private static void getConsumerCommandLine(List<String> commandList, WSContractConsumerParams params, String wsdl) {
        List<String> bindingFiles = params.getBindingFiles();
        if (bindingFiles != null && !bindingFiles.isEmpty()) {
            commandList.add("-b");
            commandList.addAll(bindingFiles);
        }
        if (params.isGenerateSource()) {
            commandList.add("-k");
        }
        if (params.getCatalog() != null) {
            commandList.add("-c");
            commandList.add(params.getCatalog().getAbsolutePath());
        }
        if (params.getTargetPackage() != null) {
            commandList.add("-p");
            commandList.add(params.getTargetPackage());
        }
        if (params.getWsdlLocation() != null) {
            commandList.add("-w");
            commandList.add(params.getWsdlLocation());
        }
        if (params.getEncoding() != null) {
            commandList.add("-d");
            commandList.add(params.getEncoding());
        }
        if (params.getOutputDirectory() != null) {
            commandList.add("-o");
            commandList.add(params.getOutputDirectory().getAbsolutePath());
        }
        if (params.getSourceDirectory() != null) {
            commandList.add("-s");
            commandList.add(params.getSourceDirectory().getAbsolutePath());
        }
        if (params.getTarget() != null) {
            commandList.add("-t");
            commandList.add(params.getTarget());
        }
        if (params.isExtension()) {
            commandList.add("-e");
        }
        if (params.isNoCompile()) {
            commandList.add("-n");
        }
        if (params.isAdditionalHeaders()) {
            commandList.add("-a");
        }
        commandList.add(wsdl);
    }

    private static void getProviderCommandLine(List<String> commandList, WSContractProviderParams params) {
        if (params.isGenerateSource()) {
            commandList.add("-k");
        }
        if (params.isGenerateWsdl()) {
            commandList.add("-w");
        }
        if (params.getOutputDirectory() != null) {
            commandList.add("-o");
            commandList.add(params.getOutputDirectory().getAbsolutePath());
        }
        if (params.getSourceDirectory() != null) {
            commandList.add("-s");
            commandList.add(params.getSourceDirectory().getAbsolutePath());
        }
        if (params.getResourceDirectory() != null) {
            commandList.add("-r");
            commandList.add(params.getResourceDirectory().getAbsolutePath());
        }
        if (params.isExtension()) {
            commandList.add("-e");
        }
        if (params.getPortSoapAddress() != null) {
            commandList.add("-a");
            commandList.add(params.getPortSoapAddress());
        }
        commandList.add(params.getEndpointClass());
    }

    private static void setupConsumer(Class<?> consumerClass, Object consumer, WSContractConsumerParams params) throws Exception {
        WSContractDelegate.callMethod(consumerClass, consumer, "setAdditionalCompilerClassPath", params.getAdditionalCompilerClassPath());
        Method m = consumerClass.getMethod("setMessageStream", PrintStream.class);
        m.invoke(consumer, PS);
        List<String> bindingFiles = params.getBindingFiles();
        if (bindingFiles != null && !bindingFiles.isEmpty()) {
            LinkedList<File> files = new LinkedList<File>();
            for (String bf : bindingFiles) {
                files.add(new File(bf));
            }
            WSContractDelegate.callMethod(consumerClass, consumer, "setBindingFiles", files);
        }
        if (params.getCatalog() != null) {
            WSContractDelegate.callMethod(consumerClass, consumer, "setCatalog", params.getCatalog());
        }
        WSContractDelegate.callMethod(consumerClass, consumer, "setAdditionalHeaders", params.isAdditionalHeaders());
        WSContractDelegate.callMethod(consumerClass, consumer, "setExtension", params.isExtension());
        WSContractDelegate.callMethod(consumerClass, consumer, "setGenerateSource", params.isGenerateSource());
        WSContractDelegate.callMethod(consumerClass, consumer, "setNoCompile", params.isNoCompile());
        if (params.getOutputDirectory() != null) {
            WSContractDelegate.callMethod(consumerClass, consumer, "setOutputDirectory", params.getOutputDirectory());
        }
        if (params.getSourceDirectory() != null) {
            WSContractDelegate.callMethod(consumerClass, consumer, "setSourceDirectory", params.getSourceDirectory());
        }
        if (params.getTarget() != null) {
            WSContractDelegate.callMethod(consumerClass, consumer, "setTarget", params.getTarget());
        }
        if (params.getTargetPackage() != null) {
            WSContractDelegate.callMethod(consumerClass, consumer, "setTargetPackage", params.getTargetPackage());
        }
        if (params.getWsdlLocation() != null) {
            WSContractDelegate.callMethod(consumerClass, consumer, "setWsdlLocation", params.getWsdlLocation());
        }
        if (params.getEncoding() != null) {
            WSContractDelegate.callMethod(consumerClass, consumer, "setEncoding", params.getEncoding());
        }
    }

    private static Object callMethod(Class<?> clazz, Object obj, String name, boolean param) throws Exception {
        Method m = clazz.getMethod(name, Boolean.TYPE);
        return m.invoke(obj, param);
    }

    private static <T> Object callMethod(Class<?> clazz, Object obj, String name, T param) throws Exception {
        Method m = clazz.getMethod(name, param.getClass());
        return m.invoke(obj, param);
    }

    private static Object callMethod(Class<?> clazz, Object obj, String name, List param) throws Exception {
        Method m = clazz.getMethod(name, List.class);
        return m.invoke(obj, param);
    }

    private static void setupProvider(Class<?> providerClass, Object provider, WSContractProviderParams params) throws Exception {
        Method m = providerClass.getMethod("setClassLoader", ClassLoader.class);
        m.invoke(provider, params.getLoader());
        WSContractDelegate.callMethod(providerClass, provider, "setExtension", params.isExtension());
        WSContractDelegate.callMethod(providerClass, provider, "setGenerateSource", params.isGenerateSource());
        WSContractDelegate.callMethod(providerClass, provider, "setGenerateWsdl", params.isGenerateWsdl());
        Method m2 = providerClass.getMethod("setMessageStream", PrintStream.class);
        m2.invoke(provider, PS);
        if (params.getOutputDirectory() != null) {
            WSContractDelegate.callMethod(providerClass, provider, "setOutputDirectory", params.getOutputDirectory());
        }
        if (params.getResourceDirectory() != null) {
            WSContractDelegate.callMethod(providerClass, provider, "setResourceDirectory", params.getResourceDirectory());
        }
        if (params.getSourceDirectory() != null) {
            WSContractDelegate.callMethod(providerClass, provider, "setSourceDirectory", params.getSourceDirectory());
        }
        if (params.getPortSoapAddress() != null) {
            WSContractDelegate.callMethod(providerClass, provider, "setPortSoapAddress", params.getPortSoapAddress());
        }
    }

    private class RT
    extends Thread {
        private final InputStream is;
        private final String name;

        public RT(String name, InputStream is) {
            this.setDaemon(true);
            this.name = name;
            this.is = is;
        }

        @Override
        public void run() {
            try (BufferedReader br = new BufferedReader(new InputStreamReader(this.is));){
                String l;
                while ((l = br.readLine()) != null) {
                    WSContractDelegate.this.log.info((CharSequence)(this.name + ": " + l));
                }
            }
            catch (IOException e) {
                WSContractDelegate.this.log.warn((CharSequence)"could not read", (Throwable)e);
            }
        }
    }
}

