/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.as.juddi.service;

import org.jboss.logging.Logger;
import org.jboss.msc.service.AbstractService;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

/**
 * The configuration service of the jUDDI server
 *
 * @author Thomas.Diesler@jboss.com
 * @since 22-Nov-2011
 */
public class JUDDIConfigurationService extends AbstractService<JUDDIConfiguration> {

    static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append("juddi", "configuration");

    // [TODO] AS7-2277 JAXR subsystem i18n
    private final Logger log = Logger.getLogger(JUDDIConfigurationService.class);

    private final JUDDIConfiguration config = new JUDDIConfiguration();

    public static ServiceController<?> addService(final ServiceTarget target, final ServiceListener<Object>... listeners) {
        JUDDIConfigurationService service = new JUDDIConfigurationService();
        ServiceBuilder<?> builder = target.addService(SERVICE_NAME, service);
        builder.addListener(listeners);
        return builder.install();
    }

    // Hide ctor
    private JUDDIConfigurationService() {
    }

    @Override
    public void start(StartContext context) throws StartException {
        ClassLoader classLoader = getClass().getClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream("/WEB-INF/juddi.properties");
        try {
            Properties props = new Properties();
            props.load(inputStream);
            String defaultbinding = props.getProperty("juddi.dataSource");
            config.setDataSourceBinding(SecurityActions.getSystemProperty("juddi.dataSource", defaultbinding));
            config.setDropOnStart(Boolean.parseBoolean(props.getProperty("juddi.drop-on-start")));
            config.setCreateOnStart(Boolean.parseBoolean(props.getProperty("juddi.create-on-start")));
            config.setDropOnStop(Boolean.parseBoolean(props.getProperty("juddi.drop-on-stop")));
        } catch (IOException e) {
            throw new StartException("Cannot load juddi.properties");
        }
    }

    @Override
    public JUDDIConfiguration getValue() throws IllegalStateException {
        synchronized (config) {
            return config;
        }
    }
}
