/*
 * Decompiled with CFR 0.152.
 */
package org.xnio.channels;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.concurrent.TimeUnit;
import org.xnio.Buffers;
import org.xnio.ChannelListener;
import org.xnio.Option;
import org.xnio.channels.AcceptingChannel;
import org.xnio.channels.ByteChannel;
import org.xnio.channels.CloseableChannel;
import org.xnio.channels.Configurable;
import org.xnio.channels.ConnectedChannel;
import org.xnio.channels.ReadableMessageChannel;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.channels.StreamSourceChannel;
import org.xnio.channels.SuspendableReadChannel;
import org.xnio.channels.SuspendableWriteChannel;
import org.xnio.channels.WritableMessageChannel;

public final class Channels {
    private Channels() {
    }

    public static void flushBlocking(SuspendableWriteChannel channel) throws IOException {
        while (!channel.flush()) {
            channel.awaitWritable();
        }
    }

    public static void shutdownWritesBlocking(SuspendableWriteChannel channel) throws IOException {
        while (!channel.shutdownWrites()) {
            channel.awaitWritable();
        }
    }

    public static <C extends WritableByteChannel & SuspendableWriteChannel> int writeBlocking(C channel, ByteBuffer buffer) throws IOException {
        int t = 0;
        while (buffer.hasRemaining()) {
            int res = channel.write(buffer);
            if (res == 0) {
                ((SuspendableWriteChannel)channel).awaitWritable();
                continue;
            }
            t += res;
        }
        return t;
    }

    public static <C extends WritableByteChannel & SuspendableWriteChannel> int writeBlocking(C channel, ByteBuffer buffer, long time, TimeUnit unit) throws IOException {
        long remaining = unit.toMillis(time);
        long now = System.currentTimeMillis();
        int t = 0;
        while (buffer.hasRemaining() && remaining > 0L) {
            int res = channel.write(buffer);
            if (res == 0) {
                ((SuspendableWriteChannel)channel).awaitWritable(remaining, TimeUnit.MILLISECONDS);
                long l = -now;
                now = System.currentTimeMillis();
                remaining -= Math.max(l + now, 0L);
                continue;
            }
            t += res;
        }
        return t;
    }

    public static <C extends GatheringByteChannel & SuspendableWriteChannel> long writeBlocking(C channel, ByteBuffer[] buffers, int offs, int len) throws IOException {
        long t = 0L;
        while (Buffers.hasRemaining(buffers, offs, len)) {
            long res = channel.write(buffers, offs, len);
            if (res == 0L) {
                ((SuspendableWriteChannel)channel).awaitWritable();
                continue;
            }
            t += res;
        }
        return t;
    }

    public static <C extends GatheringByteChannel & SuspendableWriteChannel> long writeBlocking(C channel, ByteBuffer[] buffers, int offs, int len, long time, TimeUnit unit) throws IOException {
        long remaining = unit.toMillis(time);
        long now = System.currentTimeMillis();
        long t = 0L;
        while (Buffers.hasRemaining(buffers, offs, len) && remaining > 0L) {
            long res = channel.write(buffers, offs, len);
            if (res == 0L) {
                ((SuspendableWriteChannel)channel).awaitWritable(remaining, TimeUnit.MILLISECONDS);
                long l = -now;
                now = System.currentTimeMillis();
                remaining -= Math.max(l + now, 0L);
                continue;
            }
            t += res;
        }
        return t;
    }

    public static <C extends WritableMessageChannel> void sendBlocking(C channel, ByteBuffer buffer) throws IOException {
        while (!channel.send(buffer)) {
            channel.awaitWritable();
        }
    }

    public static <C extends WritableMessageChannel> boolean sendBlocking(C channel, ByteBuffer buffer, long time, TimeUnit unit) throws IOException {
        long l;
        long now = System.currentTimeMillis();
        for (long remaining = unit.toMillis(time); remaining > 0L; remaining -= Math.max(l + now, 0L)) {
            if (!channel.send(buffer)) {
                channel.awaitWritable(remaining, TimeUnit.MILLISECONDS);
                l = -now;
                now = System.currentTimeMillis();
                continue;
            }
            return true;
        }
        return false;
    }

    public static <C extends WritableMessageChannel> void sendBlocking(C channel, ByteBuffer[] buffers, int offs, int len) throws IOException {
        while (!channel.send(buffers, offs, len)) {
            channel.awaitWritable();
        }
    }

    public static <C extends WritableMessageChannel> boolean sendBlocking(C channel, ByteBuffer[] buffers, int offs, int len, long time, TimeUnit unit) throws IOException {
        long l;
        long now = System.currentTimeMillis();
        for (long remaining = unit.toMillis(time); remaining > 0L; remaining -= Math.max(l + now, 0L)) {
            if (!channel.send(buffers, offs, len)) {
                channel.awaitWritable(remaining, TimeUnit.MILLISECONDS);
                l = -now;
                now = System.currentTimeMillis();
                continue;
            }
            return true;
        }
        return false;
    }

    public static <C extends ReadableByteChannel & SuspendableReadChannel> int readBlocking(C channel, ByteBuffer buffer) throws IOException {
        int res;
        while ((res = channel.read(buffer)) == 0 && buffer.hasRemaining()) {
            ((SuspendableReadChannel)channel).awaitReadable();
        }
        return res;
    }

    public static <C extends ReadableByteChannel & SuspendableReadChannel> int readBlocking(C channel, ByteBuffer buffer, long time, TimeUnit unit) throws IOException {
        int res = channel.read(buffer);
        if (res == 0 && buffer.hasRemaining()) {
            ((SuspendableReadChannel)channel).awaitReadable(time, unit);
            return channel.read(buffer);
        }
        return res;
    }

    public static <C extends ScatteringByteChannel & SuspendableReadChannel> long readBlocking(C channel, ByteBuffer[] buffers, int offs, int len) throws IOException {
        long res;
        while ((res = channel.read(buffers, offs, len)) == 0L) {
            ((SuspendableReadChannel)channel).awaitReadable();
        }
        return res;
    }

    public static <C extends ScatteringByteChannel & SuspendableReadChannel> long readBlocking(C channel, ByteBuffer[] buffers, int offs, int len, long time, TimeUnit unit) throws IOException {
        long res = channel.read(buffers, offs, len);
        if (res == 0L && Buffers.hasRemaining(buffers, offs, len)) {
            ((SuspendableReadChannel)channel).awaitReadable(time, unit);
            return channel.read(buffers, offs, len);
        }
        return res;
    }

    public static <C extends ReadableMessageChannel> int receiveBlocking(C channel, ByteBuffer buffer) throws IOException {
        int res;
        while ((res = channel.receive(buffer)) == 0) {
            channel.awaitReadable();
        }
        return res;
    }

    public static <C extends ReadableMessageChannel> int receiveBlocking(C channel, ByteBuffer buffer, long time, TimeUnit unit) throws IOException {
        int res = channel.receive(buffer);
        if (res == 0) {
            channel.awaitReadable(time, unit);
            return channel.receive(buffer);
        }
        return res;
    }

    public static <C extends ReadableMessageChannel> long receiveBlocking(C channel, ByteBuffer[] buffers, int offs, int len) throws IOException {
        long res;
        while ((res = channel.receive(buffers, offs, len)) == 0L) {
            channel.awaitReadable();
        }
        return res;
    }

    public static <C extends ReadableMessageChannel> long receiveBlocking(C channel, ByteBuffer[] buffers, int offs, int len, long time, TimeUnit unit) throws IOException {
        long res = channel.receive(buffers, offs, len);
        if (res == 0L) {
            channel.awaitReadable(time, unit);
            return channel.receive(buffers, offs, len);
        }
        return res;
    }

    public static <C extends ConnectedChannel, A extends AcceptingChannel<C>> C acceptBlocking(A channel) throws IOException {
        C accepted;
        while ((accepted = channel.accept()) == null) {
            channel.awaitAcceptable();
        }
        return accepted;
    }

    public static <C extends ConnectedChannel, A extends AcceptingChannel<C>> C acceptBlocking(A channel, long time, TimeUnit unit) throws IOException {
        C accepted = channel.accept();
        if (accepted == null) {
            channel.awaitAcceptable(time, unit);
            return channel.accept();
        }
        return accepted;
    }

    public static void transferBlocking(StreamSinkChannel destination, FileChannel source, long startPosition, long count) throws IOException {
        long remaining = count;
        while (remaining > 0L) {
            long res;
            while ((res = destination.transferFrom(source, startPosition, remaining)) == 0L) {
                try {
                    destination.awaitWritable();
                }
                catch (InterruptedIOException e) {
                    long bytes = count - remaining;
                    if (bytes > Integer.MAX_VALUE) {
                        e.bytesTransferred = -1;
                        continue;
                    }
                    e.bytesTransferred = (int)bytes;
                }
            }
            remaining -= res;
            startPosition += res;
        }
    }

    public static void transferBlocking(FileChannel destination, StreamSourceChannel source, long startPosition, long count) throws IOException {
        long remaining = count;
        while (remaining > 0L) {
            long res;
            while ((res = source.transferTo(startPosition, remaining, destination)) == 0L) {
                try {
                    source.awaitReadable();
                }
                catch (InterruptedIOException e) {
                    long bytes = count - remaining;
                    if (bytes > Integer.MAX_VALUE) {
                        e.bytesTransferred = -1;
                        continue;
                    }
                    e.bytesTransferred = (int)bytes;
                }
            }
            remaining -= res;
            startPosition += res;
        }
    }

    public static <T extends CloseableChannel> void setCloseListener(T channel, ChannelListener<? super T> listener) {
        ChannelListener.Setter<? extends CloseableChannel> setter = channel.getCloseSetter();
        setter.set(listener);
    }

    public static <T extends AcceptingChannel<?>> void setAcceptListener(T channel, ChannelListener<? super T> listener) {
        ChannelListener.Setter<AcceptingChannel<?>> setter = channel.getAcceptSetter();
        setter.set(listener);
    }

    public static <T extends SuspendableReadChannel> void setReadListener(T channel, ChannelListener<? super T> listener) {
        ChannelListener.Setter<? extends SuspendableReadChannel> setter = channel.getReadSetter();
        setter.set(listener);
    }

    public static <T extends SuspendableWriteChannel> void setWriteListener(T channel, ChannelListener<? super T> listener) {
        ChannelListener.Setter<? extends SuspendableWriteChannel> setter = channel.getWriteSetter();
        setter.set(listener);
    }

    public static ByteChannel wrapByteChannel(final ByteChannel original) {
        return new ByteChannel(){

            @Override
            public int read(ByteBuffer dst) throws IOException {
                return original.read(dst);
            }

            @Override
            public boolean isOpen() {
                return original.isOpen();
            }

            @Override
            public void close() throws IOException {
                original.close();
            }

            @Override
            public int write(ByteBuffer src) throws IOException {
                return original.write(src);
            }

            @Override
            public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
                return original.write(srcs, offset, length);
            }

            @Override
            public long write(ByteBuffer[] srcs) throws IOException {
                return original.write(srcs);
            }

            @Override
            public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
                return original.read(dsts, offset, length);
            }

            @Override
            public long read(ByteBuffer[] dsts) throws IOException {
                return original.read(dsts);
            }
        };
    }

    public static <T> T getOption(Configurable configurable, Option<T> option, T defaultValue) {
        try {
            T value = configurable.getOption(option);
            return value == null ? defaultValue : value;
        }
        catch (IOException e) {
            return defaultValue;
        }
    }

    public static boolean getOption(Configurable configurable, Option<Boolean> option, boolean defaultValue) {
        try {
            Boolean value = configurable.getOption(option);
            return value == null ? defaultValue : value;
        }
        catch (IOException e) {
            return defaultValue;
        }
    }

    public static int getOption(Configurable configurable, Option<Integer> option, int defaultValue) {
        try {
            Integer value = configurable.getOption(option);
            return value == null ? defaultValue : value;
        }
        catch (IOException e) {
            return defaultValue;
        }
    }

    public static long getOption(Configurable configurable, Option<Long> option, long defaultValue) {
        try {
            Long value = configurable.getOption(option);
            return value == null ? defaultValue : value;
        }
        catch (IOException e) {
            return defaultValue;
        }
    }
}

