/*
 * Decompiled with CFR 0.152.
 */
package org.xnio.conduits;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.xnio.channels.StreamSourceChannel;
import org.xnio.conduits.AbstractStreamSinkConduit;
import org.xnio.conduits.StreamSinkConduit;

public final class BlockingStreamSinkConduit
extends AbstractStreamSinkConduit<StreamSinkConduit> {
    private boolean resumed;

    public BlockingStreamSinkConduit(StreamSinkConduit next) {
        super(next);
    }

    @Override
    public long transferFrom(FileChannel src, long position, long count) throws IOException {
        long res;
        if (this.resumed) {
            return ((StreamSinkConduit)this.next).transferFrom(src, position, count);
        }
        while ((res = ((StreamSinkConduit)this.next).transferFrom(src, position, count)) == 0L) {
            ((StreamSinkConduit)this.next).awaitWritable();
        }
        return res;
    }

    @Override
    public long transferFrom(StreamSourceChannel source, long count, ByteBuffer throughBuffer) throws IOException {
        long res;
        if (this.resumed) {
            return ((StreamSinkConduit)this.next).transferFrom(source, count, throughBuffer);
        }
        while ((res = ((StreamSinkConduit)this.next).transferFrom(source, count, throughBuffer)) == 0L) {
            ((StreamSinkConduit)this.next).awaitWritable();
        }
        return res;
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        int res;
        if (this.resumed) {
            return ((StreamSinkConduit)this.next).write(src);
        }
        while ((long)(res = ((StreamSinkConduit)this.next).write(src)) == 0L) {
            ((StreamSinkConduit)this.next).awaitWritable();
        }
        return res;
    }

    @Override
    public long write(ByteBuffer[] srcs, int offs, int len) throws IOException {
        long res;
        if (this.resumed) {
            return ((StreamSinkConduit)this.next).write(srcs, offs, len);
        }
        while ((res = ((StreamSinkConduit)this.next).write(srcs, offs, len)) == 0L) {
            ((StreamSinkConduit)this.next).awaitWritable();
        }
        return res;
    }

    @Override
    public boolean flush() throws IOException {
        if (this.resumed) {
            return ((StreamSinkConduit)this.next).flush();
        }
        while (!((StreamSinkConduit)this.next).flush()) {
            ((StreamSinkConduit)this.next).awaitWritable();
        }
        return true;
    }

    @Override
    public void resumeWrites() {
        this.resumed = true;
        ((StreamSinkConduit)this.next).resumeWrites();
    }

    @Override
    public void suspendWrites() {
        this.resumed = false;
        ((StreamSinkConduit)this.next).suspendWrites();
    }

    @Override
    public void wakeupWrites() {
        this.resumed = true;
        ((StreamSinkConduit)this.next).wakeupWrites();
    }

    @Override
    public boolean isWriteResumed() {
        return this.resumed;
    }
}

