/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xnio.deployer;

import java.io.Closeable;
import java.io.IOException;
import org.jboss.xnio.ConfigurableFactory;
import org.jboss.xnio.IoUtils;
import org.jboss.xnio.channels.ChannelOption;
import org.jboss.xnio.channels.CommonOptions;
import org.jboss.xnio.log.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class XnioController {
    private static final Logger log = Logger.getLogger((String)"org.jboss.xnio.deployer");
    private final ConfigurableFactory<? extends Closeable> configurableFactory;
    private Closeable handle;

    protected XnioController(ConfigurableFactory<? extends Closeable> factory) {
        this.configurableFactory = factory;
    }

    public void stop() {
        IoUtils.safeClose((Closeable)this.handle);
        this.handle = null;
    }

    public void start() throws IOException {
        this.handle = (Closeable)this.configurableFactory.create();
    }

    private <T> void doSetOption(ChannelOption<T> option, T value) throws IOException {
        ConfigurableFactory<? extends Closeable> factory = this.configurableFactory;
        if (value != null) {
            if (factory.getOptions().contains(option)) {
                factory.setOption(option, value);
            } else {
                log.debug("XNIO component does not support option \"%s\"", option);
            }
        }
    }

    public void setBacklog(Integer backlog) throws IOException {
        this.doSetOption(CommonOptions.BACKLOG, backlog);
    }

    public void setBroadcast(Boolean broadcast) throws IOException {
        this.doSetOption(CommonOptions.BROADCAST, broadcast);
    }

    public void setCloseAbort(Boolean closeAbort) throws IOException {
        this.doSetOption(CommonOptions.CLOSE_ABORT, closeAbort);
    }

    public void setIpTrafficClass(Integer ipTrafficClass) throws IOException {
        this.doSetOption(CommonOptions.IP_TRAFFIC_CLASS, ipTrafficClass);
    }

    public void setKeepAlive(Boolean keepAlive) throws IOException {
        this.doSetOption(CommonOptions.KEEP_ALIVE, keepAlive);
    }

    public void setManageConnections(Boolean manageConnections) throws IOException {
        this.doSetOption(CommonOptions.MANAGE_CONNECTIONS, manageConnections);
    }

    public void setMulticastTtl(Integer multicastTtl) throws IOException {
        this.doSetOption(CommonOptions.MULTICAST_TTL, multicastTtl);
    }

    public void setOobInline(Boolean oobInline) throws IOException {
        this.doSetOption(CommonOptions.TCP_OOB_INLINE, oobInline);
    }

    public void setReceiveBufferSize(Integer receiveBufferSize) throws IOException {
        this.doSetOption(CommonOptions.RECEIVE_BUFFER, receiveBufferSize);
    }

    public void setReuseAddresses(Boolean reuseAddresses) throws IOException {
        this.doSetOption(CommonOptions.REUSE_ADDRESSES, reuseAddresses);
    }

    public void setSendBufferSize(Integer sendBufferSize) throws IOException {
        this.doSetOption(CommonOptions.SEND_BUFFER, sendBufferSize);
    }

    public void setTcpNoDelay(Boolean tcpNoDelay) throws IOException {
        this.doSetOption(CommonOptions.TCP_NODELAY, tcpNoDelay);
    }
}

