/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xnio.helpers;

import java.io.Closeable;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.jboss.xnio.ChannelSource;
import org.jboss.xnio.IoHandler;
import org.jboss.xnio.IoUtils;
import org.jboss.xnio.channels.StreamChannel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConnectionHelper<T extends StreamChannel> {
    private Closeable connection;
    private int reconnectTime = -1;
    private ScheduledExecutorService scheduledExecutor;
    private ChannelSource<T> channelSource;
    private IoHandler<? super T> handler;

    public int getReconnectTime() {
        return this.reconnectTime;
    }

    public void setReconnectTime(int reconnectTime) {
        this.reconnectTime = reconnectTime;
    }

    public ScheduledExecutorService getScheduledExecutor() {
        return this.scheduledExecutor;
    }

    public void setScheduledExecutor(ScheduledExecutorService scheduledExecutor) {
        this.scheduledExecutor = scheduledExecutor;
    }

    public ChannelSource<T> getClient() {
        return this.channelSource;
    }

    public void setClient(ChannelSource<T> channelSource) {
        this.channelSource = channelSource;
    }

    public IoHandler<? super T> getHandler() {
        return this.handler;
    }

    public void setHandler(IoHandler<? super T> handler) {
        this.handler = handler;
    }

    public void start() {
        Executor reconnectExecutor = this.reconnectTime == -1 ? IoUtils.nullExecutor() : (this.reconnectTime == 0 ? IoUtils.directExecutor() : IoUtils.delayedExecutor((ScheduledExecutorService)this.scheduledExecutor, (long)this.reconnectTime, (TimeUnit)TimeUnit.MILLISECONDS));
        this.connection = IoUtils.createConnection(this.channelSource, this.handler, (Executor)reconnectExecutor);
    }

    public void stop() {
        IoUtils.safeClose((Closeable)this.connection);
    }
}

