/*
 * JBoss, Home of Professional Open Source
 * Copyright 2010, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.xnio.helpers;

import java.nio.channels.Channel;
import java.util.concurrent.Executor;
import org.jboss.xnio.ChannelListener;
import org.jboss.xnio.IoUtils;

public final class ChannelListenerService<T extends Channel> {
    private final ChannelListener<T> listener;
    private final ChannelListener.Setter<T> setter;
    private final Executor executor;

    public ChannelListenerService(final ChannelListener<T> listener, final ChannelListener.Setter<T> setter, final Executor executor) {
        this.listener = listener;
        this.setter = setter;
        this.executor = executor;
    }

    public void start() {
        final Executor executor = this.executor;
        setter.set(executor != null ? new ChannelListener<T>() {
            public void handleEvent(final T channel) {
                ChannelListenerService.this.executor.execute(IoUtils.getChannelListenerTask(channel, listener));
            }
        } : listener);
    }

    public void stop() {
        setter.set(null);
    }
}
