/*
 * JBoss, Home of Professional Open Source
 * Copyright 2009, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.xnio.metadata;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlElement;

import java.util.List;
import java.util.ArrayList;

@XmlType(name = "xnioProviderType", propOrder = {})
public final class ProviderMetaData implements OptionedMetaData {

    private List<OptionMetaData> options = arrayList();
    private OptionMetaData option;
    private RefMetaData executor;
    private RefMetaData threadFactory;
    private RefMetaData mbeanServer;
    private List<RefMetaData> mbeanServers;
    private String implementationName;
    private String name;

    private static <T> List<T> arrayList() {
        return new ArrayList<T>();
    }

    public List<OptionMetaData> getOptions() {
        return options;
    }

    @XmlElementWrapper(name = "options")
    @XmlElement(name = "option")
    public void setOptions(final List<OptionMetaData> options) {
        this.options = options;
    }

    public OptionMetaData getOption() {
        return option;
    }

    @XmlElement
    public void setOption(final OptionMetaData option) {
        this.option = option;
    }

    public RefMetaData getExecutor() {
        return executor;
    }

    @XmlElement
    public void setExecutor(final RefMetaData executor) {
        this.executor = executor;
    }

    public RefMetaData getThreadFactory() {
        return threadFactory;
    }

    @XmlElement(name = "thread-factory")
    public void setThreadFactory(final RefMetaData threadFactory) {
        this.threadFactory = threadFactory;
    }

    public RefMetaData getMbeanServer() {
        return mbeanServer;
    }

    @XmlElement(name = "mbean-server")
    public void setMbeanServer(final RefMetaData mbeanServer) {
        this.mbeanServer = mbeanServer;
    }

    public List<RefMetaData> getMbeanServers() {
        return mbeanServers;
    }

    @XmlElementWrapper(name = "mbean-servers")
    @XmlElement(name = "mbean-server")
    public void setMbeanServers(final List<RefMetaData> mbeanServers) {
        this.mbeanServers = mbeanServers;
    }

    public String getImplementationName() {
        return implementationName;
    }

    @XmlAttribute(name = "implementation-name")
    public void setImplementationName(final String implementationName) {
        this.implementationName = implementationName;
    }

    public String getName() {
        return name;
    }

    @XmlAttribute(required = true)
    public void setName(final String name) {
        this.name = name;
    }
}
