/*
 * JBoss, Home of Professional Open Source
 * Copyright 2010, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.xnio.metadata;

import java.util.ArrayList;
import java.util.List;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

@XmlType(name = "bindingType", propOrder = {})
public final class BindingMetaData {
    private List<SocketAddressMetaData> bindings = arrayList();
    private String forName;

    private static <T> List<T> arrayList() {
        return new ArrayList<T>();
    }

    public List<SocketAddressMetaData> getBindings() {
        return bindings;
    }

    @XmlElement(name = "bind-address")
    public void setBindings(final List<SocketAddressMetaData> bindings) {
        this.bindings = bindings;
    }

    public String getForName() {
        return forName;
    }

    @XmlAttribute(name = "for", required = true)
    public void setForName(final String forName) {
        this.forName = forName;
    }
}
