/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xnio.metadata;

import java.net.InetSocketAddress;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.jboss.util.StringPropertyReplacer;

@XmlType(name="socketAddressType", propOrder={})
public final class SocketAddressMetaData {
    private String address;
    private int port;

    public String getAddress() {
        return this.address;
    }

    @XmlAttribute
    public void setAddress(String address) {
        this.address = StringPropertyReplacer.replaceProperties((String)address);
    }

    public int getPort() {
        return this.port;
    }

    @XmlAttribute(required=true)
    public void setPort(int port) {
        this.port = port;
    }

    @XmlTransient
    public InetSocketAddress getSocketAddress() {
        InetSocketAddress addr;
        if (this.address == null) {
            addr = new InetSocketAddress(this.port);
        } else {
            addr = new InetSocketAddress(this.address, this.port);
            if (addr.isUnresolved()) {
                throw new IllegalArgumentException("Address \"" + this.address + "\" could not be resolved");
            }
        }
        return addr;
    }
}

