/*
 * JBoss, Home of Professional Open Source
 * Copyright 2010, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.xnio.helpers;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import org.jboss.xnio.IoUtils;
import org.jboss.xnio.channels.BoundChannel;
import org.jboss.xnio.channels.BoundServer;

public final class BindingService {
    private InetSocketAddress[] addresses;
    private BoundServer<InetSocketAddress, ? extends BoundChannel<InetSocketAddress>> server;
    private List<BoundChannel<InetSocketAddress>> bindings;

    public InetSocketAddress[] getAddresses() {
        return addresses;
    }

    public void setAddresses(final InetSocketAddress[] addresses) {
        this.addresses = addresses;
    }

    public BoundServer<InetSocketAddress, ? extends BoundChannel<InetSocketAddress>> getServer() {
        return server;
    }

    public void setServer(final BoundServer<InetSocketAddress, ? extends BoundChannel<InetSocketAddress>> server) {
        this.server = server;
    }

    public void start() throws IOException {
        final ArrayList<BoundChannel<InetSocketAddress>> bindings = new ArrayList<BoundChannel<InetSocketAddress>>();
        boolean ok = false;
        try {
            for (InetSocketAddress address : addresses) {
                bindings.add(server.bind(address).get());
            }
            ok = true;
            this.bindings = bindings;
        } finally {
            if (! ok) {
                for (BoundChannel<InetSocketAddress> binding : bindings) {
                    IoUtils.safeClose(binding);
                }
            }
        }
    }

    public void stop() {
        final List<BoundChannel<InetSocketAddress>> bindings = this.bindings;
        this.bindings = null;
        for (BoundChannel<InetSocketAddress> binding : bindings) {
            IoUtils.safeClose(binding);
        }
    }
}
