/*
 * JBoss, Home of Professional Open Source
 * Copyright 2010, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.xnio.metadata;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlType;

@XmlType(name = "channelListenerType")
public final class ChannelListenerMetaData {
    private String forBean;
    private Type type;
    private RefMetaData executor;
    private RefMetaData listener;

    public String getForBean() {
        return forBean;
    }

    @XmlAttribute(name = "for", required = true)
    public void setForBean(final String forBean) {
        this.forBean = forBean;
    }

    public Type getType() {
        return type;
    }

    @XmlAttribute(name = "type", required = true)
    public void setType(final Type type) {
        this.type = type;
    }

    public RefMetaData getExecutor() {
        return executor;
    }

    @XmlElement
    public void setExecutor(final RefMetaData executor) {
        this.executor = executor;
    }

    public RefMetaData getListener() {
        return listener;
    }

    @XmlElement(required = true)
    public void setListener(final RefMetaData listener) {
        this.listener = listener;
    }

    @XmlEnum
    public enum Type {
        @XmlEnumValue("bind") BIND,
        @XmlEnumValue("accept") ACCEPT,
    }
}
