/*
 * JBoss, Home of Professional Open Source
 * Copyright 2008, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.xnio.metadata;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlAttribute;

/**
 *
 */
@XmlType(name = "tcpServerType", propOrder = {})
public final class TcpServerMetaData implements MultiplyBindableMetaData, OptionedMetaData, Serializable {

    private static final long serialVersionUID = 4318538124489300012L;

    private List<Object> allBindings = arrayList();
    private SocketAddressMetaData binding;
    private List<OptionMetaData> options = arrayList();
    private OptionMetaData option;
    private RefMetaData acceptListener;
    private RefMetaData bindListener;
    private RefMetaData executor;
    private String name;

    private static <T> List<T> arrayList() {
        return new ArrayList<T>();
    }

    public List<Object> getAllBindings() {
        return allBindings;
    }

    @XmlElementWrapper(name = "bind")
    @XmlElements({
        @XmlElement(name = "bind-address", type = SocketAddressMetaData.class),
        @XmlElement(name = "managed-binding", type = ManagedBindingMetaData.class)
    })
    public void setAllBindings(final List<Object> allBindings) {
        this.allBindings = allBindings;
    }

    @XmlTransient
    public List<SocketAddressMetaData> getBindings() {
        List<SocketAddressMetaData> bindings = arrayList();
        for (Object o : allBindings) {
            if (o instanceof SocketAddressMetaData) {
                bindings.add((SocketAddressMetaData) o);
            }
        }
        return bindings;
    }

    @XmlTransient
    public List<ManagedBindingMetaData> getManagedBindings() {
        List<ManagedBindingMetaData> bindings = arrayList();
        for (Object o : allBindings) {
            if (o instanceof ManagedBindingMetaData) {
                bindings.add((ManagedBindingMetaData) o);
            }
        }
        return bindings;
    }

    public SocketAddressMetaData getBinding() {
        return binding;
    }

    @XmlElement(name = "bind-address")
    public void setBinding(final SocketAddressMetaData binding) {
        this.binding = binding;
    }

    public List<OptionMetaData> getOptions() {
        return options;
    }

    @XmlElementWrapper(name = "options")
    @XmlElement(name = "option")
    public void setOptions(final List<OptionMetaData> options) {
        this.options = options;
    }

    public OptionMetaData getOption() {
        return option;
    }

    @XmlElement
    public void setOption(final OptionMetaData option) {
        this.option = option;
    }

    public RefMetaData getAcceptListener() {
        return acceptListener;
    }

    @XmlElement(name = "accept-listener")
    public void setAcceptListener(final RefMetaData acceptListener) {
        this.acceptListener = acceptListener;
    }

    public RefMetaData getBindListener() {
        return bindListener;
    }

    @XmlElement(name = "bind-listener")
    public void setBindListener(final RefMetaData bindListener) {
        this.bindListener = bindListener;
    }

    public RefMetaData getExecutor() {
        return executor;
    }

    @XmlElement(name = "executor")
    public void setExecutor(final RefMetaData executor) {
        this.executor = executor;
    }

    public String getName() {
        return name;
    }

    @XmlAttribute(name = "name")
    public void setName(final String name) {
        this.name = name;
    }
}
