/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xnio.nio;

import java.io.Closeable;
import java.io.IOException;
import java.nio.channels.Pipe;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;
import org.jboss.xnio.IoUtils;
import org.jboss.xnio.management.OneWayPipeConnectionMBean;
import org.jboss.xnio.nio.NioPipeSinkChannel;
import org.jboss.xnio.nio.NioPipeSourceChannel;
import org.jboss.xnio.nio.NioXnio;

final class NioOneWayPipeConnection
implements Closeable {
    private final NioPipeSourceChannel sourceSide;
    private final NioPipeSinkChannel sinkSide;

    NioOneWayPipeConnection(NioXnio nioXnio) throws IOException {
        MBean mbean;
        Pipe pipe = Pipe.open();
        Pipe.SourceChannel source = pipe.source();
        Pipe.SinkChannel sink = pipe.sink();
        source.configureBlocking(false);
        sink.configureBlocking(false);
        try {
            mbean = new MBean();
        }
        catch (NotCompliantMBeanException e) {
            throw new IOException("Failed to register channel mbean: " + e);
        }
        Closeable mbeanHandle = nioXnio.registerMBean(mbean);
        NioPipeSourceChannel sourceSide = new NioPipeSourceChannel(source, nioXnio, mbeanHandle);
        NioPipeSinkChannel sinkSide = new NioPipeSinkChannel(sink, nioXnio, mbean.bytes, mbean.messages, mbeanHandle);
        this.sourceSide = sourceSide;
        this.sinkSide = sinkSide;
        nioXnio.addManaged((Closeable)((Object)sourceSide));
        nioXnio.addManaged((Closeable)((Object)sinkSide));
    }

    public NioPipeSourceChannel getSourceSide() {
        return this.sourceSide;
    }

    public NioPipeSinkChannel getSinkSide() {
        return this.sinkSide;
    }

    public void close() throws IOException {
        IoUtils.safeClose((Closeable)((Object)this.sourceSide));
        IoUtils.safeClose((Closeable)((Object)this.sinkSide));
    }

    private final class MBean
    extends StandardMBean
    implements OneWayPipeConnectionMBean {
        private final AtomicLong bytes;
        private final AtomicLong messages;

        private MBean() throws NotCompliantMBeanException {
            super(OneWayPipeConnectionMBean.class);
            this.bytes = new AtomicLong();
            this.messages = new AtomicLong();
        }

        public long getBytesWritten() {
            return this.bytes.get();
        }

        public long getMessagesWritten() {
            return this.messages.get();
        }

        public void close() {
            IoUtils.safeClose((Closeable)NioOneWayPipeConnection.this);
        }
    }
}

