/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xnio.nio;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.Channel;
import java.nio.channels.DatagramChannel;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.jboss.xnio.ChannelListener;
import org.jboss.xnio.IoUtils;
import org.jboss.xnio.Option;
import org.jboss.xnio.channels.Configurable;
import org.jboss.xnio.channels.MultipointReadResult;
import org.jboss.xnio.channels.UdpChannel;
import org.jboss.xnio.channels.UnsupportedOptionException;
import org.jboss.xnio.log.Logger;
import org.jboss.xnio.nio.NioHandle;
import org.jboss.xnio.nio.NioXnio;
import org.jboss.xnio.nio.SelectorUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class NioUdpChannel
implements UdpChannel {
    private static final Logger log = Logger.getLogger((String)"org.jboss.xnio.nio.udp.server.channel");
    private final DatagramChannel datagramChannel;
    private final NioHandle readHandle;
    private final NioHandle writeHandle;
    private volatile ChannelListener<? super UdpChannel> readListener = null;
    private volatile ChannelListener<? super UdpChannel> writeListener = null;
    private volatile ChannelListener<? super UdpChannel> closeListener = null;
    private static final AtomicReferenceFieldUpdater<NioUdpChannel, ChannelListener> readListenerUpdater = AtomicReferenceFieldUpdater.newUpdater(NioUdpChannel.class, ChannelListener.class, "readListener");
    private static final AtomicReferenceFieldUpdater<NioUdpChannel, ChannelListener> writeListenerUpdater = AtomicReferenceFieldUpdater.newUpdater(NioUdpChannel.class, ChannelListener.class, "writeListener");
    private static final AtomicReferenceFieldUpdater<NioUdpChannel, ChannelListener> closeListenerUpdater = AtomicReferenceFieldUpdater.newUpdater(NioUdpChannel.class, ChannelListener.class, "closeListener");
    private final ChannelListener.Setter<UdpChannel> readSetter = IoUtils.getSetter((Object)this, readListenerUpdater);
    private final ChannelListener.Setter<UdpChannel> writeSetter = IoUtils.getSetter((Object)this, writeListenerUpdater);
    private final ChannelListener.Setter<UdpChannel> closeSetter = IoUtils.getSetter((Object)this, closeListenerUpdater);
    private final AtomicBoolean callFlag = new AtomicBoolean(false);
    private final NioXnio nioXnio;
    private final AtomicLong globalBytesRead;
    private final AtomicLong globalBytesWritten;
    private final AtomicLong globalMessagesRead;
    private final AtomicLong globalMessagesWritten;
    final AtomicLong bytesRead = new AtomicLong();
    final AtomicLong bytesWritten = new AtomicLong();
    final AtomicLong messagesRead = new AtomicLong();
    final AtomicLong messagesWritten = new AtomicLong();

    NioUdpChannel(NioXnio nioXnio, DatagramChannel datagramChannel, Executor executor, AtomicLong globalBytesRead, AtomicLong globalBytesWritten, AtomicLong globalMessagesRead, AtomicLong globalMessagesWritten) throws IOException {
        this.nioXnio = nioXnio;
        this.globalBytesRead = globalBytesRead;
        this.globalBytesWritten = globalBytesWritten;
        this.globalMessagesRead = globalMessagesRead;
        this.globalMessagesWritten = globalMessagesWritten;
        if (executor != null) {
            this.readHandle = nioXnio.addReadHandler(datagramChannel, new ReadHandler(), executor);
            this.writeHandle = nioXnio.addWriteHandler(datagramChannel, new WriteHandler(), executor);
        } else {
            this.readHandle = nioXnio.addReadHandler(datagramChannel, new ReadHandler());
            this.writeHandle = nioXnio.addWriteHandler(datagramChannel, new WriteHandler());
        }
        this.datagramChannel = datagramChannel;
    }

    public InetSocketAddress getLocalAddress() {
        return (InetSocketAddress)this.datagramChannel.socket().getLocalSocketAddress();
    }

    public MultipointReadResult<InetSocketAddress> receive(ByteBuffer buffer) throws IOException {
        int o = buffer.remaining();
        final InetSocketAddress sourceAddress = (InetSocketAddress)this.datagramChannel.receive(buffer);
        if (sourceAddress == null) {
            return null;
        }
        int t = o - buffer.remaining();
        this.globalMessagesRead.incrementAndGet();
        this.messagesRead.incrementAndGet();
        this.globalBytesRead.addAndGet(t);
        this.bytesRead.addAndGet(t);
        return new MultipointReadResult<InetSocketAddress>(){

            public InetSocketAddress getSourceAddress() {
                return sourceAddress;
            }

            public InetSocketAddress getDestinationAddress() {
                return null;
            }
        };
    }

    public ChannelListener.Setter<UdpChannel> getReadSetter() {
        return this.readSetter;
    }

    public ChannelListener.Setter<UdpChannel> getWriteSetter() {
        return this.writeSetter;
    }

    public ChannelListener.Setter<UdpChannel> getCloseSetter() {
        return this.closeSetter;
    }

    public boolean flush() throws IOException {
        return true;
    }

    public boolean isOpen() {
        return this.datagramChannel.isOpen();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (!this.callFlag.getAndSet(true)) {
            log.trace("Closing %s", (Object)this);
            try {
                this.datagramChannel.close();
            }
            finally {
                this.nioXnio.removeManaged((Closeable)((Object)this));
                IoUtils.invokeChannelListener((Channel)((Object)this), this.closeListener);
            }
        }
    }

    public boolean send(InetSocketAddress target, ByteBuffer buffer) throws IOException {
        int ret = this.datagramChannel.send(buffer, target);
        if (ret != 0) {
            this.globalMessagesWritten.incrementAndGet();
            this.messagesWritten.incrementAndGet();
            this.globalBytesWritten.addAndGet(ret);
            this.bytesWritten.addAndGet(ret);
            return true;
        }
        return false;
    }

    public boolean send(InetSocketAddress target, ByteBuffer[] dsts) throws IOException {
        return this.send(target, dsts, 0, dsts.length);
    }

    public boolean send(InetSocketAddress target, ByteBuffer[] dsts, int offset, int length) throws IOException {
        long total = 0L;
        for (int i = 0; i < length; ++i) {
            total += (long)dsts[offset + i].remaining();
        }
        if (total > Integer.MAX_VALUE) {
            throw new IOException("Source data is too large");
        }
        ByteBuffer buf = ByteBuffer.allocate((int)total);
        for (int i = 0; i < length; ++i) {
            buf.put(dsts[offset + i]);
        }
        buf.flip();
        return this.send(target, buf);
    }

    public void suspendReads() {
        try {
            this.readHandle.suspend();
        }
        catch (CancelledKeyException cancelledKeyException) {
            // empty catch block
        }
    }

    public void suspendWrites() {
        try {
            this.writeHandle.suspend();
        }
        catch (CancelledKeyException cancelledKeyException) {
            // empty catch block
        }
    }

    public void resumeReads() {
        try {
            this.readHandle.resume(1);
        }
        catch (CancelledKeyException cancelledKeyException) {
            // empty catch block
        }
    }

    public void resumeWrites() {
        try {
            this.writeHandle.resume(4);
        }
        catch (CancelledKeyException cancelledKeyException) {
            // empty catch block
        }
    }

    public void shutdownReads() throws IOException {
        throw new UnsupportedOperationException("Shutdown reads");
    }

    public void shutdownWrites() throws IOException {
        throw new UnsupportedOperationException("Shutdown writes");
    }

    public void awaitReadable() throws IOException {
        SelectorUtils.await(this.nioXnio, this.datagramChannel, 1);
    }

    public void awaitReadable(long time, TimeUnit timeUnit) throws IOException {
        SelectorUtils.await(this.nioXnio, this.datagramChannel, 1, time, timeUnit);
    }

    public void awaitWritable() throws IOException {
        SelectorUtils.await(this.nioXnio, this.datagramChannel, 4);
    }

    public void awaitWritable(long time, TimeUnit timeUnit) throws IOException {
        SelectorUtils.await(this.nioXnio, this.datagramChannel, 4, time, timeUnit);
    }

    public UdpChannel.Key join(InetAddress group, NetworkInterface iface) throws IOException {
        throw new UnsupportedOperationException("Multicast join");
    }

    public UdpChannel.Key join(InetAddress group, NetworkInterface iface, InetAddress source) throws IOException {
        throw new UnsupportedOperationException("Multicast join");
    }

    public boolean supportsOption(Option<?> option) {
        return false;
    }

    public <T> T getOption(Option<T> option) throws UnsupportedOptionException, IOException {
        return null;
    }

    public <T> Configurable setOption(Option<T> option, T value) throws IllegalArgumentException, IOException {
        return this;
    }

    public String toString() {
        return String.format("UDP socket channel (NIO) <%s> @ %s", Integer.toString(this.hashCode(), 16), this.getLocalAddress());
    }

    public final class WriteHandler
    implements Runnable {
        public void run() {
            IoUtils.invokeChannelListener((Channel)((Object)NioUdpChannel.this), (ChannelListener)NioUdpChannel.this.writeListener);
        }
    }

    public final class ReadHandler
    implements Runnable {
        public void run() {
            IoUtils.invokeChannelListener((Channel)((Object)NioUdpChannel.this), (ChannelListener)NioUdpChannel.this.readListener);
        }
    }
}

