/*
 * Decompiled with CFR 0.152.
 */
package org.xnio.nio;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.WriteChannelThread;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.nio.NioHandle;
import org.xnio.nio.NioSetter;
import org.xnio.nio.NioWriteChannelThread;
import org.xnio.nio.NioXnio;
import org.xnio.nio.SelectorUtils;

abstract class AbstractNioStreamSinkChannel<C extends AbstractNioStreamSinkChannel<C>>
implements StreamSinkChannel {
    private final NioXnio nioXnio;
    private volatile NioHandle<AbstractNioStreamSinkChannel> writeHandle;
    private static final AtomicReferenceFieldUpdater<AbstractNioStreamSinkChannel, NioHandle> writeHandleUpdater = AtomicReferenceFieldUpdater.newUpdater(AbstractNioStreamSinkChannel.class, NioHandle.class, "writeHandle");
    private final NioSetter<C> writeSetter = new NioSetter();
    private final NioSetter<C> closeSetter = new NioSetter();

    AbstractNioStreamSinkChannel(NioXnio xnio) {
        this.nioXnio = xnio;
    }

    protected abstract GatheringByteChannel getWriteChannel();

    public final ChannelListener.Setter<? extends C> getWriteSetter() {
        return this.writeSetter;
    }

    public final ChannelListener.Setter<? extends C> getCloseSetter() {
        return this.closeSetter;
    }

    public final void suspendWrites() {
        NioHandle<AbstractNioStreamSinkChannel> writeHandle = this.writeHandle;
        if (writeHandle != null) {
            writeHandle.resume(0);
        }
    }

    public final void resumeWrites() {
        NioHandle<AbstractNioStreamSinkChannel> writeHandle = this.writeHandle;
        if (writeHandle != null) {
            writeHandle.resume(4);
        }
    }

    public final void awaitWritable() throws IOException {
        SelectorUtils.await(this.nioXnio, (SelectableChannel)((Object)this.getWriteChannel()), 4);
    }

    public final void awaitWritable(long time, TimeUnit timeUnit) throws IOException {
        SelectorUtils.await(this.nioXnio, (SelectableChannel)((Object)this.getWriteChannel()), 4, time, timeUnit);
    }

    public final void setWriteThread(WriteChannelThread thread) throws IllegalArgumentException {
        try {
            NioHandle<C> newHandle = thread == null ? null : ((NioWriteChannelThread)thread).addChannel((AbstractSelectableChannel)((Object)this.getWriteChannel()), this.typed(), 4, this.writeSetter);
            NioHandle<C> oldValue = this.getAndSetWrite(newHandle);
            if (oldValue != null) {
                oldValue.cancelKey();
            }
        }
        catch (ClosedChannelException e) {
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Thread belongs to the wrong provider");
        }
    }

    public WriteChannelThread getWriteThread() {
        NioHandle handle = writeHandleUpdater.get(this);
        return (WriteChannelThread)handle.getChannelThread();
    }

    public final long transferFrom(FileChannel src, long position, long count) throws IOException {
        return src.transferTo(position, count, this.getWriteChannel());
    }

    public boolean flush() throws IOException {
        return true;
    }

    public int write(ByteBuffer src) throws IOException {
        return this.getWriteChannel().write(src);
    }

    public long write(ByteBuffer[] srcs) throws IOException {
        return this.getWriteChannel().write(srcs);
    }

    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        return this.getWriteChannel().write(srcs, offset, length);
    }

    private C typed() {
        return (C)this;
    }

    private NioHandle<C> getAndSetWrite(NioHandle<C> newHandle) {
        return writeHandleUpdater.getAndSet(this, newHandle);
    }

    protected void invokeCloseHandler() {
        ChannelListeners.invokeChannelListener(this.typed(), this.closeSetter.get());
    }
}

