/*
 * Decompiled with CFR 0.152.
 */
package org.xnio.nio;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.ScatteringByteChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.ReadChannelThread;
import org.xnio.channels.StreamSourceChannel;
import org.xnio.nio.NioHandle;
import org.xnio.nio.NioReadChannelThread;
import org.xnio.nio.NioSetter;
import org.xnio.nio.NioXnio;
import org.xnio.nio.SelectorUtils;

abstract class AbstractNioStreamSourceChannel<C extends AbstractNioStreamSourceChannel<C>>
implements StreamSourceChannel {
    private final NioXnio nioXnio;
    private volatile NioHandle<AbstractNioStreamSourceChannel> readHandle;
    private static final AtomicReferenceFieldUpdater<AbstractNioStreamSourceChannel, NioHandle> readHandleUpdater = AtomicReferenceFieldUpdater.newUpdater(AbstractNioStreamSourceChannel.class, NioHandle.class, "readHandle");
    private final NioSetter<C> readSetter = new NioSetter();
    private final NioSetter<C> closeSetter = new NioSetter();

    AbstractNioStreamSourceChannel(NioXnio xnio) {
        this.nioXnio = xnio;
    }

    protected abstract ScatteringByteChannel getReadChannel();

    public final ChannelListener.Setter<? extends C> getReadSetter() {
        return this.readSetter;
    }

    public final ChannelListener.Setter<? extends C> getCloseSetter() {
        return this.closeSetter;
    }

    public final void suspendReads() {
        NioHandle<AbstractNioStreamSourceChannel> readHandle = this.readHandle;
        if (readHandle != null) {
            readHandle.suspend();
        }
    }

    public final void resumeReads() {
        NioHandle<AbstractNioStreamSourceChannel> readHandle = this.readHandle;
        if (readHandle != null) {
            readHandle.resume(1);
        }
    }

    public final void awaitReadable() throws IOException {
        SelectorUtils.await(this.nioXnio, (SelectableChannel)((Object)this.getReadChannel()), 1);
    }

    public final void awaitReadable(long time, TimeUnit timeUnit) throws IOException {
        SelectorUtils.await(this.nioXnio, (SelectableChannel)((Object)this.getReadChannel()), 1, time, timeUnit);
    }

    public final void setReadThread(ReadChannelThread thread) throws IllegalArgumentException {
        try {
            NioHandle<C> newHandle = thread == null ? null : ((NioReadChannelThread)thread).addChannel((AbstractSelectableChannel)((Object)this.getReadChannel()), this.typed(), 1, this.readSetter);
            NioHandle<C> oldValue = this.getAndSetRead(newHandle);
            if (oldValue != null) {
                oldValue.cancelKey();
            }
        }
        catch (ClosedChannelException e) {
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Thread belongs to the wrong provider");
        }
    }

    public ReadChannelThread getReadThread() {
        NioHandle handle = readHandleUpdater.get(this);
        return (ReadChannelThread)handle.getChannelThread();
    }

    public final long transferTo(long position, long count, FileChannel target) throws IOException {
        return target.transferFrom(this.getReadChannel(), position, count);
    }

    public int read(ByteBuffer dst) throws IOException {
        return this.getReadChannel().read(dst);
    }

    public long read(ByteBuffer[] dsts) throws IOException {
        return this.getReadChannel().read(dsts);
    }

    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        return this.getReadChannel().read(dsts, offset, length);
    }

    private C typed() {
        return (C)this;
    }

    private NioHandle<C> getAndSetRead(NioHandle<C> newHandle) {
        return readHandleUpdater.getAndSet(this, newHandle);
    }

    protected void invokeCloseHandler() {
        ChannelListeners.invokeChannelListener(this.typed(), this.closeSetter.get());
    }
}

