/*
 * Decompiled with CFR 0.152.
 */
package org.xnio.nio;

import java.io.Closeable;
import java.io.IOException;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.Pipe;
import java.nio.channels.ScatteringByteChannel;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.xnio.IoUtils;
import org.xnio.Option;
import org.xnio.nio.AbstractNioStreamChannel;
import org.xnio.nio.NioXnio;

final class NioPipeChannel
extends AbstractNioStreamChannel<NioPipeChannel> {
    private final Pipe.SourceChannel sourceChannel;
    private final Pipe.SinkChannel sinkChannel;
    private volatile int closeBits = 0;
    private static final AtomicIntegerFieldUpdater<NioPipeChannel> closeBitsUpdater = AtomicIntegerFieldUpdater.newUpdater(NioPipeChannel.class, "closeBits");

    NioPipeChannel(NioXnio xnio, Pipe.SinkChannel sinkChannel, Pipe.SourceChannel sourceChannel) {
        super(xnio);
        this.sinkChannel = sinkChannel;
        this.sourceChannel = sourceChannel;
    }

    @Override
    protected ScatteringByteChannel getReadChannel() {
        return this.sourceChannel;
    }

    @Override
    protected GatheringByteChannel getWriteChannel() {
        return this.sinkChannel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownReads() throws IOException {
        boolean ok = false;
        try {
            this.sourceChannel.close();
            ok = true;
        }
        finally {
            if (NioPipeChannel.setBits(this, 2) == 1) {
                if (ok) {
                    this.close();
                } else {
                    IoUtils.safeClose((Closeable)((Object)this));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shutdownWrites() throws IOException {
        boolean ok = false;
        try {
            this.sinkChannel.close();
            ok = true;
        }
        finally {
            if (NioPipeChannel.setBits(this, 1) == 2) {
                if (ok) {
                    this.close();
                } else {
                    IoUtils.safeClose((Closeable)((Object)this));
                }
            }
        }
        return true;
    }

    public boolean isOpen() {
        return this.closeBits < 3;
    }

    public boolean supportsOption(Option<?> option) {
        return false;
    }

    public <T> T getOption(Option<T> option) throws IOException {
        return null;
    }

    public <T> T setOption(Option<T> option, T value) throws IllegalArgumentException, IOException {
        return null;
    }

    private static int setBits(NioPipeChannel instance, int bits) {
        int old;
        int updated;
        while ((updated = (old = instance.closeBits) | bits) != old && !closeBitsUpdater.compareAndSet(instance, old, updated)) {
        }
        return old;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        IoUtils.safeClose((Closeable)this.sourceChannel);
        try {
            this.sinkChannel.close();
        }
        finally {
            if (NioPipeChannel.setBits(this, 4) < 4) {
                this.invokeCloseHandler();
            }
        }
    }

    public String toString() {
        return String.format("pipe channel (NIO) <%h>", this);
    }
}

