/*
 * Decompiled with CFR 0.152.
 */
package org.xnio.nio;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.ReadChannelThread;
import org.xnio.WriteChannelThread;
import org.xnio.channels.StreamChannel;
import org.xnio.nio.AbstractNioChannelThread;
import org.xnio.nio.Log;
import org.xnio.nio.NioHandle;
import org.xnio.nio.NioSetter;
import org.xnio.nio.NioXnio;
import org.xnio.nio.SelectorUtils;

abstract class AbstractNioStreamChannel<C extends AbstractNioStreamChannel<C>>
implements StreamChannel {
    private final NioXnio nioXnio;
    private volatile NioHandle<AbstractNioStreamChannel> readHandle;
    private volatile NioHandle<AbstractNioStreamChannel> writeHandle;
    private static final AtomicReferenceFieldUpdater<AbstractNioStreamChannel, NioHandle> readHandleUpdater = AtomicReferenceFieldUpdater.newUpdater(AbstractNioStreamChannel.class, NioHandle.class, "readHandle");
    private static final AtomicReferenceFieldUpdater<AbstractNioStreamChannel, NioHandle> writeHandleUpdater = AtomicReferenceFieldUpdater.newUpdater(AbstractNioStreamChannel.class, NioHandle.class, "writeHandle");
    private final NioSetter<C> readSetter = new NioSetter();
    private final NioSetter<C> writeSetter = new NioSetter();
    private final NioSetter<C> closeSetter = new NioSetter();

    AbstractNioStreamChannel(NioXnio xnio) {
        this.nioXnio = xnio;
    }

    protected abstract ScatteringByteChannel getReadChannel();

    protected abstract GatheringByteChannel getWriteChannel();

    public final ChannelListener.Setter<? extends C> getReadSetter() {
        return this.readSetter;
    }

    public final ChannelListener.Setter<? extends C> getWriteSetter() {
        return this.writeSetter;
    }

    public final ChannelListener.Setter<? extends C> getCloseSetter() {
        return this.closeSetter;
    }

    public final void suspendReads() {
        Log.log.tracef("Suspend reads on %s", (Object)this);
        NioHandle<AbstractNioStreamChannel> readHandle = this.readHandle;
        if (readHandle != null) {
            readHandle.suspend();
        }
    }

    public final void resumeReads() {
        Log.log.tracef("Resume reads on %s", (Object)this);
        NioHandle<AbstractNioStreamChannel> readHandle = this.readHandle;
        if (readHandle != null) {
            readHandle.resume(1);
        }
    }

    public final void suspendWrites() {
        Log.log.tracef("Suspend writes on %s", (Object)this);
        NioHandle<AbstractNioStreamChannel> writeHandle = this.writeHandle;
        if (writeHandle != null) {
            writeHandle.resume(0);
        }
    }

    public final void resumeWrites() {
        Log.log.tracef("Resume writes on %s", (Object)this);
        NioHandle<AbstractNioStreamChannel> writeHandle = this.writeHandle;
        if (writeHandle != null) {
            writeHandle.resume(4);
        }
    }

    public final void awaitReadable() throws IOException {
        SelectorUtils.await(this.nioXnio, (SelectableChannel)((Object)this.getReadChannel()), 1);
    }

    public final void awaitReadable(long time, TimeUnit timeUnit) throws IOException {
        SelectorUtils.await(this.nioXnio, (SelectableChannel)((Object)this.getReadChannel()), 1, time, timeUnit);
    }

    public final void awaitWritable() throws IOException {
        SelectorUtils.await(this.nioXnio, (SelectableChannel)((Object)this.getWriteChannel()), 4);
    }

    public final void awaitWritable(long time, TimeUnit timeUnit) throws IOException {
        SelectorUtils.await(this.nioXnio, (SelectableChannel)((Object)this.getWriteChannel()), 4, time, timeUnit);
    }

    public final void setReadThread(ReadChannelThread thread) throws IllegalArgumentException {
        try {
            NioHandle<C> newHandle = thread == null ? null : ((AbstractNioChannelThread)thread).addChannel((AbstractSelectableChannel)((Object)this.getReadChannel()), this.typed(), 0, this.readSetter);
            NioHandle<C> oldValue = this.getAndSetRead(newHandle);
            if (oldValue != null && (newHandle == null || oldValue.getSelectionKey() != newHandle.getSelectionKey())) {
                oldValue.cancelKey();
            }
        }
        catch (ClosedChannelException e) {
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Thread belongs to the wrong provider");
        }
    }

    public ReadChannelThread getReadThread() {
        NioHandle handle = readHandleUpdater.get(this);
        return (ReadChannelThread)handle.getChannelThread();
    }

    public final void setWriteThread(WriteChannelThread thread) throws IllegalArgumentException {
        try {
            NioHandle<C> newHandle = thread == null ? null : ((AbstractNioChannelThread)thread).addChannel((AbstractSelectableChannel)((Object)this.getWriteChannel()), this.typed(), 0, this.writeSetter);
            NioHandle<C> oldValue = this.getAndSetWrite(newHandle);
            if (oldValue != null && (newHandle == null || oldValue.getSelectionKey() != newHandle.getSelectionKey())) {
                oldValue.cancelKey();
            }
        }
        catch (ClosedChannelException e) {
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Thread belongs to the wrong provider");
        }
    }

    public WriteChannelThread getWriteThread() {
        NioHandle handle = writeHandleUpdater.get(this);
        return (WriteChannelThread)handle.getChannelThread();
    }

    public final long transferTo(long position, long count, FileChannel target) throws IOException {
        return target.transferFrom(this.getReadChannel(), position, count);
    }

    public final long transferFrom(FileChannel src, long position, long count) throws IOException {
        return src.transferTo(position, count, this.getWriteChannel());
    }

    public boolean flush() throws IOException {
        return true;
    }

    public int read(ByteBuffer dst) throws IOException {
        return this.getReadChannel().read(dst);
    }

    public long read(ByteBuffer[] dsts) throws IOException {
        return this.getReadChannel().read(dsts);
    }

    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        return this.getReadChannel().read(dsts, offset, length);
    }

    public int write(ByteBuffer src) throws IOException {
        return this.getWriteChannel().write(src);
    }

    public long write(ByteBuffer[] srcs) throws IOException {
        return this.getWriteChannel().write(srcs);
    }

    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        return this.getWriteChannel().write(srcs, offset, length);
    }

    private C typed() {
        return (C)this;
    }

    private NioHandle<C> getAndSetRead(NioHandle<C> newHandle) {
        return readHandleUpdater.getAndSet(this, newHandle);
    }

    private NioHandle<C> getAndSetWrite(NioHandle<C> newHandle) {
        return writeHandleUpdater.getAndSet(this, newHandle);
    }

    protected void invokeCloseHandler() {
        ChannelListeners.invokeChannelListener(this.typed(), this.closeSetter.get());
    }

    protected void cancelWriteKey() {
        NioHandle writeHandle = writeHandleUpdater.getAndSet(this, null);
        if (writeHandle != null) {
            writeHandle.cancelKey();
        }
    }

    protected void cancelReadKey() {
        NioHandle readHandle = readHandleUpdater.getAndSet(this, null);
        if (readHandle != null) {
            readHandle.cancelKey();
        }
    }
}

