/*
 * Decompiled with CFR 0.152.
 */
package org.xnio.nio;

import java.io.IOException;
import java.nio.channels.Pipe;
import java.nio.channels.ScatteringByteChannel;
import java.util.concurrent.atomic.AtomicBoolean;
import org.xnio.Option;
import org.xnio.channels.UnsupportedOptionException;
import org.xnio.nio.AbstractNioStreamSourceChannel;
import org.xnio.nio.NioXnio;

final class NioPipeSourceChannel
extends AbstractNioStreamSourceChannel<NioPipeSourceChannel> {
    private final Pipe.SourceChannel channel;
    private final AtomicBoolean callFlag = new AtomicBoolean(false);

    NioPipeSourceChannel(NioXnio xnio, Pipe.SourceChannel channel) {
        super(xnio);
        this.channel = channel;
    }

    public boolean isOpen() {
        return this.channel.isOpen();
    }

    public void close() throws IOException {
        if (!this.callFlag.getAndSet(true)) {
            this.invokeCloseHandler();
            this.channel.close();
        }
    }

    @Override
    protected ScatteringByteChannel getReadChannel() {
        return this.channel;
    }

    public void shutdownReads() throws IOException {
        this.close();
    }

    public boolean supportsOption(Option<?> option) {
        return false;
    }

    public <T> T getOption(Option<T> option) throws UnsupportedOptionException, IOException {
        return null;
    }

    public <T> T setOption(Option<T> option, T value) throws IllegalArgumentException, IOException {
        return null;
    }

    public String toString() {
        return String.format("pipe source channel (NIO) <%s>", Integer.toString(this.hashCode(), 16));
    }
}

