/*
 * Decompiled with CFR 0.152.
 */
package org.xnio.nio;

import java.nio.channels.Channel;
import java.nio.channels.SelectionKey;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.nio.Log;
import org.xnio.nio.WorkerThread;

final class NioHandle<C extends Channel> {
    private final SelectionKey selectionKey;
    private final WorkerThread workerThread;
    private final ChannelListener.SimpleSetter<C> handlerSetter;
    private final C channel;

    NioHandle(SelectionKey selectionKey, WorkerThread workerThread, ChannelListener.SimpleSetter<C> handlerSetter, C channel) {
        this.selectionKey = selectionKey;
        this.workerThread = workerThread;
        this.handlerSetter = handlerSetter;
        this.channel = channel;
    }

    SelectionKey getSelectionKey() {
        return this.selectionKey;
    }

    WorkerThread getWorkerThread() {
        return this.workerThread;
    }

    ChannelListener.SimpleSetter<C> getHandlerSetter() {
        return this.handlerSetter;
    }

    void cancelKey() {
        this.workerThread.cancelKey(this.selectionKey);
    }

    void resume(int op) {
        this.workerThread.setOps(this.selectionKey, op);
    }

    void suspend() {
        this.workerThread.setOps(this.selectionKey, 0);
    }

    C getChannel() {
        return this.channel;
    }

    void invoke() {
        ChannelListener listener = this.handlerSetter.get();
        if (listener == null) {
            Log.log.tracef("Null listener; suspending %s to prevent runaway", (Object)this);
            this.suspend();
        } else {
            ChannelListeners.invokeChannelListener(this.channel, (ChannelListener)listener);
        }
    }
}

