/*
 * Decompiled with CFR 0.152.
 */
package org.xnio.nio;

import java.io.IOException;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SocketChannel;
import java.util.Set;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.jboss.logging.Logger;
import org.xnio.ChannelListener;
import org.xnio.Option;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.XnioWorker;
import org.xnio.channels.BoundChannel;
import org.xnio.channels.ConnectedStreamChannel;
import org.xnio.channels.UnsupportedOptionException;
import org.xnio.nio.AbstractNioStreamChannel;
import org.xnio.nio.NioTcpServer;
import org.xnio.nio.NioXnioWorker;

final class NioTcpChannel
extends AbstractNioStreamChannel<NioTcpChannel>
implements ConnectedStreamChannel {
    private static final Logger log = Logger.getLogger((String)"org.xnio.nio.tcp.channel");
    private final SocketChannel socketChannel;
    private final Socket socket;
    private final NioTcpServer server;
    private volatile int closeBits = 0;
    private static final AtomicIntegerFieldUpdater<NioTcpChannel> closeBitsUpdater = AtomicIntegerFieldUpdater.newUpdater(NioTcpChannel.class, "closeBits");
    private static final Set<Option<?>> OPTIONS = Option.setBuilder().add(Options.CLOSE_ABORT).add(Options.KEEP_ALIVE).add(Options.TCP_OOB_INLINE).add(Options.RECEIVE_BUFFER).add(Options.SEND_BUFFER).add(Options.TCP_NODELAY).add(Options.IP_TRAFFIC_CLASS).create();

    NioTcpChannel(NioXnioWorker worker, NioTcpServer server, SocketChannel socketChannel) throws ClosedChannelException {
        super(worker);
        this.socketChannel = socketChannel;
        this.server = server;
        this.socket = socketChannel.socket();
    }

    void configureFrom(OptionMap optionMap) throws IOException {
        for (Option option : optionMap) {
            if (!this.supportsOption(option)) continue;
            this.doSetOption(option, optionMap);
        }
    }

    private <T> void doSetOption(Option<T> option, OptionMap map) throws IOException {
        this.setOption(option, option.cast(map.get(option)));
    }

    BoundChannel getBoundChannel() {
        return new BoundChannel(){

            public SocketAddress getLocalAddress() {
                return NioTcpChannel.this.getLocalAddress();
            }

            public <A extends SocketAddress> A getLocalAddress(Class<A> type) {
                SocketAddress address = this.getLocalAddress();
                return (A)(type.isInstance(address) ? (SocketAddress)type.cast(address) : null);
            }

            public ChannelListener.Setter<? extends BoundChannel> getCloseSetter() {
                return NioTcpChannel.this.getCloseSetter();
            }

            public boolean isOpen() {
                return NioTcpChannel.this.isOpen();
            }

            public void close() throws IOException {
                NioTcpChannel.this.close();
            }

            public boolean supportsOption(Option<?> option) {
                return NioTcpChannel.this.supportsOption(option);
            }

            public <T> T getOption(Option<T> option) throws IOException {
                return NioTcpChannel.this.getOption(option);
            }

            public <T> T setOption(Option<T> option, T value) throws IllegalArgumentException, IOException {
                return NioTcpChannel.this.setOption(option, value);
            }

            public XnioWorker getWorker() {
                return NioTcpChannel.this.getWorker();
            }
        };
    }

    public boolean isOpen() {
        return this.socketChannel.isOpen();
    }

    @Override
    protected SocketChannel getReadChannel() {
        return this.socketChannel;
    }

    @Override
    protected SocketChannel getWriteChannel() {
        return this.socketChannel;
    }

    private static int setBits(NioTcpChannel instance, int bits) {
        int old;
        int updated;
        while ((updated = (old = instance.closeBits) | bits) != old && !closeBitsUpdater.compareAndSet(instance, old, updated)) {
        }
        return old;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (NioTcpChannel.setBits(this, 3) != 3) {
            log.tracef("Closing %s", (Object)this);
            try {
                try {
                    this.cancelReadKey();
                }
                catch (Throwable ignored) {
                    // empty catch block
                }
                try {
                    this.cancelWriteKey();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.socketChannel.close();
            }
            finally {
                if (this.server != null) {
                    this.server.channelClosed();
                }
                this.invokeCloseHandler();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownReads() throws IOException {
        int old = NioTcpChannel.setBits(this, 2);
        if ((old & 2) == 0) {
            log.tracef("Shutting down reads on %s", (Object)this);
            try {
                try {
                    this.cancelReadKey();
                }
                catch (Throwable ignored) {
                    // empty catch block
                }
                try {
                    this.socket.shutdownInput();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            finally {
                if (old == 1) {
                    try {
                        this.socketChannel.close();
                    }
                    finally {
                        this.invokeCloseHandler();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownWrites() throws IOException {
        int old = NioTcpChannel.setBits(this, 1);
        if ((old & 1) == 0) {
            log.tracef("Shutting down writes on %s", (Object)this);
            try {
                try {
                    this.cancelWriteKey();
                }
                catch (Throwable ignored) {
                    // empty catch block
                }
                try {
                    this.socket.shutdownOutput();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            finally {
                if (old == 2) {
                    try {
                        this.socketChannel.close();
                    }
                    finally {
                        this.invokeCloseHandler();
                    }
                }
            }
        }
    }

    public SocketAddress getPeerAddress() {
        return this.socket.getRemoteSocketAddress();
    }

    public <A extends SocketAddress> A getPeerAddress(Class<A> type) {
        SocketAddress address = this.getPeerAddress();
        return (A)(type.isInstance(address) ? (SocketAddress)type.cast(address) : null);
    }

    public SocketAddress getLocalAddress() {
        return this.socket.getLocalSocketAddress();
    }

    public <A extends SocketAddress> A getLocalAddress(Class<A> type) {
        SocketAddress address = this.getLocalAddress();
        return (A)(type.isInstance(address) ? (SocketAddress)type.cast(address) : null);
    }

    @Override
    public boolean supportsOption(Option<?> option) {
        return OPTIONS.contains(option) || super.supportsOption(option);
    }

    @Override
    public <T> T getOption(Option<T> option) throws UnsupportedOptionException, IOException {
        if (option == Options.CLOSE_ABORT) {
            return (T)option.cast((Object)(this.socket.getSoLinger() != -1 ? 1 : 0));
        }
        if (option == Options.KEEP_ALIVE) {
            return (T)option.cast((Object)this.socket.getKeepAlive());
        }
        if (option == Options.TCP_OOB_INLINE) {
            return (T)option.cast((Object)this.socket.getOOBInline());
        }
        if (option == Options.RECEIVE_BUFFER) {
            return (T)option.cast((Object)this.socket.getReceiveBufferSize());
        }
        if (option == Options.SEND_BUFFER) {
            return (T)option.cast((Object)this.socket.getSendBufferSize());
        }
        if (option == Options.TCP_NODELAY) {
            return (T)option.cast((Object)this.socket.getTcpNoDelay());
        }
        if (option == Options.IP_TRAFFIC_CLASS) {
            return (T)option.cast((Object)this.socket.getTrafficClass());
        }
        return super.getOption(option);
    }

    @Override
    public <T> T setOption(Option<T> option, T value) throws IllegalArgumentException, IOException {
        Comparable<Boolean> old;
        if (option == Options.CLOSE_ABORT) {
            old = this.socket.getSoLinger() != -1;
            this.socket.setSoLinger((Boolean)Options.CLOSE_ABORT.cast(value, (Object)false), 0);
        } else if (option == Options.KEEP_ALIVE) {
            old = this.socket.getKeepAlive();
            this.socket.setKeepAlive((Boolean)Options.KEEP_ALIVE.cast(value, (Object)false));
        } else if (option == Options.TCP_OOB_INLINE) {
            old = this.socket.getOOBInline();
            this.socket.setOOBInline((Boolean)Options.TCP_OOB_INLINE.cast(value, (Object)false));
        } else if (option == Options.SEND_BUFFER) {
            old = this.socket.getSendBufferSize();
            int newValue = (Integer)Options.SEND_BUFFER.cast(value, (Object)65536);
            if (newValue < 1) {
                throw new IllegalArgumentException("Buffer size must be larger than 1");
            }
            this.socket.setSendBufferSize((Integer)Options.SEND_BUFFER.cast(value, (Object)65536));
        } else if (option == Options.TCP_NODELAY) {
            old = this.socket.getTcpNoDelay();
            this.socket.setTcpNoDelay((Boolean)Options.TCP_NODELAY.cast(value, (Object)false));
        } else if (option == Options.IP_TRAFFIC_CLASS) {
            old = this.socket.getTrafficClass();
            this.socket.setTrafficClass((Integer)Options.IP_TRAFFIC_CLASS.cast(value, (Object)0));
        } else {
            return super.setOption(option, value);
        }
        return (T)option.cast((Object)old);
    }

    public String toString() {
        return String.format("TCP socket channel (NIO) <%h>", this);
    }
}

