/*
 * Decompiled with CFR 0.152.
 */
package org.xnio.nio;

import java.io.IOException;
import java.nio.channels.Pipe;
import java.nio.channels.SocketChannel;
import org.xnio.Xnio;
import org.xnio.XnioProvider;
import org.xnio.XnioWorker;
import org.xnio.channels.ConnectedStreamChannel;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.channels.StreamSourceChannel;
import org.xnio.nio.NioPipeSinkChannel;
import org.xnio.nio.NioPipeSourceChannel;
import org.xnio.nio.NioTcpChannel;
import org.xnio.nio.NioXnio;
import org.xnio.nio.NioXnioWorker;

public final class NioXnioProvider
implements XnioProvider {
    private static final Xnio INSTANCE = new NioXnio();

    public Xnio getInstance() {
        return INSTANCE;
    }

    public String getName() {
        return INSTANCE.getName();
    }

    public ConnectedStreamChannel adopt(XnioWorker worker, SocketChannel socketChannel) throws IOException {
        NioXnioWorker nioWorker = (NioXnioWorker)worker;
        socketChannel.configureBlocking(false);
        NioTcpChannel channel = new NioTcpChannel(nioWorker, null, socketChannel);
        channel.start();
        return channel;
    }

    public StreamSourceChannel adopt(XnioWorker worker, Pipe.SourceChannel pipeChannel) throws IOException {
        NioXnioWorker nioWorker = (NioXnioWorker)worker;
        pipeChannel.configureBlocking(false);
        NioPipeSourceChannel channel = new NioPipeSourceChannel(nioWorker, pipeChannel);
        channel.start();
        return channel;
    }

    public StreamSinkChannel adopt(XnioWorker worker, Pipe.SinkChannel pipeChannel) throws IOException {
        NioXnioWorker nioWorker = (NioXnioWorker)worker;
        pipeChannel.configureBlocking(false);
        NioPipeSinkChannel channel = new NioPipeSinkChannel(nioWorker, pipeChannel);
        channel.start();
        return channel;
    }
}

