/*
 * Decompiled with CFR 0.152.
 */
package org.xnio.nio;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.jboss.logging.Logger;
import org.xnio.ChannelListener;
import org.xnio.IoUtils;
import org.xnio.Option;
import org.xnio.Options;
import org.xnio.XnioExecutor;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.channels.StreamSourceChannel;
import org.xnio.channels.WriteTimeoutException;
import org.xnio.nio.AbstractNioChannel;
import org.xnio.nio.Log;
import org.xnio.nio.NioHandle;
import org.xnio.nio.NioXnioWorker;
import org.xnio.nio.SelectorUtils;
import org.xnio.nio.WorkerThread;

abstract class AbstractNioStreamSinkChannel<C extends AbstractNioStreamSinkChannel<C>>
extends AbstractNioChannel<C>
implements StreamSinkChannel {
    private static final String FQCN = AbstractNioStreamSinkChannel.class.getName();
    private volatile NioHandle<C> writeHandle;
    private volatile int writeTimeout = 0;
    private volatile long lastWrite;
    private final ChannelListener.SimpleSetter<C> writeSetter = new ChannelListener.SimpleSetter();
    private static final AtomicIntegerFieldUpdater<AbstractNioStreamSinkChannel> writeTimeoutUpdater = AtomicIntegerFieldUpdater.newUpdater(AbstractNioStreamSinkChannel.class, "writeTimeout");
    private static final Set<Option<?>> OPTIONS = Option.setBuilder().add(Options.WRITE_TIMEOUT).create();

    AbstractNioStreamSinkChannel(NioXnioWorker worker) throws ClosedChannelException {
        super(worker);
    }

    void start() throws ClosedChannelException {
        WorkerThread writeThread = this.worker.chooseOptional(true);
        this.writeHandle = writeThread == null ? null : writeThread.addChannel((AbstractSelectableChannel)((Object)this.getWriteChannel()), this.typed(), 4, this.writeSetter);
        this.lastWrite = System.nanoTime();
    }

    protected abstract GatheringByteChannel getWriteChannel();

    public final ChannelListener.Setter<? extends C> getWriteSetter() {
        return this.writeSetter;
    }

    public final void suspendWrites() {
        Log.log.logf(FQCN, Logger.Level.TRACE, null, "Suspend writes on %s", (Object)this);
        NioHandle<C> writeHandle = this.writeHandle;
        if (writeHandle != null) {
            writeHandle.suspend();
        }
    }

    public final void resumeWrites() {
        Log.log.logf(FQCN, Logger.Level.TRACE, null, "Resume writes on %s", (Object)this);
        NioHandle<C> writeHandle = this.writeHandle;
        if (writeHandle == null) {
            throw new IllegalArgumentException("No thread configured");
        }
        writeHandle.resume();
    }

    public boolean isWriteResumed() {
        NioHandle<C> writeHandle = this.writeHandle;
        return writeHandle != null && writeHandle.isResumed();
    }

    public void wakeupWrites() {
        Log.log.logf(FQCN, Logger.Level.TRACE, null, "Wake up writes on %s", (Object)this);
        NioHandle<C> writeHandle = this.writeHandle;
        if (writeHandle == null) {
            throw new IllegalArgumentException("No thread configured");
        }
        writeHandle.resume();
        writeHandle.execute();
    }

    public final void awaitWritable() throws IOException {
        SelectorUtils.await(this.worker.getXnio(), (SelectableChannel)((Object)this.getWriteChannel()), 4);
    }

    public final void awaitWritable(long time, TimeUnit timeUnit) throws IOException {
        SelectorUtils.await(this.worker.getXnio(), (SelectableChannel)((Object)this.getWriteChannel()), 4, time, timeUnit);
    }

    public XnioExecutor getWriteThread() {
        NioHandle<C> handle = this.writeHandle;
        return handle == null ? null : handle.getWorkerThread();
    }

    public final long transferFrom(FileChannel src, long position, long count) throws IOException {
        long res = src.transferTo(position, count, this.getWriteChannel());
        if (res > 0L) {
            this.lastWrite = System.nanoTime();
        } else {
            int timeout = this.writeTimeout;
            if (timeout > 0 && (System.nanoTime() - this.lastWrite) / 1000000L > (long)timeout) {
                throw new WriteTimeoutException("Write timed out");
            }
        }
        return res;
    }

    public long transferFrom(StreamSourceChannel source, long count, ByteBuffer throughBuffer) throws IOException {
        return IoUtils.transfer((ReadableByteChannel)source, (long)count, (ByteBuffer)throughBuffer, (WritableByteChannel)((Object)this));
    }

    public boolean flush() throws IOException {
        return true;
    }

    public int write(ByteBuffer src) throws IOException {
        int res = this.getWriteChannel().write(src);
        if ((long)res > 0L) {
            this.lastWrite = System.nanoTime();
        } else {
            int timeout = this.writeTimeout;
            if (timeout > 0 && (System.nanoTime() - this.lastWrite) / 1000000L > (long)timeout) {
                throw new WriteTimeoutException("Write timed out");
            }
        }
        return res;
    }

    public long write(ByteBuffer[] srcs) throws IOException {
        return this.write(srcs, 0, srcs.length);
    }

    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        if (length == 1) {
            return this.write(srcs[offset]);
        }
        long res = this.getWriteChannel().write(srcs, offset, length);
        if (res > 0L) {
            this.lastWrite = System.nanoTime();
        } else {
            int timeout = this.writeTimeout;
            if (timeout > 0 && (System.nanoTime() - this.lastWrite) / 1000000L > (long)timeout) {
                throw new WriteTimeoutException("Write timed out");
            }
        }
        return res;
    }

    public <T> T setOption(Option<T> option, T value) throws IllegalArgumentException, IOException {
        if (option == Options.WRITE_TIMEOUT) {
            int newValue = (Integer)Options.WRITE_TIMEOUT.cast(value, (Object)0);
            return (T)option.cast((Object)writeTimeoutUpdater.getAndSet(this, newValue));
        }
        return null;
    }

    public <T> T getOption(Option<T> option) throws IOException {
        if (option == Options.WRITE_TIMEOUT) {
            return (T)option.cast((Object)this.writeTimeout);
        }
        return null;
    }

    public boolean supportsOption(Option<?> option) {
        return OPTIONS.contains(option);
    }

    protected void cancelWriteKey() {
        if (this.writeHandle != null) {
            this.writeHandle.cancelKey();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void migrateTo(NioXnioWorker worker) throws ClosedChannelException {
        boolean ok = false;
        WorkerThread writeThread = worker.chooseOptional(true);
        NioHandle newWriteHandle = writeThread == null ? null : writeThread.addChannel((AbstractSelectableChannel)((Object)this.getWriteChannel()), this.typed(), 4, this.writeSetter);
        try {
            this.cancelWriteKey();
            ok = true;
        }
        finally {
            if (ok) {
                this.writeHandle = newWriteHandle;
                super.migrateTo(worker);
            } else if (newWriteHandle != null) {
                newWriteHandle.cancelKey();
            }
        }
    }
}

