/*
 * Decompiled with CFR 0.152.
 */
package org.xnio.nio;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.Channel;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.Pipe;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.security.AccessController;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Queue;
import java.util.TreeSet;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;
import org.jboss.logging.Logger;
import org.xnio.Cancellable;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.ChannelPipe;
import org.xnio.ClosedWorkerException;
import org.xnio.FailedIoFuture;
import org.xnio.FinishedIoFuture;
import org.xnio.FutureResult;
import org.xnio.IoFuture;
import org.xnio.IoUtils;
import org.xnio.Option;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.ReadPropertyAction;
import org.xnio.StreamConnection;
import org.xnio.XnioExecutor;
import org.xnio.XnioIoFactory;
import org.xnio.XnioIoThread;
import org.xnio.XnioWorker;
import org.xnio.channels.BoundChannel;
import org.xnio.channels.CloseableChannel;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.channels.StreamSourceChannel;
import org.xnio.nio.Log;
import org.xnio.nio.NioHandle;
import org.xnio.nio.NioPipeStreamConnection;
import org.xnio.nio.NioSocketStreamConnection;
import org.xnio.nio.NioXnioWorker;

final class WorkerThread
extends XnioIoThread
implements XnioExecutor {
    private static final long LONGEST_DELAY = 9223372036853L;
    private static final String FQCN = WorkerThread.class.getName();
    private static final boolean OLD_LOCKING;
    private static final boolean THREAD_SAFE_SELECTION_KEYS;
    private static final long START_TIME;
    private final Selector selector;
    private final Object workLock = new Object();
    private final Queue<Runnable> selectorWorkQueue = new ArrayDeque<Runnable>();
    private final TreeSet<TimeKey> delayWorkQueue = new TreeSet();
    private volatile int state;
    private static final int SHUTDOWN = Integer.MIN_VALUE;
    private static final AtomicIntegerFieldUpdater<WorkerThread> stateUpdater;
    volatile boolean polling;
    static final AtomicLong seqGen;

    WorkerThread(NioXnioWorker worker, Selector selector, String name, ThreadGroup group, long stackSize, int number) {
        super((XnioWorker)worker, number, group, name, stackSize);
        this.selector = selector;
    }

    static WorkerThread getCurrent() {
        XnioIoThread thread = WorkerThread.currentThread();
        return thread instanceof WorkerThread ? (WorkerThread)thread : null;
    }

    public NioXnioWorker getWorker() {
        return (NioXnioWorker)super.getWorker();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IoFuture<StreamConnection> acceptTcpStreamConnection(InetSocketAddress destination, final ChannelListener<? super StreamConnection> openListener, ChannelListener<? super BoundChannel> bindListener, final OptionMap optionMap) {
        IoFuture ioFuture;
        block10: {
            try {
                this.getWorker().checkShutdown();
            }
            catch (ClosedWorkerException e) {
                return new FailedIoFuture((IOException)((Object)e));
            }
            final FutureResult futureResult = new FutureResult((Executor)((Object)this));
            boolean ok = false;
            final ServerSocketChannel serverChannel = ServerSocketChannel.open();
            try {
                serverChannel.configureBlocking(false);
                if (optionMap.contains(Options.RECEIVE_BUFFER)) {
                    serverChannel.socket().setReceiveBufferSize(optionMap.get(Options.RECEIVE_BUFFER, -1));
                }
                serverChannel.socket().setReuseAddress(optionMap.get(Options.REUSE_ADDRESSES, true));
                serverChannel.bind(destination);
                if (bindListener != null) {
                    ChannelListeners.invokeChannelListener((Channel)new BoundChannel(){

                        public SocketAddress getLocalAddress() {
                            return serverChannel.socket().getLocalSocketAddress();
                        }

                        public <A extends SocketAddress> A getLocalAddress(Class<A> type) {
                            SocketAddress address = this.getLocalAddress();
                            return (A)(type.isInstance(address) ? (SocketAddress)type.cast(address) : null);
                        }

                        public ChannelListener.Setter<? extends BoundChannel> getCloseSetter() {
                            return new ChannelListener.SimpleSetter();
                        }

                        public XnioWorker getWorker() {
                            return WorkerThread.this.getWorker();
                        }

                        public XnioIoThread getIoThread() {
                            return WorkerThread.this;
                        }

                        public void close() throws IOException {
                            serverChannel.close();
                        }

                        public boolean isOpen() {
                            return serverChannel.isOpen();
                        }

                        public boolean supportsOption(Option<?> option) {
                            return false;
                        }

                        public <T> T getOption(Option<T> option) throws IOException {
                            return null;
                        }

                        public <T> T setOption(Option<T> option, T value) throws IllegalArgumentException, IOException {
                            return null;
                        }
                    }, bindListener);
                }
                SelectionKey key = this.registerChannel(serverChannel);
                NioHandle handle = new NioHandle(this, key){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    void handleReady(int ops) {
                        boolean ok = false;
                        try {
                            SocketChannel channel = serverChannel.accept();
                            if (channel == null) {
                                ok = true;
                                return;
                            }
                            IoUtils.safeClose((Closeable)serverChannel);
                            try {
                                SelectionKey selectionKey;
                                NioSocketStreamConnection connection;
                                channel.configureBlocking(false);
                                if (optionMap.contains(Options.TCP_OOB_INLINE)) {
                                    channel.socket().setOOBInline(optionMap.get(Options.TCP_OOB_INLINE, false));
                                }
                                if (optionMap.contains(Options.TCP_NODELAY)) {
                                    channel.socket().setTcpNoDelay(optionMap.get(Options.TCP_NODELAY, false));
                                }
                                if (optionMap.contains(Options.IP_TRAFFIC_CLASS)) {
                                    channel.socket().setTrafficClass(optionMap.get(Options.IP_TRAFFIC_CLASS, -1));
                                }
                                if (optionMap.contains(Options.CLOSE_ABORT)) {
                                    channel.socket().setSoLinger(optionMap.get(Options.CLOSE_ABORT, false), 0);
                                }
                                if (optionMap.contains(Options.KEEP_ALIVE)) {
                                    channel.socket().setKeepAlive(optionMap.get(Options.KEEP_ALIVE, false));
                                }
                                if (optionMap.contains(Options.SEND_BUFFER)) {
                                    channel.socket().setSendBufferSize(optionMap.get(Options.SEND_BUFFER, -1));
                                }
                                if (futureResult.setResult((Object)(connection = new NioSocketStreamConnection(WorkerThread.this, selectionKey = WorkerThread.this.registerChannel(channel), null)))) {
                                    ok = true;
                                    ChannelListeners.invokeChannelListener((Channel)((Object)connection), (ChannelListener)openListener);
                                }
                            }
                            finally {
                                if (!ok) {
                                    IoUtils.safeClose((Closeable)channel);
                                }
                            }
                        }
                        catch (IOException e) {
                            futureResult.setException(e);
                        }
                        finally {
                            if (!ok) {
                                IoUtils.safeClose((Closeable)serverChannel);
                            }
                        }
                    }

                    @Override
                    void terminated() {
                    }

                    @Override
                    void forceTermination() {
                        futureResult.setCancelled();
                    }
                };
                key.attach(handle);
                handle.resume(16);
                ok = true;
                futureResult.addCancelHandler(new Cancellable(){

                    public Cancellable cancel() {
                        if (futureResult.setCancelled()) {
                            IoUtils.safeClose((Closeable)serverChannel);
                        }
                        return this;
                    }
                });
                ioFuture = futureResult.getIoFuture();
                if (ok) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (!ok) {
                        IoUtils.safeClose((Closeable)serverChannel);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return new FailedIoFuture(e);
                }
            }
            IoUtils.safeClose((Closeable)serverChannel);
        }
        return ioFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected IoFuture<StreamConnection> openTcpStreamConnection(InetSocketAddress bindAddress, InetSocketAddress destinationAddress, ChannelListener<? super StreamConnection> openListener, ChannelListener<? super BoundChannel> bindListener, OptionMap optionMap) {
        try {
            this.getWorker().checkShutdown();
        }
        catch (ClosedWorkerException e) {
            return new FailedIoFuture((IOException)((Object)e));
        }
        try {
            SocketChannel channel = SocketChannel.open();
            boolean ok = false;
            try {
                channel.configureBlocking(false);
                if (optionMap.contains(Options.TCP_OOB_INLINE)) {
                    channel.socket().setOOBInline(optionMap.get(Options.TCP_OOB_INLINE, false));
                }
                if (optionMap.contains(Options.TCP_NODELAY)) {
                    channel.socket().setTcpNoDelay(optionMap.get(Options.TCP_NODELAY, false));
                }
                if (optionMap.contains(Options.IP_TRAFFIC_CLASS)) {
                    channel.socket().setTrafficClass(optionMap.get(Options.IP_TRAFFIC_CLASS, -1));
                }
                if (optionMap.contains(Options.CLOSE_ABORT)) {
                    channel.socket().setSoLinger(optionMap.get(Options.CLOSE_ABORT, false), 0);
                }
                if (optionMap.contains(Options.KEEP_ALIVE)) {
                    channel.socket().setKeepAlive(optionMap.get(Options.KEEP_ALIVE, false));
                }
                if (optionMap.contains(Options.RECEIVE_BUFFER)) {
                    channel.socket().setReceiveBufferSize(optionMap.get(Options.RECEIVE_BUFFER, -1));
                }
                if (optionMap.contains(Options.REUSE_ADDRESSES)) {
                    channel.socket().setReuseAddress(optionMap.get(Options.REUSE_ADDRESSES, false));
                }
                if (optionMap.contains(Options.SEND_BUFFER)) {
                    channel.socket().setSendBufferSize(optionMap.get(Options.SEND_BUFFER, -1));
                }
                SelectionKey key = this.registerChannel(channel);
                final NioSocketStreamConnection connection = new NioSocketStreamConnection(this, key, null);
                if (bindAddress != null || bindListener != null) {
                    channel.socket().bind(bindAddress);
                    ChannelListeners.invokeChannelListener((Channel)((Object)connection), bindListener);
                }
                if (channel.connect(destinationAddress)) {
                    this.execute(ChannelListeners.getChannelListenerTask((Channel)((Object)connection), openListener));
                    FinishedIoFuture finishedIoFuture2 = new FinishedIoFuture((Object)connection);
                    ok = true;
                    FinishedIoFuture finishedIoFuture = finishedIoFuture2;
                    return finishedIoFuture;
                }
                final FutureResult futureResult = new FutureResult((Executor)((Object)this));
                ConnectHandle connectHandle = new ConnectHandle(this, key, (FutureResult<StreamConnection>)futureResult, connection, openListener);
                key.attach(connectHandle);
                futureResult.addCancelHandler(new Cancellable(){

                    public Cancellable cancel() {
                        if (futureResult.setCancelled()) {
                            IoUtils.safeClose((Closeable)((Object)connection));
                        }
                        return this;
                    }
                });
                connectHandle.resume(8);
                ok = true;
                IoFuture ioFuture = futureResult.getIoFuture();
                return ioFuture;
            }
            finally {
                if (!ok) {
                    IoUtils.safeClose((Closeable)channel);
                }
            }
        }
        catch (IOException e) {
            return new FailedIoFuture(e);
        }
    }

    WorkerThread getNextThread() {
        WorkerThread[] all = this.getWorker().getAll();
        int number = this.getNumber();
        if (number == all.length - 1) {
            return all[0];
        }
        return all[number + 1];
    }

    private static WorkerThread getPeerThread(XnioIoFactory peer) throws ClosedWorkerException {
        WorkerThread peerThread;
        if (peer instanceof NioXnioWorker) {
            NioXnioWorker peerWorker = (NioXnioWorker)peer;
            peerWorker.checkShutdown();
            peerThread = peerWorker.chooseThread();
        } else if (peer instanceof WorkerThread) {
            peerThread = (WorkerThread)peer;
            peerThread.getWorker().checkShutdown();
        } else {
            throw Log.log.notNioProvider();
        }
        return peerThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChannelPipe<StreamConnection, StreamConnection> createFullDuplexPipeConnection(XnioIoFactory peer) throws IOException {
        this.getWorker().checkShutdown();
        boolean ok = false;
        Pipe topPipe = Pipe.open();
        try {
            ChannelPipe channelPipe;
            block8: {
                topPipe.source().configureBlocking(false);
                topPipe.sink().configureBlocking(false);
                Pipe bottomPipe = Pipe.open();
                try {
                    bottomPipe.source().configureBlocking(false);
                    bottomPipe.sink().configureBlocking(false);
                    WorkerThread peerThread = WorkerThread.getPeerThread(peer);
                    SelectionKey topSourceKey = this.registerChannel(topPipe.source());
                    SelectionKey topSinkKey = peerThread.registerChannel(topPipe.sink());
                    SelectionKey bottomSourceKey = peerThread.registerChannel(bottomPipe.source());
                    SelectionKey bottomSinkKey = this.registerChannel(bottomPipe.sink());
                    NioPipeStreamConnection leftConnection = new NioPipeStreamConnection(this, bottomSourceKey, topSinkKey);
                    NioPipeStreamConnection rightConnection = new NioPipeStreamConnection(this, topSourceKey, bottomSinkKey);
                    ChannelPipe result = new ChannelPipe((CloseableChannel)leftConnection, (CloseableChannel)rightConnection);
                    ok = true;
                    channelPipe = result;
                    if (ok) break block8;
                }
                catch (Throwable throwable) {
                    if (!ok) {
                        IoUtils.safeClose((Closeable)bottomPipe.sink());
                        IoUtils.safeClose((Closeable)bottomPipe.source());
                    }
                    throw throwable;
                }
                IoUtils.safeClose((Closeable)bottomPipe.sink());
                IoUtils.safeClose((Closeable)bottomPipe.source());
            }
            return channelPipe;
        }
        finally {
            if (!ok) {
                IoUtils.safeClose((Closeable)topPipe.sink());
                IoUtils.safeClose((Closeable)topPipe.source());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChannelPipe<StreamSourceChannel, StreamSinkChannel> createHalfDuplexPipe(XnioIoFactory peer) throws IOException {
        this.getWorker().checkShutdown();
        Pipe pipe = Pipe.open();
        boolean ok = false;
        try {
            pipe.source().configureBlocking(false);
            pipe.sink().configureBlocking(false);
            WorkerThread peerThread = WorkerThread.getPeerThread(peer);
            SelectionKey readKey = this.registerChannel(pipe.source());
            SelectionKey writeKey = peerThread.registerChannel(pipe.sink());
            NioPipeStreamConnection leftConnection = new NioPipeStreamConnection(this, readKey, null);
            NioPipeStreamConnection rightConnection = new NioPipeStreamConnection(this, null, writeKey);
            leftConnection.writeClosed();
            rightConnection.readClosed();
            ChannelPipe result = new ChannelPipe((CloseableChannel)leftConnection.getSourceChannel(), (CloseableChannel)rightConnection.getSinkChannel());
            ok = true;
            ChannelPipe channelPipe = result;
            return channelPipe;
        }
        finally {
            if (!ok) {
                IoUtils.safeClose((Closeable)pipe.sink());
                IoUtils.safeClose((Closeable)pipe.source());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void run() {
        selector = this.selector;
        try {
            Log.log.tracef("Starting worker thread %s", (Object)this);
            lock = this.workLock;
            workQueue = this.selectorWorkQueue;
            delayQueue = this.delayWorkQueue;
            Log.log.debugf("Started channel thread '%s', selector %s", WorkerThread.currentThread().getName(), selector);
            delayTime = 0x7FFFFFFFFFFFFFFFL;
            keys = new SelectionKey[16];
            while (true) {
                block53: {
                    var13_12 = lock;
                    synchronized (var13_12) {
                        task = workQueue.poll();
                        if (task == null) {
                            iterator = delayQueue.iterator();
                            delayTime = 0x7FFFFFFFFFFFFFFFL;
                            if (iterator.hasNext()) {
                                now = System.nanoTime();
                                do {
                                    if (TimeKey.access$000(key = iterator.next()) > now - WorkerThread.START_TIME) {
                                        delayTime = TimeKey.access$000(key) - (now - WorkerThread.START_TIME);
                                        break;
                                    }
                                    workQueue.add(TimeKey.access$100(key));
                                    iterator.remove();
                                } while (iterator.hasNext());
                            }
                            task = workQueue.poll();
                        }
                    }
                    WorkerThread.safeRun(task);
                    if (task != null) continue;
                    oldState = this.state;
                    if ((oldState & -2147483648) != 0) {
                        var13_12 = lock;
                        synchronized (var13_12) {
                            block52: {
                                keyCount = selector.keys().size();
                                this.state = keyCount | -2147483648;
                                if (keyCount != 0 || !workQueue.isEmpty()) break block52;
                                return;
                            }
                            ** try [egrp 4[TRYBLOCK] [3 : 299->305)] { 
                            {
                            }
                        }
lbl48:
                        // 1 sources

                        var13_12 = selector;
                        synchronized (var13_12) {
                            var15_22 = keySet = selector.keys();
                            synchronized (var15_22) {
                                keys = (SelectionKey[])keySet.toArray(keys);
                                Arrays.fill(keys, keySet.size(), keys.length, null);
                            }
                        }
                        for (i = 0; i < keys.length && (key = keys[i]) != null; ++i) {
                            keys[i] = null;
                            attachment = (NioHandle)key.attachment();
                            if (attachment == null) continue;
                            IoUtils.safeClose((Closeable)key.channel());
                            attachment.forceTermination();
                        }
                        Arrays.fill(keys, 0, keys.length, null);
                    }
                    try {
                        if ((oldState & -2147483648) != 0) {
                            Log.selectorLog.tracef("Beginning select on %s (shutdown in progress)", selector);
                            selector.selectNow();
                            break block53;
                        }
                        if (delayTime == 0x7FFFFFFFFFFFFFFFL) {
                            Log.selectorLog.tracef("Beginning select on %s", selector);
                            this.polling = true;
                            try {
                                if (workQueue.peek() != null) {
                                    selector.selectNow();
                                } else {
                                    selector.select();
                                }
                                break block53;
                            }
                            finally {
                                this.polling = false;
                            }
                        }
                        millis = 1L + delayTime / 1000000L;
                        Log.selectorLog.tracef("Beginning select on %s (with timeout)", selector);
                        this.polling = true;
                        try {
                            if (workQueue.peek() != null) {
                                selector.selectNow();
                            } else {
                                selector.select(millis);
                            }
                        }
                        finally {
                            this.polling = false;
                        }
                    }
                    catch (CancelledKeyException ignored) {
                        Log.selectorLog.trace("Spurious cancelled key exception");
                    }
                    catch (IOException e) {
                        Log.selectorLog.selectionError(e);
                    }
                }
                Log.selectorLog.tracef("Selected on %s", selector);
                e = selector;
                synchronized (e) {
                    selectedKeys = selector.selectedKeys();
                    key = selectedKeys;
                    synchronized (key) {
                        keys = selectedKeys.toArray(keys);
                        Arrays.fill(keys, selectedKeys.size(), keys.length, null);
                        selectedKeys.clear();
                    }
                }
                i = 0;
                while (true) {
                    if (i >= keys.length || (key = keys[i]) == null) ** break;
                    keys[i] = null;
                    try {
                        ops = key.interestOps();
                        if (ops != 0) {
                            Log.selectorLog.tracef("Selected key %s for %s", key, key.channel());
                            handle = (NioHandle)key.attachment();
                            if (handle == null) {
                                this.cancelKey((SelectionKey)key);
                            } else {
                                handle.handleReady(key.readyOps());
                            }
                        }
                    }
                    catch (CancelledKeyException ignored) {
                        Log.selectorLog.tracef("Skipping selection of cancelled key %s", key);
                    }
                    catch (Throwable t) {
                        Log.selectorLog.tracef(t, "Unexpected failure of selection of key %s", key);
                    }
                    ++i;
                }
                break;
            }
        }
        finally {
            Log.log.tracef("Shutting down channel thread \"%s\"", (Object)this);
            IoUtils.safeClose((Selector)selector);
            this.getWorker().closeResource();
        }
    }

    private static void safeRun(Runnable command) {
        if (command != null) {
            try {
                Log.log.tracef("Running task %s", command);
                command.run();
            }
            catch (Throwable t) {
                Log.log.taskFailed(command, t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Runnable command) {
        if ((this.state & Integer.MIN_VALUE) != 0) {
            throw Log.log.threadExiting();
        }
        Object object = this.workLock;
        synchronized (object) {
            this.selectorWorkQueue.add(command);
        }
        if (this.polling) {
            this.selector.wakeup();
        }
    }

    void shutdown() {
        int oldState;
        do {
            if (((oldState = this.state) & Integer.MIN_VALUE) == 0) continue;
            return;
        } while (!stateUpdater.compareAndSet(this, oldState, oldState | Integer.MIN_VALUE));
        if (WorkerThread.currentThread() != this) {
            this.selector.wakeup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XnioExecutor.Key executeAfter(Runnable command, long time, TimeUnit unit) {
        long millis = unit.toMillis(time);
        if ((this.state & Integer.MIN_VALUE) != 0) {
            throw Log.log.threadExiting();
        }
        if (millis <= 0L) {
            this.execute(command);
            return XnioExecutor.Key.IMMEDIATE;
        }
        long deadline = System.nanoTime() - START_TIME + Math.min(millis, 9223372036853L) * 1000000L;
        TimeKey key = new TimeKey(deadline, command);
        Object object = this.workLock;
        synchronized (object) {
            TreeSet<TimeKey> queue = this.delayWorkQueue;
            queue.add(key);
            if (queue.iterator().next() == key && this.polling) {
                this.selector.wakeup();
            }
            return key;
        }
    }

    public XnioExecutor.Key executeAtInterval(Runnable command, long time, TimeUnit unit) {
        long millis = unit.toMillis(time);
        RepeatKey repeatKey = new RepeatKey(command, millis);
        XnioExecutor.Key firstKey = this.executeAfter(repeatKey, millis, TimeUnit.MILLISECONDS);
        repeatKey.setFirst(firstKey);
        return repeatKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SelectionKey registerChannel(AbstractSelectableChannel channel) throws ClosedChannelException {
        if (WorkerThread.currentThread() == this) {
            return channel.register(this.selector, 0);
        }
        if (THREAD_SAFE_SELECTION_KEYS) {
            try {
                SelectionKey selectionKey = channel.register(this.selector, 0);
                return selectionKey;
            }
            finally {
                if (this.polling) {
                    this.selector.wakeup();
                }
            }
        }
        SynchTask task = new SynchTask();
        this.queueTask(task);
        try {
            this.selector.wakeup();
            SelectionKey selectionKey = channel.register(this.selector, 0);
            return selectionKey;
        }
        finally {
            task.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void queueTask(Runnable task) {
        Object object = this.workLock;
        synchronized (object) {
            this.selectorWorkQueue.add(task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancelKey(SelectionKey key) {
        assert (key.selector() == this.selector);
        SelectableChannel channel = key.channel();
        if (WorkerThread.currentThread() == this) {
            Log.log.logf(FQCN, Logger.Level.TRACE, null, "Cancelling key %s of %s (same thread)", key, channel);
            try {
                key.cancel();
                try {
                    this.selector.selectNow();
                }
                catch (IOException e) {
                    Log.log.selectionError(e);
                }
            }
            catch (Throwable t) {
                Log.log.logf(FQCN, Logger.Level.TRACE, t, "Error cancelling key %s of %s (same thread)", key, channel);
            }
        } else if (OLD_LOCKING) {
            Log.log.logf(FQCN, Logger.Level.TRACE, null, "Cancelling key %s of %s (same thread, old locking)", key, channel);
            SynchTask task = new SynchTask();
            this.queueTask(task);
            try {
                this.selector.wakeup();
                key.cancel();
            }
            catch (Throwable t) {
                Log.log.logf(FQCN, Logger.Level.TRACE, t, "Error cancelling key %s of %s (same thread, old locking)", key, channel);
            }
            finally {
                task.done();
            }
        } else {
            Log.log.logf(FQCN, Logger.Level.TRACE, null, "Cancelling key %s of %s (other thread)", key, channel);
            try {
                key.cancel();
                this.selector.wakeup();
            }
            catch (Throwable t) {
                Log.log.logf(FQCN, Logger.Level.TRACE, t, "Error cancelling key %s of %s (other thread)", key, channel);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setOps(SelectionKey key, int ops) {
        if (WorkerThread.currentThread() == this) {
            try {
                key.interestOps(key.interestOps() | ops);
            }
            catch (CancelledKeyException ignored) {}
        } else if (OLD_LOCKING) {
            SynchTask task = new SynchTask();
            this.queueTask(task);
            try {
                this.selector.wakeup();
                key.interestOps(key.interestOps() | ops);
            }
            catch (CancelledKeyException ignored) {
            }
            finally {
                task.done();
            }
        } else {
            try {
                key.interestOps(key.interestOps() | ops);
                if (this.polling) {
                    this.selector.wakeup();
                }
            }
            catch (CancelledKeyException cancelledKeyException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearOps(SelectionKey key, int ops) {
        if (WorkerThread.currentThread() == this || !OLD_LOCKING) {
            try {
                key.interestOps(key.interestOps() & ~ops);
            }
            catch (CancelledKeyException ignored) {}
        } else {
            SynchTask task = new SynchTask();
            this.queueTask(task);
            try {
                this.selector.wakeup();
                key.interestOps(key.interestOps() & ~ops);
            }
            catch (CancelledKeyException ignored) {
            }
            finally {
                task.done();
            }
        }
    }

    Selector getSelector() {
        return this.selector;
    }

    public boolean equals(Object obj) {
        return obj == this;
    }

    public int hashCode() {
        return System.identityHashCode((Object)this);
    }

    static {
        START_TIME = System.nanoTime();
        stateUpdater = AtomicIntegerFieldUpdater.newUpdater(WorkerThread.class, "state");
        OLD_LOCKING = Boolean.parseBoolean((String)AccessController.doPrivileged(new ReadPropertyAction("xnio.nio.old-locking", "false")));
        THREAD_SAFE_SELECTION_KEYS = Boolean.parseBoolean((String)AccessController.doPrivileged(new ReadPropertyAction("xnio.nio.thread-safe-selection-keys", "false")));
        seqGen = new AtomicLong();
    }

    final class SynchTask
    implements Runnable {
        volatile boolean done;

        SynchTask() {
        }

        @Override
        public void run() {
            while (!this.done) {
                LockSupport.park();
            }
        }

        void done() {
            this.done = true;
            LockSupport.unpark((Thread)((Object)WorkerThread.this));
        }
    }

    final class TimeKey
    implements XnioExecutor.Key,
    Comparable<TimeKey> {
        private final long deadline;
        private final long seq = seqGen.incrementAndGet();
        private final Runnable command;

        TimeKey(long deadline, Runnable command) {
            this.deadline = deadline;
            this.command = command;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean remove() {
            Object object = WorkerThread.this.workLock;
            synchronized (object) {
                return WorkerThread.this.delayWorkQueue.remove(this);
            }
        }

        @Override
        public int compareTo(TimeKey o) {
            int r = Long.signum(this.deadline - o.deadline);
            if (r == 0) {
                r = Long.signum(this.seq - o.seq);
            }
            return r;
        }

        static /* synthetic */ long access$000(TimeKey x0) {
            return x0.deadline;
        }

        static /* synthetic */ Runnable access$100(TimeKey x0) {
            return x0.command;
        }
    }

    class RepeatKey
    implements XnioExecutor.Key,
    Runnable {
        private final Runnable command;
        private final long millis;
        private final AtomicReference<XnioExecutor.Key> current = new AtomicReference();

        RepeatKey(Runnable command, long millis) {
            this.command = command;
            this.millis = millis;
        }

        public boolean remove() {
            XnioExecutor.Key removed = this.current.getAndSet(this);
            assert (removed != null);
            return removed != this && removed.remove();
        }

        void setFirst(XnioExecutor.Key key) {
            this.current.compareAndSet(null, key);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.command.run();
            }
            finally {
                XnioExecutor.Key n;
                XnioExecutor.Key o = this.current.get();
                if (o != this && !this.current.compareAndSet(o, n = WorkerThread.this.executeAfter(this, this.millis, TimeUnit.MILLISECONDS))) {
                    n.remove();
                }
            }
        }
    }

    static final class ConnectHandle
    extends NioHandle {
        private final FutureResult<StreamConnection> futureResult;
        private final NioSocketStreamConnection connection;
        private final ChannelListener<? super StreamConnection> openListener;

        ConnectHandle(WorkerThread workerThread, SelectionKey selectionKey, FutureResult<StreamConnection> futureResult, NioSocketStreamConnection connection, ChannelListener<? super StreamConnection> openListener) {
            super(workerThread, selectionKey);
            this.futureResult = futureResult;
            this.connection = connection;
            this.openListener = openListener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void handleReady(int ops) {
            SocketChannel channel = this.getChannel();
            boolean ok = false;
            try {
                if (channel.finishConnect()) {
                    this.suspend(8);
                    this.getSelectionKey().attach(this.connection.getConduit());
                    if (this.futureResult.setResult((Object)this.connection)) {
                        ok = true;
                        ChannelListeners.invokeChannelListener((Channel)((Object)this.connection), this.openListener);
                    }
                }
            }
            catch (IOException e) {
                this.futureResult.setException(e);
            }
            finally {
                if (!ok) {
                    IoUtils.safeClose((Closeable)((Object)this.connection));
                }
            }
        }

        private SocketChannel getChannel() {
            return (SocketChannel)this.getSelectionKey().channel();
        }

        @Override
        void forceTermination() {
            this.futureResult.setCancelled();
            IoUtils.safeClose((Closeable)this.getChannel());
        }

        @Override
        void terminated() {
        }
    }
}

