package org.xnio.nio;

import java.io.InterruptedIOException;
import java.lang.IllegalStateException;
import java.io.Serializable;
import javax.annotation.Generated;
import org.jboss.logging.DelegatingBasicLogger;
import org.xnio.channels.ReadTimeoutException;
import java.lang.String;
import java.io.IOException;
import org.jboss.logging.Logger;
import java.util.concurrent.RejectedExecutionException;
import org.xnio.channels.WriteTimeoutException;
import java.nio.channels.spi.SelectorProvider;
import org.jboss.logging.BasicLogger;
import java.lang.Runnable;
import java.lang.Throwable;
import org.xnio.ClosedWorkerException;
import java.lang.Object;
import java.util.Arrays;
import java.lang.IllegalArgumentException;
import java.lang.UnsupportedOperationException;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2016-12-01T19:29:04-0600")
public class Log_$logger extends DelegatingBasicLogger implements Log,BasicLogger,Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    public Log_$logger(final Logger log) {
        super(log);
    }
    @Override
    public final void greeting(final String version) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.INFO, null, greeting$str(), version);
    }
    private static final String greeting = "XNIO NIO Implementation Version %s";
    protected String greeting$str() {
        return greeting;
    }
    @Override
    public final void taskFailed(final Runnable command, final Throwable cause) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.ERROR, cause, taskFailed$str(), command);
    }
    private static final String taskFailed = "XNIO000011: Task %s failed with an exception";
    protected String taskFailed$str() {
        return taskFailed;
    }
    private static final String parameterOutOfRange = "XNIO000015: Parameter '%s' is out of range";
    protected String parameterOutOfRange$str() {
        return parameterOutOfRange;
    }
    @Override
    public final IllegalArgumentException parameterOutOfRange(final String name) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(parameterOutOfRange$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String optionOutOfRange = "XNIO000039: Value for option '%s' is out of range";
    protected String optionOutOfRange$str() {
        return optionOutOfRange;
    }
    @Override
    public final IllegalArgumentException optionOutOfRange(final String name) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(optionOutOfRange$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String readTimeout = "XNIO000800: Read timed out";
    protected String readTimeout$str() {
        return readTimeout;
    }
    @Override
    public final ReadTimeoutException readTimeout() {
        final ReadTimeoutException result = new ReadTimeoutException(String.format(readTimeout$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String writeTimeout = "XNIO000801: Write timed out";
    protected String writeTimeout$str() {
        return writeTimeout;
    }
    @Override
    public final WriteTimeoutException writeTimeout() {
        final WriteTimeoutException result = new WriteTimeoutException(String.format(writeTimeout$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String interruptedIO = "XNIO000808: I/O operation was interrupted";
    protected String interruptedIO$str() {
        return interruptedIO;
    }
    @Override
    public final InterruptedIOException interruptedIO() {
        final InterruptedIOException result = new InterruptedIOException(String.format(interruptedIO$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final InterruptedIOException interruptedIO(final int bytesTransferred) {
        final InterruptedIOException result = new InterruptedIOException(String.format(interruptedIO$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        result.bytesTransferred = bytesTransferred;
        return result;
    }
    private static final String workerShutDown = "XNIO000815: Worker is shut down";
    protected String workerShutDown$str() {
        return workerShutDown;
    }
    @Override
    public final ClosedWorkerException workerShutDown() {
        final ClosedWorkerException result = new ClosedWorkerException(String.format(workerShutDown$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unsupported = "XNIO000900: Method '%s' is not supported on this implementation";
    protected String unsupported$str() {
        return unsupported;
    }
    @Override
    public final UnsupportedOperationException unsupported(final String methodName) {
        final UnsupportedOperationException result = new UnsupportedOperationException(String.format(unsupported$str(), methodName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void failedToInvokeFileWatchCallback(final Throwable cause) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.ERROR, cause, failedToInvokeFileWatchCallback$str());
    }
    private static final String failedToInvokeFileWatchCallback = "XNIO001006: Failed to invoke file watch callback";
    protected String failedToInvokeFileWatchCallback$str() {
        return failedToInvokeFileWatchCallback;
    }
    private static final String noThreads = "XNIO007000: No threads configured";
    protected String noThreads$str() {
        return noThreads;
    }
    @Override
    public final IllegalArgumentException noThreads() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(noThreads$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String balancingTokens = "XNIO007001: Balancing token count must be greater than zero and less than thread count";
    protected String balancingTokens$str() {
        return balancingTokens;
    }
    @Override
    public final IllegalArgumentException balancingTokens() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(balancingTokens$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String balancingConnectionCount = "XNIO007002: Balancing connection count must be greater than zero when tokens are used";
    protected String balancingConnectionCount$str() {
        return balancingConnectionCount;
    }
    @Override
    public final IllegalArgumentException balancingConnectionCount() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(balancingConnectionCount$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String bufferTooLarge = "XNIO007003: Buffer is too large";
    protected String bufferTooLarge$str() {
        return bufferTooLarge;
    }
    @Override
    public final IllegalArgumentException bufferTooLarge() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(bufferTooLarge$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noSelectorProvider = "XNIO007004: No functional selector provider is available";
    protected String noSelectorProvider$str() {
        return noSelectorProvider;
    }
    @Override
    public final IllegalStateException noSelectorProvider() {
        final IllegalStateException result = new IllegalStateException(String.format(noSelectorProvider$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unexpectedSelectorOpenProblem = "XNIO007005: Unexpected exception opening a selector";
    protected String unexpectedSelectorOpenProblem$str() {
        return unexpectedSelectorOpenProblem;
    }
    @Override
    public final IllegalStateException unexpectedSelectorOpenProblem(final Throwable cause) {
        final IllegalStateException result = new IllegalStateException(String.format(unexpectedSelectorOpenProblem$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String notNioProvider = "XNIO007006: XNIO IO factory is from the wrong provider";
    protected String notNioProvider$str() {
        return notNioProvider;
    }
    @Override
    public final IllegalArgumentException notNioProvider() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(notNioProvider$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String threadExiting = "XNIO007007: Thread is terminating";
    protected String threadExiting$str() {
        return threadExiting;
    }
    @Override
    public final RejectedExecutionException threadExiting() {
        final RejectedExecutionException result = new RejectedExecutionException(String.format(threadExiting$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void selectionError(final IOException e) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.WARN, null, selectionError$str(), e);
    }
    private static final String selectionError = "XNIO008000: Received an I/O error on selection: %s";
    protected String selectionError$str() {
        return selectionError;
    }
    @Override
    public final void selectorProvider(final SelectorProvider provider) {
        if (super.log.isEnabled(org.jboss.logging.Logger.Level.TRACE)) {
            final Class<? extends Object> providerClass;
            if (provider == null) {
                providerClass = null;
            }
            else providerClass = provider.getClass();

            super.log.logf(FQCN, org.jboss.logging.Logger.Level.TRACE, null, selectorProvider$str(), providerClass);
        }
    }
    private static final String selectorProvider = "Starting up with selector provider %s";
    protected String selectorProvider$str() {
        return selectorProvider;
    }
    @Override
    public final void selectors(final Object mainSelectorCreator, final Object tempSelectorCreator) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.TRACE, null, selectors$str(), mainSelectorCreator, tempSelectorCreator);
    }
    private static final String selectors = "Using %s for main selectors and %s for temp selectors";
    protected String selectors$str() {
        return selectors;
    }
}
