/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.collision.broadphase;

import java.util.Arrays;
import org.jbox2d.callbacks.DebugDraw;
import org.jbox2d.callbacks.PairCallback;
import org.jbox2d.callbacks.TreeCallback;
import org.jbox2d.callbacks.TreeRayCastCallback;
import org.jbox2d.collision.AABB;
import org.jbox2d.collision.RayCastInput;
import org.jbox2d.collision.broadphase.DynamicTree;
import org.jbox2d.collision.broadphase.DynamicTreeNode;
import org.jbox2d.collision.broadphase.Pair;
import org.jbox2d.common.Vec2;

public class BroadPhase
implements TreeCallback {
    public static final int NULL_PROXY = -1;
    private final DynamicTree m_tree;
    private int m_proxyCount = 0;
    private DynamicTreeNode[] m_moveBuffer;
    private int m_moveCapacity;
    private int m_moveCount;
    private Pair[] m_pairBuffer = new Pair[this.m_pairCapacity];
    private int m_pairCapacity = 16;
    private int m_pairCount = 0;
    private DynamicTreeNode m_queryProxy;

    public BroadPhase() {
        for (int i = 0; i < this.m_pairCapacity; ++i) {
            this.m_pairBuffer[i] = new Pair();
        }
        this.m_moveCapacity = 16;
        this.m_moveCount = 0;
        this.m_moveBuffer = new DynamicTreeNode[this.m_moveCapacity];
        this.m_tree = new DynamicTree();
        this.m_queryProxy = null;
    }

    public final DynamicTreeNode createProxy(AABB aabb, Object userData) {
        DynamicTreeNode node = this.m_tree.createProxy(aabb, userData);
        ++this.m_proxyCount;
        this.bufferMove(node);
        return node;
    }

    public final void destroyProxy(DynamicTreeNode proxy) {
        this.unbufferMove(proxy);
        --this.m_proxyCount;
        this.m_tree.destroyProxy(proxy);
    }

    public final void moveProxy(DynamicTreeNode proxy, AABB aabb, Vec2 displacement) {
        boolean buffer = this.m_tree.moveProxy(proxy, aabb, displacement);
        if (buffer) {
            this.bufferMove(proxy);
        }
    }

    public boolean testOverlap(DynamicTreeNode proxyA, DynamicTreeNode proxyB) {
        AABB a = proxyA.aabb;
        AABB b = proxyB.aabb;
        if (b.lowerBound.x - a.upperBound.x > 0.0f || b.lowerBound.y - a.upperBound.y > 0.0f) {
            return false;
        }
        return !(a.lowerBound.x - b.upperBound.x > 0.0f) && !(a.lowerBound.y - b.upperBound.y > 0.0f);
    }

    public final int getProxyCount() {
        return this.m_proxyCount;
    }

    public void drawTree(DebugDraw argDraw) {
        this.m_tree.drawTree(argDraw);
    }

    public final void updatePairs(PairCallback callback) {
        int i;
        this.m_pairCount = 0;
        for (i = 0; i < this.m_moveCount; ++i) {
            this.m_queryProxy = this.m_moveBuffer[i];
            if (this.m_queryProxy == null) continue;
            this.m_tree.query(this, this.m_queryProxy.aabb);
        }
        this.m_moveCount = 0;
        Arrays.sort(this.m_pairBuffer, 0, this.m_pairCount);
        i = 0;
        block1: while (i < this.m_pairCount) {
            Pair primaryPair = this.m_pairBuffer[i];
            Object userDataA = primaryPair.proxyA.userData;
            Object userDataB = primaryPair.proxyB.userData;
            callback.addPair(userDataA, userDataB);
            ++i;
            while (i < this.m_pairCount) {
                Pair pair = this.m_pairBuffer[i];
                if (pair.proxyA != primaryPair.proxyA || pair.proxyB != primaryPair.proxyB) continue block1;
                ++i;
            }
        }
        this.m_tree.rebalance(4);
    }

    public final void query(TreeCallback callback, AABB aabb) {
        this.m_tree.query(callback, aabb);
    }

    public final void raycast(TreeRayCastCallback callback, RayCastInput input) {
        this.m_tree.raycast(callback, input);
    }

    public final int computeHeight() {
        return this.m_tree.computeHeight();
    }

    protected final void bufferMove(DynamicTreeNode node) {
        if (this.m_moveCount == this.m_moveCapacity) {
            DynamicTreeNode[] old = this.m_moveBuffer;
            this.m_moveCapacity *= 2;
            this.m_moveBuffer = new DynamicTreeNode[this.m_moveCapacity];
            for (int i = 0; i < old.length; ++i) {
                this.m_moveBuffer[i] = old[i];
            }
        }
        this.m_moveBuffer[this.m_moveCount] = node;
        ++this.m_moveCount;
    }

    protected final void unbufferMove(DynamicTreeNode proxy) {
        for (int i = 0; i < this.m_moveCount; ++i) {
            if (this.m_moveBuffer[i] != proxy) continue;
            this.m_moveBuffer[i] = null;
            return;
        }
    }

    @Override
    public final boolean treeCallback(DynamicTreeNode proxy) {
        if (proxy == this.m_queryProxy) {
            return true;
        }
        if (this.m_pairCount == this.m_pairCapacity) {
            int i;
            Pair[] oldBuffer = this.m_pairBuffer;
            this.m_pairCapacity *= 2;
            this.m_pairBuffer = new Pair[this.m_pairCapacity];
            for (i = 0; i < oldBuffer.length; ++i) {
                this.m_pairBuffer[i] = oldBuffer[i];
            }
            for (i = oldBuffer.length; i < this.m_pairCapacity; ++i) {
                this.m_pairBuffer[i] = new Pair();
            }
        }
        if (proxy.key < this.m_queryProxy.key) {
            this.m_pairBuffer[this.m_pairCount].proxyA = proxy;
            this.m_pairBuffer[this.m_pairCount].proxyB = this.m_queryProxy;
        } else {
            this.m_pairBuffer[this.m_pairCount].proxyA = this.m_queryProxy;
            this.m_pairBuffer[this.m_pairCount].proxyB = proxy;
        }
        ++this.m_pairCount;
        return true;
    }
}

