/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.collision.broadphase;

import java.util.Stack;
import org.jbox2d.callbacks.DebugDraw;
import org.jbox2d.callbacks.TreeCallback;
import org.jbox2d.callbacks.TreeRayCastCallback;
import org.jbox2d.collision.AABB;
import org.jbox2d.collision.RayCastInput;
import org.jbox2d.collision.broadphase.DynamicTreeNode;
import org.jbox2d.common.Color3f;
import org.jbox2d.common.MathUtils;
import org.jbox2d.common.Settings;
import org.jbox2d.common.Vec2;
import org.jbox2d.pooling.IOrderedStack;
import org.jbox2d.pooling.OrderedStack;

public class DynamicTree {
    public static final int MAX_STACK_SIZE = 128;
    private DynamicTreeNode m_root = null;
    private int m_nodeCount = 0;
    private DynamicTreeNode lastLeaf = null;
    private int m_insertionCount = 0;
    private int m_path = 0;
    private final Stack<DynamicTreeNode> nodeStack = new Stack();
    private final Vec2[] drawVecs = new Vec2[4];
    private int nodeCounter = 0;
    private final Vec2 d = new Vec2();
    private final IOrderedStack<Vec2> vec2s = new OrderedStack<Vec2>(Vec2.class, 388, 10);
    private final AABB aabb = new AABB();
    private final RayCastInput subInput = new RayCastInput();
    private final Vec2 center = new Vec2();
    private final Vec2 delta1 = new Vec2();
    private final Vec2 delta2 = new Vec2();
    private final AABB oldAABB = new AABB();
    private final Color3f color = new Color3f();
    private final Vec2 textVec = new Vec2();

    public DynamicTree() {
        for (int i = 0; i < this.drawVecs.length; ++i) {
            this.drawVecs[i] = new Vec2();
        }
    }

    public final DynamicTreeNode createProxy(AABB argAABB, Object argUserData) {
        DynamicTreeNode proxy = this.allocateNode();
        proxy.aabb.lowerBound.x = argAABB.lowerBound.x - Settings.aabbExtension;
        proxy.aabb.lowerBound.y = argAABB.lowerBound.y - Settings.aabbExtension;
        proxy.aabb.upperBound.x = argAABB.upperBound.x + Settings.aabbExtension;
        proxy.aabb.upperBound.y = argAABB.upperBound.y + Settings.aabbExtension;
        proxy.userData = argUserData;
        this.insertLeaf(proxy);
        int iterationCount = this.m_nodeCount >> 4;
        int height = this.computeHeight();
        for (int tryCount = 0; height > 64 && tryCount < 10; ++tryCount) {
            this.rebalance(iterationCount);
            height = this.computeHeight();
        }
        return proxy;
    }

    public final void destroyProxy(DynamicTreeNode argProxy) {
        assert (argProxy != null);
        assert (argProxy.isLeaf());
        this.removeLeaf(argProxy);
        this.freeNode(argProxy);
    }

    public final boolean moveProxy(DynamicTreeNode argProxy, AABB argAABB, Vec2 displacement) {
        assert (argProxy != null);
        assert (argProxy.isLeaf());
        if (argProxy.aabb.contains(argAABB)) {
            return false;
        }
        this.removeLeaf(argProxy);
        argAABB.lowerBound.x -= Settings.aabbExtension;
        argAABB.lowerBound.y -= Settings.aabbExtension;
        argAABB.upperBound.x += Settings.aabbExtension;
        argAABB.upperBound.y += Settings.aabbExtension;
        this.d.set(displacement).mulLocal(Settings.aabbMultiplier);
        if (this.d.x < 0.0f) {
            argAABB.lowerBound.x += this.d.x;
        } else {
            argAABB.upperBound.x += this.d.x;
        }
        if (this.d.y < 0.0f) {
            argAABB.lowerBound.y += this.d.y;
        } else {
            argAABB.upperBound.y += this.d.y;
        }
        argProxy.aabb.set(argAABB);
        this.insertLeaf(argProxy);
        return true;
    }

    public final void rebalance(int argIterations) {
        if (this.m_root == null) {
            return;
        }
        for (int i = 0; i < argIterations; ++i) {
            DynamicTreeNode currNode = this.m_root;
            int bit = 0;
            while (!currNode.isLeaf()) {
                int goLeft = this.m_path >> bit & 1;
                currNode = goLeft == 0 ? currNode.child1 : currNode.child2;
                bit = bit + 1 & 0x1F;
            }
            ++this.m_path;
            this.removeLeaf(currNode);
            this.insertLeaf(currNode);
        }
    }

    public final void query(TreeCallback argCallback, AABB argAABB) {
        this.query(argCallback, argAABB, this.m_root, 1);
    }

    private final boolean query(TreeCallback argCallback, AABB argAABB, DynamicTreeNode argNode, int count) {
        if (argNode == null) {
            return true;
        }
        if (AABB.testOverlap(argAABB, argNode.aabb)) {
            if (argNode.isLeaf()) {
                boolean proceed = argCallback.treeCallback(argNode);
                if (!proceed) {
                    return false;
                }
            } else {
                boolean proceed;
                if (count < 128 && !(proceed = this.query(argCallback, argAABB, argNode.child1, ++count))) {
                    return false;
                }
                if (count < 128 && !(proceed = this.query(argCallback, argAABB, argNode.child2, ++count))) {
                    return false;
                }
            }
        }
        return true;
    }

    public void raycast(TreeRayCastCallback argCallback, RayCastInput argInput) {
        Vec2 r = this.vec2s.pop();
        Vec2 v = this.vec2s.pop();
        Vec2 absV = this.vec2s.pop();
        Vec2 p1 = argInput.p1;
        Vec2 p2 = argInput.p2;
        r.set(p2).subLocal(p1);
        assert (r.lengthSquared() > 0.0f);
        r.normalize();
        Vec2.crossToOut(1.0f, r, v);
        absV.set(v).absLocal();
        float[] maxFraction = new float[]{argInput.maxFraction};
        AABB segAABB = this.aabb;
        Vec2 temp = this.vec2s.pop();
        temp.set(p2).subLocal(p1).mulLocal(maxFraction[0]).addLocal(p1);
        Vec2.minToOut(p1, temp, segAABB.lowerBound);
        Vec2.maxToOut(p1, temp, segAABB.upperBound);
        this.raycast(this.m_root, argInput, 0, segAABB, v, p1, p2, absV, maxFraction, argCallback);
        this.vec2s.push(4);
    }

    public boolean raycast(DynamicTreeNode argNode, RayCastInput argInput, int argCount, AABB argSegAABB, Vec2 argV, Vec2 argP1, Vec2 argP2, Vec2 argAbs_v, float[] argMaxFraction, TreeRayCastCallback argCallback) {
        if (argNode == null) {
            return false;
        }
        if (!AABB.testOverlap(argNode.aabb, argSegAABB)) {
            return false;
        }
        Vec2 temp = this.vec2s.pop();
        Vec2 c = this.vec2s.pop();
        Vec2 h = this.vec2s.pop();
        argNode.aabb.getCenterToOut(c);
        argNode.aabb.getExtentsToOut(h);
        temp.set(argP1).subLocal(c);
        float separation = MathUtils.abs(Vec2.dot(argV, temp)) - Vec2.dot(argAbs_v, h);
        if (separation > 0.0f) {
            this.vec2s.push(3);
            return false;
        }
        if (argNode.isLeaf()) {
            this.subInput.p1.set(argInput.p1);
            this.subInput.p2.set(argInput.p2);
            this.subInput.maxFraction = argMaxFraction[0];
            float value = argCallback.raycastCallback(this.subInput, argNode);
            if (value == 0.0f) {
                this.vec2s.push(3);
                return true;
            }
            if (value > 0.0f) {
                argMaxFraction[0] = value;
                temp.set(argP2).subLocal(argP1).mulLocal(value).addLocal(argP1);
                Vec2.minToOut(argP1, temp, argSegAABB.lowerBound);
                Vec2.maxToOut(argP1, temp, argSegAABB.upperBound);
            }
        } else {
            if (argCount < 128 && this.raycast(argNode.child1, argInput, ++argCount, argSegAABB, argV, argP1, argP2, argAbs_v, argMaxFraction, argCallback)) {
                this.vec2s.push(3);
                return true;
            }
            if (argCount < 128 && this.raycast(argNode.child2, argInput, ++argCount, argSegAABB, argV, argP1, argP2, argAbs_v, argMaxFraction, argCallback)) {
                this.vec2s.push(3);
                return true;
            }
        }
        this.vec2s.push(3);
        return false;
    }

    public final int computeHeight() {
        return this.computeHeight(this.m_root);
    }

    private final int computeHeight(DynamicTreeNode argNode) {
        if (argNode == null) {
            return 0;
        }
        assert (argNode != null);
        int height1 = this.computeHeight(argNode.child1);
        int height2 = this.computeHeight(argNode.child2);
        return 1 + MathUtils.max(height1, height2);
    }

    private final DynamicTreeNode allocateNode() {
        if (this.nodeStack.isEmpty()) {
            this.nodeStack.push(new DynamicTreeNode());
            this.nodeStack.push(new DynamicTreeNode());
            this.nodeStack.push(new DynamicTreeNode());
            this.nodeStack.push(new DynamicTreeNode());
            this.nodeStack.push(new DynamicTreeNode());
            this.nodeStack.push(new DynamicTreeNode());
        }
        DynamicTreeNode node = this.nodeStack.pop();
        node.parent = null;
        node.child1 = null;
        node.child2 = null;
        node.userData = null;
        node.key = this.nodeCounter++;
        ++this.m_nodeCount;
        return node;
    }

    private final void freeNode(DynamicTreeNode argNode) {
        assert (argNode != null);
        assert (0 < this.m_nodeCount);
        this.nodeStack.push(argNode);
        --this.m_nodeCount;
    }

    private final void insertLeaf(DynamicTreeNode argNode) {
        ++this.m_insertionCount;
        if (this.m_root == null) {
            this.m_root = argNode;
            argNode.parent = null;
            return;
        }
        argNode.aabb.getCenterToOut(this.center);
        DynamicTreeNode sibling = this.m_root;
        if (!sibling.isLeaf()) {
            DynamicTreeNode child2;
            DynamicTreeNode child1;
            float norm2;
            float norm1;
            do {
                child1 = sibling.child1;
                child2 = sibling.child2;
                child1.aabb.getCenterToOut(this.delta1);
                child2.aabb.getCenterToOut(this.delta2);
                this.delta1.subLocal(this.center).absLocal();
                this.delta2.subLocal(this.center).absLocal();
            } while (!(sibling = (norm1 = this.delta1.x + this.delta1.y) < (norm2 = this.delta2.x + this.delta2.y) ? child1 : child2).isLeaf());
        }
        DynamicTreeNode node1 = sibling.parent;
        DynamicTreeNode node2 = this.allocateNode();
        node2.parent = node1;
        node2.userData = null;
        node2.aabb.combine(argNode.aabb, sibling.aabb);
        if (node1 != null) {
            if (sibling.parent.child1 == sibling) {
                node1.child1 = node2;
            } else {
                node1.child2 = node2;
            }
            node2.child1 = sibling;
            node2.child2 = argNode;
            sibling.parent = node2;
            argNode.parent = node2;
            while (!node1.aabb.contains(node2.aabb)) {
                node1.aabb.combine(node1.child1.aabb, node1.child2.aabb);
                node2 = node1;
                node1 = node1.parent;
                if (node1 != null) continue;
                break;
            }
        } else {
            node2.child1 = sibling;
            node2.child2 = argNode;
            sibling.parent = node2;
            argNode.parent = node2;
            this.m_root = node2;
        }
    }

    private final void removeLeaf(DynamicTreeNode argNode) {
        if (argNode == this.m_root) {
            this.m_root = null;
            if (this.lastLeaf == argNode) {
                this.lastLeaf = null;
            }
            return;
        }
        DynamicTreeNode node2 = argNode.parent;
        DynamicTreeNode node1 = node2.parent;
        DynamicTreeNode sibling = node2.child1 == argNode ? node2.child2 : node2.child1;
        if (node1 != null) {
            if (node1.child1 == node2) {
                node1.child1 = sibling;
            } else {
                node1.child2 = sibling;
            }
            sibling.parent = node1;
            this.freeNode(node2);
            while (node1 != null) {
                this.oldAABB.set(node1.aabb);
                node1.aabb.combine(node1.child1.aabb, node1.child2.aabb);
                if (!this.oldAABB.contains(node1.aabb)) {
                    node1 = node1.parent;
                    continue;
                }
                break;
            }
        } else {
            this.m_root = sibling;
            sibling.parent = null;
            this.freeNode(node2);
        }
        if (this.lastLeaf == argNode) {
            this.lastLeaf = this.m_root;
        }
    }

    public void drawTree(DebugDraw argDraw) {
        if (this.m_root == null) {
            return;
        }
        int height = this.computeHeight();
        this.drawTree(argDraw, this.m_root, 0, height);
    }

    public void drawTree(DebugDraw argDraw, DynamicTreeNode argNode, int spot, int height) {
        argNode.aabb.getVertices(this.drawVecs);
        this.color.set(1.0f, (float)(height - spot) * 1.0f / (float)height, (float)(height - spot) * 1.0f / (float)height);
        argDraw.drawPolygon(this.drawVecs, 4, this.color);
        argDraw.getViewportTranform().getWorldToScreen(argNode.aabb.upperBound, this.textVec);
        argDraw.drawString(this.textVec.x, this.textVec.y, spot + 1 + "/" + height, this.color);
        if (argNode.child1 != null) {
            this.drawTree(argDraw, argNode.child1, spot + 1, height);
        }
        if (argNode.child2 != null) {
            this.drawTree(argDraw, argNode.child2, spot + 1, height);
        }
    }
}

