/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.dynamics.contacts;

import org.jbox2d.callbacks.ContactListener;
import org.jbox2d.collision.ContactID;
import org.jbox2d.collision.Manifold;
import org.jbox2d.collision.ManifoldPoint;
import org.jbox2d.collision.WorldManifold;
import org.jbox2d.collision.shapes.Shape;
import org.jbox2d.common.Transform;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.Fixture;
import org.jbox2d.dynamics.contacts.ContactEdge;
import org.jbox2d.pooling.IWorldPool;
import org.jbox2d.pooling.TLManifold;

public abstract class Contact {
    public static final int ISLAND_FLAG = 1;
    public static final int TOUCHING_FLAG = 2;
    public static final int ENABLED_FLAG = 4;
    public static final int FILTER_FLAG = 8;
    public static final int BULLET_HIT_FLAG = 16;
    public int m_flags;
    public Contact m_prev;
    public Contact m_next;
    public ContactEdge m_nodeA = new ContactEdge();
    public ContactEdge m_nodeB = new ContactEdge();
    public Fixture m_fixtureA = null;
    public Fixture m_fixtureB = null;
    public Manifold m_manifold = new Manifold();
    public float m_toiCount;
    protected final IWorldPool pool;
    private static final TLManifold tloldManifold = new TLManifold();

    protected Contact(IWorldPool argPool) {
        this.pool = argPool;
    }

    public void init(Fixture fA, Fixture fB) {
        this.m_flags = 0;
        this.m_fixtureA = fA;
        this.m_fixtureB = fB;
        this.m_manifold.pointCount = 0;
        this.m_prev = null;
        this.m_next = null;
        this.m_nodeA.contact = null;
        this.m_nodeA.prev = null;
        this.m_nodeA.next = null;
        this.m_nodeA.other = null;
        this.m_nodeB.contact = null;
        this.m_nodeB.prev = null;
        this.m_nodeB.next = null;
        this.m_nodeB.other = null;
        this.m_toiCount = 0.0f;
    }

    public Manifold getManifold() {
        return this.m_manifold;
    }

    public void getWorldManifold(WorldManifold worldManifold) {
        Body bodyA = this.m_fixtureA.getBody();
        Body bodyB = this.m_fixtureB.getBody();
        Shape shapeA = this.m_fixtureA.getShape();
        Shape shapeB = this.m_fixtureB.getShape();
        worldManifold.initialize(this.m_manifold, bodyA.getTransform(), shapeA.m_radius, bodyB.getTransform(), shapeB.m_radius);
    }

    public boolean isTouching() {
        return (this.m_flags & 2) == 2;
    }

    public void setEnabled(boolean flag) {
        this.m_flags = flag ? (this.m_flags |= 4) : (this.m_flags &= 0xFFFFFFFB);
    }

    public boolean isEnabled() {
        return (this.m_flags & 4) == 4;
    }

    public Contact getNext() {
        return this.m_next;
    }

    public Fixture getFixtureA() {
        return this.m_fixtureA;
    }

    public Fixture getFixtureB() {
        return this.m_fixtureB;
    }

    public abstract void evaluate(Manifold var1, Transform var2, Transform var3);

    public void flagForFiltering() {
        this.m_flags |= 8;
    }

    public void update(ContactListener listener) {
        Manifold oldManifold = (Manifold)tloldManifold.get();
        oldManifold.set(this.m_manifold);
        this.m_flags |= 4;
        boolean touching = false;
        boolean wasTouching = (this.m_flags & 2) == 2;
        boolean sensorA = this.m_fixtureA.isSensor();
        boolean sensorB = this.m_fixtureB.isSensor();
        boolean sensor = sensorA || sensorB;
        Body bodyA = this.m_fixtureA.getBody();
        Body bodyB = this.m_fixtureB.getBody();
        Transform xfA = bodyA.getTransform();
        Transform xfB = bodyB.getTransform();
        if (sensor) {
            Shape shapeA = this.m_fixtureA.getShape();
            Shape shapeB = this.m_fixtureB.getShape();
            touching = this.pool.getCollision().testOverlap(shapeA, shapeB, xfA, xfB);
            this.m_manifold.pointCount = 0;
        } else {
            this.evaluate(this.m_manifold, xfA, xfB);
            touching = this.m_manifold.pointCount > 0;
            block0: for (int i = 0; i < this.m_manifold.pointCount; ++i) {
                ManifoldPoint mp2 = this.m_manifold.points[i];
                mp2.normalImpulse = 0.0f;
                mp2.tangentImpulse = 0.0f;
                ContactID id2 = mp2.id;
                for (int j = 0; j < oldManifold.pointCount; ++j) {
                    ManifoldPoint mp1 = oldManifold.points[j];
                    if (!mp1.id.isEqual(id2)) continue;
                    mp2.normalImpulse = mp1.normalImpulse;
                    mp2.tangentImpulse = mp1.tangentImpulse;
                    continue block0;
                }
            }
            if (touching != wasTouching) {
                bodyA.setAwake(true);
                bodyB.setAwake(true);
            }
        }
        this.m_flags = touching ? (this.m_flags |= 2) : (this.m_flags &= 0xFFFFFFFD);
        if (listener == null) {
            return;
        }
        if (!wasTouching && touching) {
            listener.beginContact(this);
        }
        if (wasTouching && !touching) {
            listener.endContact(this);
        }
        if (!sensor && touching) {
            listener.preSolve(this, oldManifold);
        }
    }
}

