/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.dynamics.contacts;

import org.jbox2d.collision.Manifold;
import org.jbox2d.collision.ManifoldPoint;
import org.jbox2d.collision.shapes.Shape;
import org.jbox2d.common.MathUtils;
import org.jbox2d.common.Settings;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.Fixture;
import org.jbox2d.dynamics.contacts.Contact;
import org.jbox2d.dynamics.contacts.TOIConstraint;
import org.jbox2d.dynamics.contacts.TOISolverManifold;

public class TOISolver {
    private TOIConstraint[] m_constraints = new TOIConstraint[4];
    private int m_count = 0;
    private Body m_toiBody = null;
    private final TOISolverManifold psm = new TOISolverManifold();
    private final Vec2 rA = new Vec2();
    private final Vec2 rB = new Vec2();
    private final Vec2 P = new Vec2();
    private final Vec2 temp = new Vec2();

    public TOISolver() {
        for (int i = 0; i < this.m_constraints.length; ++i) {
            this.m_constraints[i] = new TOIConstraint();
        }
    }

    public void clear() {
    }

    public void initialize(Contact[] contacts, int count, Body toiBody) {
        this.m_count = count;
        this.m_toiBody = toiBody;
        if (this.m_count >= this.m_constraints.length) {
            TOIConstraint[] old = this.m_constraints;
            this.m_constraints = new TOIConstraint[old.length * 2];
            System.arraycopy(old, 0, this.m_constraints, 0, old.length);
            for (int i = old.length; i < this.m_constraints.length; ++i) {
                this.m_constraints[i] = new TOIConstraint();
            }
        }
        for (int i = 0; i < this.m_count; ++i) {
            Contact contact = contacts[i];
            Fixture fixtureA = contact.getFixtureA();
            Fixture fixtureB = contact.getFixtureB();
            Shape shapeA = fixtureA.getShape();
            Shape shapeB = fixtureB.getShape();
            float radiusA = shapeA.m_radius;
            float radiusB = shapeB.m_radius;
            Body bodyA = fixtureA.getBody();
            Body bodyB = fixtureB.getBody();
            Manifold manifold = contact.getManifold();
            assert (manifold.pointCount > 0);
            TOIConstraint constraint = this.m_constraints[i];
            constraint.bodyA = bodyA;
            constraint.bodyB = bodyB;
            constraint.localNormal.set(manifold.localNormal);
            constraint.localPoint.set(manifold.localPoint);
            constraint.type = manifold.type;
            constraint.pointCount = manifold.pointCount;
            constraint.radius = radiusA + radiusB;
            for (int j = 0; j < constraint.pointCount; ++j) {
                ManifoldPoint cp = manifold.points[j];
                constraint.localPoints[j] = cp.localPoint;
            }
        }
    }

    public boolean solve(float baumgarte) {
        float minSeparation = 0.0f;
        for (int i = 0; i < this.m_count; ++i) {
            TOIConstraint c = this.m_constraints[i];
            Body bodyA = c.bodyA;
            Body bodyB = c.bodyB;
            float massA = bodyA.m_mass;
            float massB = bodyB.m_mass;
            if (bodyA == this.m_toiBody) {
                massB = 0.0f;
            } else {
                massA = 0.0f;
            }
            float invMassA = massA * bodyA.m_invMass;
            float invIA = massA * bodyA.m_invI;
            float invMassB = massB * bodyB.m_invMass;
            float invIB = massB * bodyB.m_invI;
            for (int j = 0; j < c.pointCount; ++j) {
                this.psm.initialize(c, j);
                Vec2 normal = this.psm.normal;
                Vec2 point = this.psm.point;
                float separation = this.psm.separation;
                this.rA.set(point).subLocal(bodyA.m_sweep.c);
                this.rB.set(point).subLocal(bodyB.m_sweep.c);
                minSeparation = MathUtils.min(minSeparation, separation);
                float C = MathUtils.clamp(baumgarte * (separation + Settings.linearSlop), -Settings.maxLinearCorrection, 0.0f);
                float rnA = Vec2.cross(this.rA, normal);
                float rnB = Vec2.cross(this.rB, normal);
                float K = invMassA + invMassB + invIA * rnA * rnA + invIB * rnB * rnB;
                float impulse = K > 0.0f ? -C / K : 0.0f;
                this.P.set(normal).mulLocal(impulse);
                this.temp.set(this.P).mulLocal(invMassA);
                bodyA.m_sweep.c.subLocal(this.temp);
                bodyA.m_sweep.a -= invIA * Vec2.cross(this.rA, this.P);
                bodyA.synchronizeTransform();
                this.temp.set(this.P).mulLocal(invMassB);
                bodyB.m_sweep.c.addLocal(this.temp);
                bodyB.m_sweep.a += invIB * Vec2.cross(this.rB, this.P);
                bodyB.synchronizeTransform();
            }
        }
        return minSeparation >= -1.5f * Settings.linearSlop;
    }
}

