/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.dynamics.joints;

import org.jbox2d.common.MathUtils;
import org.jbox2d.common.Settings;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.TimeStep;
import org.jbox2d.dynamics.World;
import org.jbox2d.dynamics.joints.ConstantVolumeJointDef;
import org.jbox2d.dynamics.joints.DistanceJoint;
import org.jbox2d.dynamics.joints.DistanceJointDef;
import org.jbox2d.dynamics.joints.Joint;

public class ConstantVolumeJoint
extends Joint {
    Body[] bodies;
    float[] targetLengths;
    float targetVolume;
    Vec2[] normals;
    TimeStep m_step;
    private float m_impulse = 0.0f;
    private World world;
    DistanceJoint[] distanceJoints;

    public Body[] getBodies() {
        return this.bodies;
    }

    public void inflate(float factor) {
        this.targetVolume *= factor;
    }

    public ConstantVolumeJoint(World argWorld, ConstantVolumeJointDef def) {
        super(argWorld.getPool(), def);
        int i;
        this.world = argWorld;
        if (def.bodies.length <= 2) {
            throw new IllegalArgumentException("You cannot create a constant volume joint with less than three bodies.");
        }
        this.bodies = def.bodies;
        this.targetLengths = new float[this.bodies.length];
        for (int i2 = 0; i2 < this.targetLengths.length; ++i2) {
            float dist;
            int next = i2 == this.targetLengths.length - 1 ? 0 : i2 + 1;
            this.targetLengths[i2] = dist = this.bodies[i2].getWorldCenter().sub(this.bodies[next].getWorldCenter()).length();
        }
        this.targetVolume = this.getArea();
        DistanceJointDef djd = new DistanceJointDef();
        this.distanceJoints = new DistanceJoint[this.bodies.length];
        for (i = 0; i < this.targetLengths.length; ++i) {
            int next = i == this.targetLengths.length - 1 ? 0 : i + 1;
            djd.frequencyHz = def.frequencyHz;
            djd.dampingRatio = def.dampingRatio;
            djd.initialize(this.bodies[i], this.bodies[next], this.bodies[i].getWorldCenter(), this.bodies[next].getWorldCenter());
            this.distanceJoints[i] = (DistanceJoint)this.world.createJoint(djd);
        }
        this.normals = new Vec2[this.bodies.length];
        for (i = 0; i < this.normals.length; ++i) {
            this.normals[i] = new Vec2();
        }
        this.m_bodyA = this.bodies[0];
        this.m_bodyB = this.bodies[1];
        this.m_collideConnected = false;
    }

    @Override
    public void destructor() {
        for (int i = 0; i < this.distanceJoints.length; ++i) {
            this.world.destroyJoint(this.distanceJoints[i]);
        }
    }

    private float getArea() {
        float area = 0.0f;
        area += this.bodies[this.bodies.length - 1].getWorldCenter().x * this.bodies[0].getWorldCenter().y - this.bodies[0].getWorldCenter().x * this.bodies[this.bodies.length - 1].getWorldCenter().y;
        for (int i = 0; i < this.bodies.length - 1; ++i) {
            area += this.bodies[i].getWorldCenter().x * this.bodies[i + 1].getWorldCenter().y - this.bodies[i + 1].getWorldCenter().x * this.bodies[i].getWorldCenter().y;
        }
        return area *= 0.5f;
    }

    public boolean constrainEdges(TimeStep step) {
        float perimeter = 0.0f;
        for (int i = 0; i < this.bodies.length; ++i) {
            int next = i == this.bodies.length - 1 ? 0 : i + 1;
            float dx = this.bodies[next].getWorldCenter().x - this.bodies[i].getWorldCenter().x;
            float dy = this.bodies[next].getWorldCenter().y - this.bodies[i].getWorldCenter().y;
            float dist = MathUtils.sqrt(dx * dx + dy * dy);
            if (dist < 1.1920929E-7f) {
                dist = 1.0f;
            }
            this.normals[i].x = dy / dist;
            this.normals[i].y = -dx / dist;
            perimeter += dist;
        }
        Vec2 delta = this.pool.popVec2();
        float deltaArea = this.targetVolume - this.getArea();
        float toExtrude = 0.5f * deltaArea / perimeter;
        boolean done = true;
        for (int i = 0; i < this.bodies.length; ++i) {
            int next = i == this.bodies.length - 1 ? 0 : i + 1;
            delta.set(toExtrude * (this.normals[i].x + this.normals[next].x), toExtrude * (this.normals[i].y + this.normals[next].y));
            float norm = delta.length();
            if (norm > Settings.maxLinearCorrection) {
                delta.mulLocal(Settings.maxLinearCorrection / norm);
            }
            if (norm > Settings.linearSlop) {
                done = false;
            }
            this.bodies[next].m_sweep.c.x += delta.x;
            this.bodies[next].m_sweep.c.y += delta.y;
            this.bodies[next].synchronizeTransform();
        }
        this.pool.pushVec2(1);
        return done;
    }

    @Override
    public void initVelocityConstraints(TimeStep step) {
        int i;
        this.m_step = step;
        Vec2[] d = this.pool.getVec2Array(this.bodies.length);
        for (i = 0; i < this.bodies.length; ++i) {
            int prev = i == 0 ? this.bodies.length - 1 : i - 1;
            int next = i == this.bodies.length - 1 ? 0 : i + 1;
            d[i].set(this.bodies[next].getWorldCenter());
            d[i].subLocal(this.bodies[prev].getWorldCenter());
        }
        if (step.warmStarting) {
            this.m_impulse *= step.dtRatio;
            for (i = 0; i < this.bodies.length; ++i) {
                this.bodies[i].m_linearVelocity.x += this.bodies[i].m_invMass * d[i].y * 0.5f * this.m_impulse;
                this.bodies[i].m_linearVelocity.y += this.bodies[i].m_invMass * -d[i].x * 0.5f * this.m_impulse;
            }
        } else {
            this.m_impulse = 0.0f;
        }
    }

    @Override
    public boolean solvePositionConstraints(float baumgarte) {
        return this.constrainEdges(this.m_step);
    }

    @Override
    public void solveVelocityConstraints(TimeStep step) {
        float crossMassSum = 0.0f;
        float dotMassSum = 0.0f;
        Vec2[] d = this.pool.getVec2Array(this.bodies.length);
        for (int i = 0; i < this.bodies.length; ++i) {
            int prev = i == 0 ? this.bodies.length - 1 : i - 1;
            int next = i == this.bodies.length - 1 ? 0 : i + 1;
            d[i].set(this.bodies[next].getWorldCenter());
            d[i].subLocal(this.bodies[prev].getWorldCenter());
            dotMassSum += d[i].lengthSquared() / this.bodies[i].getMass();
            crossMassSum += Vec2.cross(this.bodies[i].getLinearVelocity(), d[i]);
        }
        float lambda = -2.0f * crossMassSum / dotMassSum;
        this.m_impulse += lambda;
        for (int i = 0; i < this.bodies.length; ++i) {
            this.bodies[i].m_linearVelocity.x += this.bodies[i].m_invMass * d[i].y * 0.5f * lambda;
            this.bodies[i].m_linearVelocity.y += this.bodies[i].m_invMass * -d[i].x * 0.5f * lambda;
        }
    }

    @Override
    public void getAnchorA(Vec2 argOut) {
    }

    @Override
    public void getAnchorB(Vec2 argOut) {
    }

    @Override
    public void getReactionForce(float inv_dt, Vec2 argOut) {
    }

    @Override
    public float getReactionTorque(float inv_dt) {
        return 0.0f;
    }
}

