/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.dynamics.joints;

import org.jbox2d.common.Mat22;
import org.jbox2d.common.MathUtils;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.TimeStep;
import org.jbox2d.dynamics.joints.FrictionJointDef;
import org.jbox2d.dynamics.joints.Joint;
import org.jbox2d.pooling.IWorldPool;

public class FrictionJoint
extends Joint {
    private final Vec2 m_localAnchorA;
    private final Vec2 m_localAnchorB;
    private final Mat22 m_linearMass;
    private float m_angularMass;
    private final Vec2 m_linearImpulse;
    private float m_angularImpulse;
    private float m_maxForce;
    private float m_maxTorque;

    public FrictionJoint(IWorldPool argWorldPool, FrictionJointDef def) {
        super(argWorldPool, def);
        this.m_localAnchorA = new Vec2(def.localAnchorA);
        this.m_localAnchorB = new Vec2(def.localAnchorB);
        this.m_linearImpulse = new Vec2();
        this.m_angularImpulse = 0.0f;
        this.m_maxForce = def.maxForce;
        this.m_maxTorque = def.maxTorque;
        this.m_linearMass = new Mat22();
    }

    @Override
    public void getAnchorA(Vec2 argOut) {
        this.m_bodyA.getWorldPointToOut(this.m_localAnchorA, argOut);
    }

    @Override
    public void getAnchorB(Vec2 argOut) {
        this.m_bodyB.getWorldPointToOut(this.m_localAnchorB, argOut);
    }

    @Override
    public void getReactionForce(float inv_dt, Vec2 argOut) {
        argOut.set(this.m_linearImpulse).mulLocal(inv_dt);
    }

    @Override
    public float getReactionTorque(float inv_dt) {
        return inv_dt * this.m_angularImpulse;
    }

    public void setMaxForce(float force) {
        assert (force >= 0.0f);
        this.m_maxForce = force;
    }

    public float getMaxForce() {
        return this.m_maxForce;
    }

    public void setMaxTorque(float torque) {
        assert (torque >= 0.0f);
        this.m_maxTorque = torque;
    }

    public float getMaxTorque() {
        return this.m_maxTorque;
    }

    @Override
    public void initVelocityConstraints(TimeStep step) {
        Body bA = this.m_bodyA;
        Body bB = this.m_bodyB;
        Vec2 rA = this.pool.popVec2();
        Vec2 rB = this.pool.popVec2();
        rA.set(this.m_localAnchorA).subLocal(bA.getLocalCenter());
        rB.set(this.m_localAnchorB).subLocal(bB.getLocalCenter());
        Mat22.mulToOut(bA.getTransform().R, rA, rA);
        Mat22.mulToOut(bB.getTransform().R, rB, rB);
        float mA = bA.m_invMass;
        float mB = bB.m_invMass;
        float iA = bA.m_invI;
        float iB = bB.m_invI;
        Mat22 K1 = this.pool.popMat22();
        K1.col1.x = mA + mB;
        K1.col2.x = 0.0f;
        K1.col1.y = 0.0f;
        K1.col2.y = mA + mB;
        Mat22 K2 = this.pool.popMat22();
        K2.col1.x = iA * rA.y * rA.y;
        K2.col2.x = -iA * rA.x * rA.y;
        K2.col1.y = -iA * rA.x * rA.y;
        K2.col2.y = iA * rA.x * rA.x;
        Mat22 K3 = this.pool.popMat22();
        K3.col1.x = iB * rB.y * rB.y;
        K3.col2.x = -iB * rB.x * rB.y;
        K3.col1.y = -iB * rB.x * rB.y;
        K3.col2.y = iB * rB.x * rB.x;
        K1.addLocal(K2).addLocal(K3);
        this.m_linearMass.set(K1).invertLocal();
        this.m_angularMass = iA + iB;
        if (this.m_angularMass > 0.0f) {
            this.m_angularMass = 1.0f / this.m_angularMass;
        }
        if (step.warmStarting) {
            this.m_linearImpulse.mulLocal(step.dtRatio);
            this.m_angularImpulse *= step.dtRatio;
            Vec2 P = this.pool.popVec2();
            P.set(this.m_linearImpulse.x, this.m_linearImpulse.y);
            Vec2 temp = this.pool.popVec2();
            temp.set(P).mulLocal(mA);
            bA.m_linearVelocity.subLocal(temp);
            bA.m_angularVelocity -= iA * (Vec2.cross(rA, P) + this.m_angularImpulse);
            temp.set(P).mulLocal(mB);
            bB.m_linearVelocity.addLocal(temp);
            bB.m_angularVelocity += iB * (Vec2.cross(rB, P) + this.m_angularImpulse);
            this.pool.pushVec2(2);
        } else {
            this.m_linearImpulse.setZero();
            this.m_angularImpulse = 0.0f;
        }
        this.pool.pushVec2(2);
        this.pool.pushMat22(3);
    }

    @Override
    public void solveVelocityConstraints(TimeStep step) {
        Body bA = this.m_bodyA;
        Body bB = this.m_bodyB;
        Vec2 vA = bA.m_linearVelocity;
        float wA = bA.m_angularVelocity;
        Vec2 vB = bB.m_linearVelocity;
        float wB = bB.m_angularVelocity;
        float mA = bA.m_invMass;
        float mB = bB.m_invMass;
        float iA = bA.m_invI;
        float iB = bB.m_invI;
        Vec2 rA = this.pool.popVec2();
        Vec2 rB = this.pool.popVec2();
        rA.set(this.m_localAnchorA).subLocal(bA.getLocalCenter());
        rB.set(this.m_localAnchorB).subLocal(bB.getLocalCenter());
        Mat22.mulToOut(bA.getTransform().R, rA, rA);
        Mat22.mulToOut(bB.getTransform().R, rB, rB);
        float Cdot = wB - wA;
        float impulse = -this.m_angularMass * Cdot;
        float oldImpulse = this.m_angularImpulse;
        float maxImpulse = step.dt * this.m_maxTorque;
        this.m_angularImpulse = MathUtils.clamp(this.m_angularImpulse + impulse, -maxImpulse, maxImpulse);
        impulse = this.m_angularImpulse - oldImpulse;
        Vec2 Cdot2 = this.pool.popVec2();
        Vec2 temp = this.pool.popVec2();
        Vec2.crossToOut(wA -= iA * impulse, rA, temp);
        Vec2.crossToOut(wB += iB * impulse, rB, Cdot2);
        Cdot2.addLocal(vB).subLocal(vA).subLocal(temp);
        Vec2 impulse2 = this.pool.popVec2();
        Mat22.mulToOut(this.m_linearMass, Cdot2, impulse2);
        impulse2.negateLocal();
        Vec2 oldImpulse2 = this.pool.popVec2();
        oldImpulse2.set(this.m_linearImpulse);
        this.m_linearImpulse.addLocal(impulse2);
        float maxImpulse2 = step.dt * this.m_maxForce;
        if (this.m_linearImpulse.lengthSquared() > maxImpulse2 * maxImpulse2) {
            this.m_linearImpulse.normalize();
            this.m_linearImpulse.mulLocal(maxImpulse2);
        }
        impulse2.set(this.m_linearImpulse).subLocal(oldImpulse2);
        temp.set(impulse2).mulLocal(mA);
        vA.subLocal(temp);
        wA -= iA * Vec2.cross(rA, impulse2);
        temp.set(impulse2).mulLocal(mB);
        vB.addLocal(temp);
        this.pool.pushVec2(6);
        bA.m_angularVelocity = wA;
        bB.m_angularVelocity = wB += iB * Vec2.cross(rB, impulse2);
    }

    @Override
    public boolean solvePositionConstraints(float baumgarte) {
        return true;
    }
}

