/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.dynamics.joints;

import org.jbox2d.common.Mat22;
import org.jbox2d.common.Settings;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.BodyType;
import org.jbox2d.dynamics.TimeStep;
import org.jbox2d.dynamics.joints.GearJointDef;
import org.jbox2d.dynamics.joints.Jacobian;
import org.jbox2d.dynamics.joints.Joint;
import org.jbox2d.dynamics.joints.JointType;
import org.jbox2d.dynamics.joints.PrismaticJoint;
import org.jbox2d.dynamics.joints.RevoluteJoint;
import org.jbox2d.pooling.IWorldPool;

public class GearJoint
extends Joint {
    private Body m_ground1;
    private Body m_ground2;
    private RevoluteJoint m_revolute1;
    private PrismaticJoint m_prismatic1;
    private RevoluteJoint m_revolute2;
    private PrismaticJoint m_prismatic2;
    private final Vec2 m_groundAnchor1 = new Vec2();
    private final Vec2 m_groundAnchor2 = new Vec2();
    private final Vec2 m_localAnchor1 = new Vec2();
    private final Vec2 m_localAnchor2 = new Vec2();
    private final Jacobian m_J;
    private float m_constant;
    private float m_ratio;
    private float m_mass;
    private float m_impulse;

    public GearJoint(IWorldPool argWorldPool, GearJointDef def) {
        super(argWorldPool, def);
        float coordinate2;
        float coordinate1;
        JointType type1 = def.joint1.getType();
        JointType type2 = def.joint2.getType();
        assert (type1 == JointType.REVOLUTE || type1 == JointType.PRISMATIC);
        assert (type2 == JointType.REVOLUTE || type2 == JointType.PRISMATIC);
        assert (def.joint1.getBodyA().getType() == BodyType.STATIC);
        assert (def.joint2.getBodyA().getType() == BodyType.STATIC);
        this.m_revolute1 = null;
        this.m_prismatic1 = null;
        this.m_revolute2 = null;
        this.m_prismatic2 = null;
        this.m_J = new Jacobian();
        this.m_ground1 = def.joint1.getBodyA();
        this.m_bodyA = def.joint1.getBodyB();
        if (type1 == JointType.REVOLUTE) {
            this.m_revolute1 = (RevoluteJoint)def.joint1;
            this.m_groundAnchor1.set(this.m_revolute1.m_localAnchor1);
            this.m_localAnchor1.set(this.m_revolute1.m_localAnchor2);
            coordinate1 = this.m_revolute1.getJointAngle();
        } else {
            this.m_prismatic1 = (PrismaticJoint)def.joint1;
            this.m_groundAnchor1.set(this.m_prismatic1.m_localAnchor1);
            this.m_localAnchor1.set(this.m_prismatic1.m_localAnchor2);
            coordinate1 = this.m_prismatic1.getJointTranslation();
        }
        this.m_ground2 = def.joint2.getBodyA();
        this.m_bodyB = def.joint2.getBodyB();
        if (type2 == JointType.REVOLUTE) {
            this.m_revolute2 = (RevoluteJoint)def.joint2;
            this.m_groundAnchor2.set(this.m_revolute2.m_localAnchor1);
            this.m_localAnchor2.set(this.m_revolute2.m_localAnchor2);
            coordinate2 = this.m_revolute2.getJointAngle();
        } else {
            this.m_prismatic2 = (PrismaticJoint)def.joint2;
            this.m_groundAnchor2.set(this.m_prismatic2.m_localAnchor1);
            this.m_localAnchor2.set(this.m_prismatic2.m_localAnchor2);
            coordinate2 = this.m_prismatic2.getJointTranslation();
        }
        this.m_ratio = def.ratio;
        this.m_constant = coordinate1 + this.m_ratio * coordinate2;
        this.m_impulse = 0.0f;
    }

    @Override
    public void getAnchorA(Vec2 argOut) {
        this.m_bodyA.getWorldPointToOut(this.m_localAnchor1, argOut);
    }

    @Override
    public void getAnchorB(Vec2 argOut) {
        this.m_bodyB.getWorldPointToOut(this.m_localAnchor2, argOut);
    }

    @Override
    public void getReactionForce(float inv_dt, Vec2 argOut) {
        argOut.set(this.m_J.linearB).mulLocal(this.m_impulse);
        argOut.mulLocal(inv_dt);
    }

    @Override
    public float getReactionTorque(float inv_dt) {
        Vec2 r = this.pool.popVec2();
        Vec2 p = this.pool.popVec2();
        r.set(this.m_localAnchor2).subLocal(this.m_bodyB.getLocalCenter());
        Mat22.mulToOut(this.m_bodyB.getTransform().R, r, r);
        p.set(this.m_J.linearB).mulLocal(this.m_impulse);
        float L = this.m_impulse * this.m_J.angularB - Vec2.cross(r, p);
        this.pool.pushVec2(2);
        return inv_dt * L;
    }

    public void setRatio(float argRatio) {
        this.m_ratio = argRatio;
    }

    public float getRatio() {
        return this.m_ratio;
    }

    @Override
    public void initVelocityConstraints(TimeStep step) {
        float crug;
        Vec2 r;
        Vec2 ug;
        Body g1 = this.m_ground1;
        Body g2 = this.m_ground2;
        Body b1 = this.m_bodyA;
        Body b2 = this.m_bodyB;
        float K = 0.0f;
        this.m_J.setZero();
        if (this.m_revolute1 != null) {
            this.m_J.angularA = -1.0f;
            K += b1.m_invI;
        } else {
            ug = this.pool.popVec2();
            r = this.pool.popVec2();
            Mat22.mulToOut(g1.getTransform().R, this.m_prismatic1.m_localXAxis1, ug);
            r.set(this.m_localAnchor1).subLocal(b1.getLocalCenter());
            Mat22.mulToOut(b1.getTransform().R, r, r);
            crug = Vec2.cross(r, ug);
            this.m_J.linearA.set(ug).negateLocal();
            this.m_J.angularA = -crug;
            K += b1.m_invMass + b1.m_invI * crug * crug;
            this.pool.pushVec2(2);
        }
        if (this.m_revolute2 != null) {
            this.m_J.angularB = -this.m_ratio;
            K += this.m_ratio * this.m_ratio * b2.m_invI;
        } else {
            ug = this.pool.popVec2();
            r = this.pool.popVec2();
            Mat22.mulToOut(g2.getTransform().R, this.m_prismatic2.m_localXAxis1, ug);
            r.set(this.m_localAnchor2).subLocal(b2.getLocalCenter());
            Mat22.mulToOut(b2.getTransform().R, r, r);
            crug = Vec2.cross(r, ug);
            this.m_J.linearB.set(ug).mulLocal(-this.m_ratio);
            this.m_J.angularB = -this.m_ratio * crug;
            K += this.m_ratio * this.m_ratio * (b2.m_invMass + b2.m_invI * crug * crug);
            this.pool.pushVec2(2);
        }
        float f = this.m_mass = K > 0.0f ? 1.0f / K : 0.0f;
        if (step.warmStarting) {
            Vec2 temp = this.pool.popVec2();
            temp.set(this.m_J.linearA).mulLocal(b1.m_invMass).mulLocal(this.m_impulse);
            b1.m_linearVelocity.addLocal(temp);
            b1.m_angularVelocity += b1.m_invI * this.m_impulse * this.m_J.angularA;
            temp.set(this.m_J.linearB).mulLocal(b2.m_invMass).mulLocal(this.m_impulse);
            b2.m_linearVelocity.addLocal(temp);
            b2.m_angularVelocity += b2.m_invI * this.m_impulse * this.m_J.angularB;
            this.pool.pushVec2(1);
        } else {
            this.m_impulse = 0.0f;
        }
    }

    @Override
    public void solveVelocityConstraints(TimeStep step) {
        Body b1 = this.m_bodyA;
        Body b2 = this.m_bodyB;
        float Cdot = this.m_J.compute(b1.m_linearVelocity, b1.m_angularVelocity, b2.m_linearVelocity, b2.m_angularVelocity);
        float impulse = this.m_mass * -Cdot;
        this.m_impulse += impulse;
        Vec2 temp = this.pool.popVec2();
        temp.set(this.m_J.linearA).mulLocal(b1.m_invMass).mulLocal(impulse);
        b1.m_linearVelocity.addLocal(temp);
        b1.m_angularVelocity += b1.m_invI * impulse * this.m_J.angularA;
        temp.set(this.m_J.linearB).mulLocal(b2.m_invMass).mulLocal(impulse);
        b2.m_linearVelocity.addLocal(temp);
        b2.m_angularVelocity += b2.m_invI * impulse * this.m_J.angularB;
        this.pool.pushVec2(1);
    }

    @Override
    public boolean solvePositionConstraints(float baumgarte) {
        float linearError = 0.0f;
        Body b1 = this.m_bodyA;
        Body b2 = this.m_bodyB;
        float coordinate1 = this.m_revolute1 != null ? this.m_revolute1.getJointAngle() : this.m_prismatic1.getJointTranslation();
        float coordinate2 = this.m_revolute2 != null ? this.m_revolute2.getJointAngle() : this.m_prismatic2.getJointTranslation();
        float C = this.m_constant - (coordinate1 + this.m_ratio * coordinate2);
        float impulse = this.m_mass * -C;
        Vec2 temp = this.pool.popVec2();
        temp.set(this.m_J.linearA).mulLocal(b1.m_invMass).mulLocal(impulse);
        b1.m_sweep.c.addLocal(temp);
        b1.m_sweep.a += b1.m_invI * impulse * this.m_J.angularA;
        temp.set(this.m_J.linearB).mulLocal(b2.m_invMass).mulLocal(impulse);
        b2.m_sweep.c.addLocal(temp);
        b2.m_sweep.a += b2.m_invI * impulse * this.m_J.angularB;
        b1.synchronizeTransform();
        b2.synchronizeTransform();
        this.pool.pushVec2(1);
        return linearError < Settings.linearSlop;
    }
}

