/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.pooling.arrays;

import java.util.HashMap;

public abstract class DynamicTLArray<I> {
    private final TLHashMap<Integer, I[]> tlMap = new TLHashMap();

    public I[] get(int argLength) {
        assert (argLength > 0);
        HashMap map = (HashMap)this.tlMap.get();
        if (!map.containsKey(argLength)) {
            map.put(argLength, this.getInitializedArray(argLength));
        }
        assert (((Object[])map.get(argLength)).length == argLength) : "Array not built of correct length";
        return (Object[])map.get(argLength);
    }

    protected abstract I[] getInitializedArray(int var1);

    private static class TLHashMap<K, V>
    extends ThreadLocal<HashMap<K, V>> {
        private TLHashMap() {
        }

        @Override
        protected HashMap<K, V> initialValue() {
            return new HashMap();
        }
    }
}

