/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.util.sph;

import org.jbox2d.collision.AABB;
import org.jbox2d.common.MathUtils;
import org.jbox2d.common.Vec2;
import org.jbox2d.util.sph.Parameter;
import org.jbox2d.util.sph.SmoothParticle;

public class SPHGroup {
    public SmoothParticle[] t;
    public Parameter param = new Parameter();

    public SPHGroup(int nParts, AABB aabb, float tStep) {
        this.param.numPts = nParts;
        this.param.initVel = new Vec2(0.0f, 0.0f);
        this.param.machNum = 0.5;
        this.param.initDensity = 1000.0;
        this.param.initPressure = 10000.0;
        this.param.nu = 1000.0;
        this.param.deltaT = tStep;
        this.param.numSteps = 500000;
        this.param.outputEvery = 5000;
        this.param.firstOutput = 0;
        this.param.densityVariation = 0.3;
        this.param.lengthScale = 1000.0;
        this.param.bodyFX = 0.0;
        this.param.bodyFY = 0.0;
        this.param.c = 1.0;
        this.param.h = 1000.0;
        this.t = new SmoothParticle[nParts];
        for (int i = 0; i < nParts; ++i) {
            float x = MathUtils.randomFloat(aabb.lowerBound.x, aabb.upperBound.x);
            float y = MathUtils.randomFloat(aabb.lowerBound.y, aabb.upperBound.y);
            this.t[i] = new SmoothParticle();
            this.t[i].pos.set(new Vec2(x, y));
            this.t[i].vel.set(this.param.initVel);
            this.t[i].mass = 1.0;
            this.t[i].setDensity(this.param.initDensity);
            this.t[i].setPressure(this.param.initPressure);
            this.t[i].setSmoothingLength(this.param.h);
            this.t[i].setSpeedSound(this.param.c);
            this.t[i].undeleteParticle();
            this.t[i].ID = i;
            this.t[i].setShapeID(-1);
        }
    }

    public void calcPressure() {
        for (int i = 0; i < this.t.length; ++i) {
            if (this.t[i].isEmpty()) continue;
            this.t[i].setMinMaxDensity();
            this.t[i].calcPressure(this.param);
        }
    }

    public void calcSPHEquations(SmoothParticle p1, SmoothParticle p2) {
        if (p1.isEmpty() || p2.isEmpty()) {
            System.out.println("Panic!  Particle is empty!");
        }
        Vec2 v_aB = new Vec2(p1.vel.x - p2.vel.x, p1.vel.y - p2.vel.y);
        p1.calcChangeDensity(p2, v_aB);
        p1.calcChangeVelocity(p2, v_aB, this.param);
        p1.addForceX(this.param);
        p1.addForceY(this.param);
    }

    public void calcCorrectDeltaT() {
        int i = 0;
        double accelX = 0.0;
        double accelY = 0.0;
        double maxAccelSquared = 0.0;
        double accelSquared = 0.0;
        maxAccelSquared = 0.0;
        for (i = 0; i < this.t.length; ++i) {
            if (this.t[i].isEmpty() || !((accelSquared = (accelX = this.t[i].getChangeVelocityX()) * accelX + (accelY = this.t[i].getChangeVelocityY()) * accelY) > maxAccelSquared)) continue;
            maxAccelSquared = accelSquared;
        }
        double calcDeltaT = 1.0E7;
        if (maxAccelSquared > 0.0) {
            calcDeltaT = 0.25 * Math.sqrt(this.param.h / Math.sqrt(maxAccelSquared));
        }
        if (calcDeltaT < this.param.deltaT) {
            System.out.println("current DT: " + this.param.deltaT + " is not small enough.");
            System.out.println("It should be: " + calcDeltaT);
        }
    }

    public void updateParticles() {
        this.calcPressure();
        for (int i = 0; i < this.t.length; ++i) {
            this.t[i].zeroSPHVars();
            for (int j = 0; j < this.t.length; ++j) {
                if (i == j) continue;
                this.calcSPHEquations(this.t[i], this.t[j]);
            }
        }
        float dt = (float)this.param.deltaT;
        for (int i = 0; i < this.t.length; ++i) {
            SmoothParticle p = this.t[i];
            p.vel.x += (float)p.getChangeVelocityX() * dt;
            p.vel.y += (float)p.getChangeVelocityY() * dt;
            p.density += (double)((float)p.getChangeDensity() * dt);
            p.pos.x += p.vel.x * dt;
            p.pos.y += p.vel.y * dt;
            System.out.println(p.getChangeVelocityY());
        }
    }
}

