/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.collision;

import org.jbox2d.collision.ContactID;
import org.jbox2d.collision.Distance;
import org.jbox2d.collision.DistanceInput;
import org.jbox2d.collision.DistanceOutput;
import org.jbox2d.collision.Manifold;
import org.jbox2d.collision.ManifoldPoint;
import org.jbox2d.collision.shapes.CircleShape;
import org.jbox2d.collision.shapes.PolygonShape;
import org.jbox2d.collision.shapes.Shape;
import org.jbox2d.common.Mat22;
import org.jbox2d.common.Settings;
import org.jbox2d.common.Transform;
import org.jbox2d.common.Vec2;
import org.jbox2d.pooling.IWorldPool;

public class Collision {
    public static final int NULL_FEATURE = Integer.MAX_VALUE;
    private final IWorldPool pool;
    private final DistanceInput input = new DistanceInput();
    private final Distance.SimplexCache cache = new Distance.SimplexCache();
    private final DistanceOutput output = new DistanceOutput();
    private final Vec2 normal1 = new Vec2();
    private final EdgeResults results1 = new EdgeResults();
    private final EdgeResults results2 = new EdgeResults();
    private final ClipVertex[] incidentEdge = new ClipVertex[2];
    private final Vec2 localTangent = new Vec2();
    private final Vec2 localNormal = new Vec2();
    private final Vec2 planePoint = new Vec2();
    private final Vec2 tangent = new Vec2();
    private final Vec2 normal = new Vec2();
    private final Vec2 v11 = new Vec2();
    private final Vec2 v12 = new Vec2();
    private final ClipVertex[] clipPoints1 = new ClipVertex[2];
    private final ClipVertex[] clipPoints2 = new ClipVertex[2];

    public Collision(IWorldPool argPool) {
        this.incidentEdge[0] = new ClipVertex();
        this.incidentEdge[1] = new ClipVertex();
        this.clipPoints1[0] = new ClipVertex();
        this.clipPoints1[1] = new ClipVertex();
        this.clipPoints2[0] = new ClipVertex();
        this.clipPoints2[1] = new ClipVertex();
        this.pool = argPool;
    }

    public final boolean testOverlap(Shape shapeA, Shape shapeB, Transform xfA, Transform xfB) {
        this.input.proxyA.set(shapeA);
        this.input.proxyB.set(shapeB);
        this.input.transformA.set(xfA);
        this.input.transformB.set(xfB);
        this.input.useRadii = true;
        this.cache.count = 0;
        this.pool.getDistance().distance(this.output, this.cache, this.input);
        return this.output.distance < 1.1920929E-6f;
    }

    public static final void getPointStates(PointState[] state1, PointState[] state2, Manifold manifold1, Manifold manifold2) {
        int j;
        ContactID id;
        int i;
        for (i = 0; i < Settings.maxManifoldPoints; ++i) {
            state1[i] = PointState.NULL_STATE;
            state2[i] = PointState.NULL_STATE;
        }
        block1: for (i = 0; i < manifold1.pointCount; ++i) {
            id = manifold1.points[i].id;
            state1[i] = PointState.REMOVE_STATE;
            for (j = 0; j < manifold2.pointCount; ++j) {
                if (!manifold2.points[j].id.isEqual(id)) continue;
                state1[i] = PointState.PERSIST_STATE;
                continue block1;
            }
        }
        block3: for (i = 0; i < manifold2.pointCount; ++i) {
            id = manifold2.points[i].id;
            state2[i] = PointState.ADD_STATE;
            for (j = 0; j < manifold1.pointCount; ++j) {
                if (!manifold1.points[j].id.isEqual(id)) continue;
                state2[i] = PointState.PERSIST_STATE;
                continue block3;
            }
        }
    }

    public static final int clipSegmentToLine(ClipVertex[] vOut, ClipVertex[] vIn, Vec2 normal, float offset) {
        int numOut = 0;
        float distance0 = Vec2.dot(normal, vIn[0].v) - offset;
        float distance1 = Vec2.dot(normal, vIn[1].v) - offset;
        if (distance0 <= 0.0f) {
            vOut[numOut++].set(vIn[0]);
        }
        if (distance1 <= 0.0f) {
            vOut[numOut++].set(vIn[1]);
        }
        if (distance0 * distance1 < 0.0f) {
            float interp = distance0 / (distance0 - distance1);
            vOut[numOut].v.set(vIn[1].v).subLocal(vIn[0].v).mulLocal(interp).addLocal(vIn[0].v);
            if (distance0 > 0.0f) {
                vOut[numOut].id.set(vIn[0].id);
            } else {
                vOut[numOut].id.set(vIn[1].id);
            }
            ++numOut;
        }
        return numOut;
    }

    public final void collideCircles(Manifold manifold, CircleShape circle1, Transform xfA, CircleShape circle2, Transform xfB) {
        manifold.pointCount = 0;
        Vec2 v = circle1.m_p;
        float pAy = xfA.position.y + xfA.R.col1.y * v.x + xfA.R.col2.y * v.y;
        float pAx = xfA.position.x + xfA.R.col1.x * v.x + xfA.R.col2.x * v.y;
        Vec2 v1 = circle2.m_p;
        float pBx = xfB.position.x + xfB.R.col1.x * v1.x + xfB.R.col2.x * v1.y;
        float dx = pBx - pAx;
        float pBy = xfB.position.y + xfB.R.col1.y * v1.x + xfB.R.col2.y * v1.y;
        float dy = pBy - pAy;
        float distSqr = dx * dx + dy * dy;
        float radius = circle1.m_radius + circle2.m_radius;
        if (distSqr > radius * radius) {
            return;
        }
        manifold.type = Manifold.ManifoldType.CIRCLES;
        manifold.localPoint.set(circle1.m_p);
        manifold.localNormal.setZero();
        manifold.pointCount = 1;
        manifold.points[0].localPoint.set(circle2.m_p);
        manifold.points[0].id.zero();
    }

    public final void collidePolygonAndCircle(Manifold manifold, PolygonShape polygon, Transform xfA, CircleShape circle, Transform xfB) {
        Vec2 normal;
        manifold.pointCount = 0;
        Vec2 v = circle.m_p;
        float cy = xfB.position.y + xfB.R.col1.y * v.x + xfB.R.col2.y * v.y;
        float cx = xfB.position.x + xfB.R.col1.x * v.x + xfB.R.col2.x * v.y;
        float v1x = cx - xfA.position.x;
        float v1y = cy - xfA.position.y;
        Vec2 b = xfA.R.col1;
        Vec2 b1 = xfA.R.col2;
        float cLocaly = v1x * b1.x + v1y * b1.y;
        float cLocalx = v1x * b.x + v1y * b.y;
        int normalIndex = 0;
        float separation = -3.4028235E38f;
        float radius = polygon.m_radius + circle.m_radius;
        int vertexCount = polygon.m_vertexCount;
        Vec2[] vertices = polygon.m_vertices;
        Vec2[] normals = polygon.m_normals;
        for (int i = 0; i < vertexCount; ++i) {
            Vec2 vertex = vertices[i];
            float tempx = cLocalx - vertex.x;
            float tempy = cLocaly - vertex.y;
            normal = normals[i];
            float s = normal.x * tempx + normal.y * tempy;
            if (s > radius) {
                return;
            }
            if (!(s > separation)) continue;
            separation = s;
            normalIndex = i;
        }
        int vertIndex1 = normalIndex;
        int vertIndex2 = vertIndex1 + 1 < vertexCount ? vertIndex1 + 1 : 0;
        Vec2 v1 = vertices[vertIndex1];
        Vec2 v2 = vertices[vertIndex2];
        if (separation < 1.1920929E-7f) {
            manifold.pointCount = 1;
            manifold.type = Manifold.ManifoldType.FACE_A;
            normal = normals[normalIndex];
            manifold.localNormal.x = normal.x;
            manifold.localNormal.y = normal.y;
            manifold.localPoint.x = (v1.x + v2.x) * 0.5f;
            manifold.localPoint.y = (v1.y + v2.y) * 0.5f;
            ManifoldPoint mpoint = manifold.points[0];
            mpoint.localPoint.x = circle.m_p.x;
            mpoint.localPoint.y = circle.m_p.y;
            mpoint.id.zero();
            return;
        }
        float tempX = cLocalx - v1.x;
        float tempY = cLocaly - v1.y;
        float temp2X = v2.x - v1.x;
        float temp2Y = v2.y - v1.y;
        float u1 = tempX * temp2X + tempY * temp2Y;
        float temp3X = cLocalx - v2.x;
        float temp3Y = cLocaly - v2.y;
        float temp4X = v1.x - v2.x;
        float temp4Y = v1.y - v2.y;
        float u2 = temp3X * temp4X + temp3Y * temp4Y;
        if (u1 <= 0.0f) {
            float dx = cLocalx - v1.x;
            float dy = cLocaly - v1.y;
            if (dx * dx + dy * dy > radius * radius) {
                return;
            }
            manifold.pointCount = 1;
            manifold.type = Manifold.ManifoldType.FACE_A;
            manifold.localNormal.x = cLocalx - v1.x;
            manifold.localNormal.y = cLocaly - v1.y;
            manifold.localNormal.normalize();
            manifold.localPoint.set(v1);
            manifold.points[0].localPoint.set(circle.m_p);
            manifold.points[0].id.zero();
        } else if (u2 <= 0.0f) {
            float dx = cLocalx - v2.x;
            float dy = cLocaly - v2.y;
            if (dx * dx + dy * dy > radius * radius) {
                return;
            }
            manifold.pointCount = 1;
            manifold.type = Manifold.ManifoldType.FACE_A;
            manifold.localNormal.x = cLocalx - v2.x;
            manifold.localNormal.y = cLocaly - v2.y;
            manifold.localNormal.normalize();
            manifold.localPoint.set(v2);
            manifold.points[0].localPoint.set(circle.m_p);
            manifold.points[0].id.zero();
        } else {
            float fcx = (v1.x + v2.x) * 0.5f;
            float fcy = (v1.y + v2.y) * 0.5f;
            float tx = cLocalx - fcx;
            float ty = cLocaly - fcy;
            Vec2 normal2 = normals[vertIndex1];
            separation = tx * normal2.x + ty * normal2.y;
            if (separation > radius) {
                return;
            }
            manifold.pointCount = 1;
            manifold.type = Manifold.ManifoldType.FACE_A;
            manifold.localNormal.set(normals[vertIndex1]);
            manifold.localPoint.x = fcx;
            manifold.localPoint.y = fcy;
            manifold.points[0].localPoint.set(circle.m_p);
            manifold.points[0].id.zero();
        }
    }

    public final float edgeSeparation(PolygonShape poly1, Transform xf1, int edge1, PolygonShape poly2, Transform xf2) {
        int count1 = poly1.m_vertexCount;
        Vec2[] vertices1 = poly1.m_vertices;
        Vec2[] normals1 = poly1.m_normals;
        int count2 = poly2.m_vertexCount;
        Vec2[] vertices2 = poly2.m_vertices;
        assert (0 <= edge1 && edge1 < count1);
        Mat22 R = xf1.R;
        Vec2 v = normals1[edge1];
        float normal1Worldy = R.col1.y * v.x + R.col2.y * v.y;
        float normal1Worldx = R.col1.x * v.x + R.col2.x * v.y;
        Mat22 R1 = xf2.R;
        float normal1x = normal1Worldx * R1.col1.x + normal1Worldy * R1.col1.y;
        float normal1y = normal1Worldx * R1.col2.x + normal1Worldy * R1.col2.y;
        int index = 0;
        float minDot = Float.MAX_VALUE;
        for (int i = 0; i < count2; ++i) {
            Vec2 a = vertices2[i];
            float dot = a.x * normal1x + a.y * normal1y;
            if (!(dot < minDot)) continue;
            minDot = dot;
            index = i;
        }
        Vec2 v3 = vertices1[edge1];
        float v1y = xf1.position.y + R.col1.y * v3.x + R.col2.y * v3.y;
        float v1x = xf1.position.x + R.col1.x * v3.x + R.col2.x * v3.y;
        Vec2 v4 = vertices2[index];
        float v2y = xf2.position.y + R1.col1.y * v4.x + R1.col2.y * v4.y - v1y;
        float v2x = xf2.position.x + R1.col1.x * v4.x + R1.col2.x * v4.y - v1x;
        return v2x * normal1Worldx + v2y * normal1Worldy;
    }

    public final void findMaxSeparation(EdgeResults results, PolygonShape poly1, Transform xf1, PolygonShape poly2, Transform xf2) {
        float bestSeparation;
        int bestEdge;
        int increment;
        int count1 = poly1.m_vertexCount;
        Vec2[] normals1 = poly1.m_normals;
        Vec2 v = poly2.m_centroid;
        float predy = xf2.position.y + xf2.R.col1.y * v.x + xf2.R.col2.y * v.y;
        float predx = xf2.position.x + xf2.R.col1.x * v.x + xf2.R.col2.x * v.y;
        Vec2 v1 = poly1.m_centroid;
        float tempy = xf1.position.y + xf1.R.col1.y * v1.x + xf1.R.col2.y * v1.y;
        float tempx = xf1.position.x + xf1.R.col1.x * v1.x + xf1.R.col2.x * v1.y;
        float dx = predx - tempx;
        float dy = predy - tempy;
        Mat22 R = xf1.R;
        float dLocal1x = dx * R.col1.x + dy * R.col1.y;
        float dLocal1y = dx * R.col2.x + dy * R.col2.y;
        int edge = 0;
        float maxDot = -3.4028235E38f;
        for (int i = 0; i < count1; ++i) {
            Vec2 normal = normals1[i];
            float dot = normal.x * dLocal1x + normal.y * dLocal1y;
            if (!(dot > maxDot)) continue;
            maxDot = dot;
            edge = i;
        }
        float s = this.edgeSeparation(poly1, xf1, edge, poly2, xf2);
        int prevEdge = edge - 1 >= 0 ? edge - 1 : count1 - 1;
        float sPrev = this.edgeSeparation(poly1, xf1, prevEdge, poly2, xf2);
        int nextEdge = edge + 1 < count1 ? edge + 1 : 0;
        float sNext = this.edgeSeparation(poly1, xf1, nextEdge, poly2, xf2);
        if (sPrev > s && sPrev > sNext) {
            increment = -1;
            bestEdge = prevEdge;
            bestSeparation = sPrev;
        } else if (sNext > s) {
            increment = 1;
            bestEdge = nextEdge;
            bestSeparation = sNext;
        } else {
            results.edgeIndex = edge;
            results.separation = s;
            return;
        }
        while ((s = this.edgeSeparation(poly1, xf1, edge = increment == -1 ? (bestEdge - 1 >= 0 ? bestEdge - 1 : count1 - 1) : (bestEdge + 1 < count1 ? bestEdge + 1 : 0), poly2, xf2)) > bestSeparation) {
            bestEdge = edge;
            bestSeparation = s;
        }
        results.edgeIndex = bestEdge;
        results.separation = bestSeparation;
    }

    public final void findIncidentEdge(ClipVertex[] c, PolygonShape poly1, Transform xf1, int edge1, PolygonShape poly2, Transform xf2) {
        int count1 = poly1.m_vertexCount;
        Vec2[] normals1 = poly1.m_normals;
        int count2 = poly2.m_vertexCount;
        Vec2[] vertices2 = poly2.m_vertices;
        Vec2[] normals2 = poly2.m_normals;
        assert (0 <= edge1 && edge1 < count1);
        Mat22.mulToOut(xf1.R, normals1[edge1], this.normal1);
        Mat22.mulTransToOut(xf2.R, this.normal1, this.normal1);
        int index = 0;
        float minDot = Float.MAX_VALUE;
        for (int i = 0; i < count2; ++i) {
            float dot = Vec2.dot(this.normal1, normals2[i]);
            if (!(dot < minDot)) continue;
            minDot = dot;
            index = i;
        }
        int i1 = index;
        int i2 = i1 + 1 < count2 ? i1 + 1 : 0;
        Transform.mulToOut(xf2, vertices2[i1], c[0].v);
        c[0].id.features.referenceEdge = edge1;
        c[0].id.features.incidentEdge = i1;
        c[0].id.features.incidentVertex = 0;
        Transform.mulToOut(xf2, vertices2[i2], c[1].v);
        c[1].id.features.referenceEdge = edge1;
        c[1].id.features.incidentEdge = i2;
        c[1].id.features.incidentVertex = 1;
    }

    public final void collidePolygons(Manifold manifold, PolygonShape polyA, Transform xfA, PolygonShape polyB, Transform xfB) {
        int flip;
        int edge1;
        Transform xf2;
        Transform xf1;
        PolygonShape poly2;
        PolygonShape poly1;
        manifold.pointCount = 0;
        float totalRadius = polyA.m_radius + polyB.m_radius;
        this.findMaxSeparation(this.results1, polyA, xfA, polyB, xfB);
        if (this.results1.separation > totalRadius) {
            return;
        }
        this.findMaxSeparation(this.results2, polyB, xfB, polyA, xfA);
        if (this.results2.separation > totalRadius) {
            return;
        }
        float k_relativeTol = 0.98f;
        float k_absoluteTol = 0.001f;
        if (this.results2.separation > 0.98f * this.results1.separation + 0.001f) {
            poly1 = polyB;
            poly2 = polyA;
            xf1 = xfB;
            xf2 = xfA;
            edge1 = this.results2.edgeIndex;
            manifold.type = Manifold.ManifoldType.FACE_B;
            flip = 1;
        } else {
            poly1 = polyA;
            poly2 = polyB;
            xf1 = xfA;
            xf2 = xfB;
            edge1 = this.results1.edgeIndex;
            manifold.type = Manifold.ManifoldType.FACE_A;
            flip = 0;
        }
        this.findIncidentEdge(this.incidentEdge, poly1, xf1, edge1, poly2, xf2);
        int count1 = poly1.m_vertexCount;
        Vec2[] vertices1 = poly1.m_vertices;
        this.v11.set(vertices1[edge1]);
        this.v12.set(edge1 + 1 < count1 ? vertices1[edge1 + 1] : vertices1[0]);
        this.localTangent.set(this.v12).subLocal(this.v11);
        this.localTangent.normalize();
        Vec2.crossToOut(this.localTangent, 1.0f, this.localNormal);
        this.planePoint.set(this.v11).addLocal(this.v12).mulLocal(0.5f);
        Mat22.mulToOut(xf1.R, this.localTangent, this.tangent);
        Vec2.crossToOut(this.tangent, 1.0f, this.normal);
        Transform.mulToOut(xf1, this.v11, this.v11);
        Transform.mulToOut(xf1, this.v12, this.v12);
        float frontOffset = Vec2.dot(this.normal, this.v11);
        float sideOffset1 = -Vec2.dot(this.tangent, this.v11) + totalRadius;
        float sideOffset2 = Vec2.dot(this.tangent, this.v12) + totalRadius;
        this.tangent.negateLocal();
        int np = Collision.clipSegmentToLine(this.clipPoints1, this.incidentEdge, this.tangent, sideOffset1);
        this.tangent.negateLocal();
        if (np < 2) {
            return;
        }
        np = Collision.clipSegmentToLine(this.clipPoints2, this.clipPoints1, this.tangent, sideOffset2);
        if (np < 2) {
            return;
        }
        manifold.localNormal.set(this.localNormal);
        manifold.localPoint.set(this.planePoint);
        int pointCount = 0;
        for (int i = 0; i < Settings.maxManifoldPoints; ++i) {
            float separation = Vec2.dot(this.normal, this.clipPoints2[i].v) - frontOffset;
            if (!(separation <= totalRadius)) continue;
            ManifoldPoint cp = manifold.points[pointCount];
            Transform.mulTransToOut(xf2, this.clipPoints2[i].v, cp.localPoint);
            cp.id.set(this.clipPoints2[i].id);
            cp.id.features.flip = flip;
            ++pointCount;
        }
        manifold.pointCount = pointCount;
    }

    public static enum PointState {
        NULL_STATE,
        ADD_STATE,
        PERSIST_STATE,
        REMOVE_STATE;

    }

    public static class ClipVertex {
        public final Vec2 v = new Vec2();
        public final ContactID id = new ContactID();

        public void set(ClipVertex cv) {
            this.v.set(cv.v);
            this.id.set(cv.id);
        }
    }

    private static class EdgeResults {
        public float separation;
        public int edgeIndex;

        private EdgeResults() {
        }
    }
}

