/*
 * Copyright 2018 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.jbpm.process.workitem.camel;

import java.util.Set;

import org.jbpm.process.workitem.camel.request.RequestPayloadMapper;
import org.jbpm.process.workitem.camel.response.ResponsePayloadMapper;
import org.jbpm.process.workitem.camel.uri.CXFURIMapper;
import org.jbpm.process.workitem.core.util.Wid;
import org.jbpm.process.workitem.core.util.WidMavenDepends;
import org.jbpm.process.workitem.core.util.WidParameter;
import org.jbpm.process.workitem.core.util.WidResult;
import org.jbpm.process.workitem.core.util.service.WidAction;
import org.jbpm.process.workitem.core.util.service.WidAuth;
import org.jbpm.process.workitem.core.util.service.WidService;

@Wid(widfile = "CamelCXFConnector.wid", name = "CamelCXFConnector",
        displayName = "CamelCXFConnector",
        defaultHandler = "mvel: new org.jbpm.process.workitem.camel.CXFCamelWorkitemHandler()",
        documentation = "camel-workitem/index.html",
        category = "camel-workitem",
        icon = "CamelCXFConnector.png",
        parameters = {
                @WidParameter(name = "address", required = true),
                @WidParameter(name = "payload", required = true),
                @WidParameter(name = "serviceClass"),
                @WidParameter(name = "serviceName"),
                @WidParameter(name = "portName")
        },
        results = {
                @WidResult(name = "response")
        },
        mavenDepends = {
                @WidMavenDepends(group = "org.jbpm.contrib", artifact = "camel-workitem", version = "7.58.0.Final")
        },
        serviceInfo = @WidService(category = "Camel", description = "Use Apache Camel connectors in your processes",
                keywords = "apache,camel,cxf,payload,route,connector",
                action = @WidAction(title = "Connect to a JAX-WS service hosted in CXF"),
                authinfo = @WidAuth
        )

)
public class CXFCamelWorkitemHandler extends AbstractCamelWorkitemHandler {

    public CXFCamelWorkitemHandler() {
        this.uriConverter = new CXFURIMapper();
        this.requestMapper = new RequestPayloadMapper("payload");
        this.responseMapper = new ResponsePayloadMapper();
    }

    public CXFCamelWorkitemHandler(Set<String> headers) {
        this.uriConverter = new CXFURIMapper();
        this.requestMapper = new RequestPayloadMapper("payload",
                                                      headers);
        this.responseMapper = new ResponsePayloadMapper();
    }
}
