/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.ethereum.test;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.drools.core.process.instance.impl.WorkItemImpl;
import org.jbpm.process.workitem.core.TestWorkItemManager;
import org.jbpm.process.workitem.ethereum.DeployContractWorkitemHandler;
import org.jbpm.process.workitem.ethereum.EthereumAuth;
import org.jbpm.process.workitem.ethereum.GetBalanceWorkitemHandler;
import org.jbpm.process.workitem.ethereum.ObserveContractEventWorkitemHandler;
import org.jbpm.process.workitem.ethereum.QueryExistingContractWorkitemHandler;
import org.jbpm.process.workitem.ethereum.SendEtherWorkitemHandler;
import org.jbpm.process.workitem.ethereum.TransactExistingContractWorkitemHandler;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemManager;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PowerMockIgnore;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.core.DefaultBlockParameter;
import org.web3j.protocol.core.DefaultBlockParameterName;
import org.web3j.protocol.core.RemoteCall;
import org.web3j.protocol.core.Request;
import org.web3j.protocol.core.methods.request.EthFilter;
import org.web3j.protocol.core.methods.request.Transaction;
import org.web3j.protocol.core.methods.response.EthCall;
import org.web3j.protocol.core.methods.response.EthGetBalance;
import org.web3j.protocol.core.methods.response.EthGetTransactionCount;
import org.web3j.protocol.core.methods.response.EthGetTransactionReceipt;
import org.web3j.protocol.core.methods.response.EthSendTransaction;
import org.web3j.protocol.core.methods.response.TransactionReceipt;
import org.web3j.tx.Transfer;
import org.web3j.utils.Convert;
import rx.Observable;
import rx.Subscription;
import rx.functions.Action1;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={Observable.class})
@PowerMockIgnore(value={"javax.crypto.*"})
public class EthereumWorkitemHandlerTest {
    private static final String TEST_WALLET_PASSWORD = "jbpmtest123";
    private List signalList;
    @Mock
    EthereumAuth auth;
    @Mock
    Web3j web3j;
    @Mock
    Request balanceRequest;
    @Mock
    EthGetBalance ethGetBalance;
    @Mock
    Transfer transfer;
    @Mock
    TransactionReceipt transactionReceipt;
    @Mock
    RemoteCall transferRequest;
    @Mock
    Request ethCallRequest;
    @Mock
    EthCall ethCall;
    @Mock
    CompletableFuture ethCallCompletable;
    @Mock
    Request ethCountRequest;
    @Mock
    CompletableFuture ethCountCompletable;
    @Mock
    EthGetTransactionCount transactionCount;
    @Mock
    EthSendTransaction ethSendTransaction;
    @Mock
    Request ethSendRequest;
    @Mock
    CompletableFuture ethSendCompletable;
    @Mock
    Request ethSendRawRequest;
    @Mock
    CompletableFuture ethSendRawCompletable;
    @Mock
    EthSendTransaction ethSendRawTransaction;
    @Mock
    Request ethSendTransactionReceipt;
    @Mock
    EthGetTransactionReceipt ethGetTransactionReceipt;
    @Mock
    TransactionReceipt rawTransactionalRecept;
    @Mock
    KieSession kieSession;
    @Mock
    Subscription subscription;
    @Mock
    Action1 action1;

    @Before
    public void setUp() {
        try {
            Mockito.when((Object)this.web3j.ethGetBalance(Matchers.anyString(), (DefaultBlockParameter)Mockito.any(DefaultBlockParameterName.class))).thenReturn((Object)this.balanceRequest);
            Mockito.when((Object)this.balanceRequest.send()).thenReturn((Object)this.ethGetBalance);
            Mockito.when((Object)this.ethGetBalance.getBalance()).thenReturn((Object)BigInteger.valueOf(100L));
            Mockito.when((Object)this.transfer.sendFunds(Matchers.anyString(), (BigDecimal)Mockito.any(BigDecimal.class), (Convert.Unit)Mockito.any(Convert.Unit.class))).thenReturn((Object)this.transferRequest);
            Mockito.when((Object)this.transferRequest.send()).thenReturn((Object)this.transactionReceipt);
            Mockito.when((Object)this.transactionReceipt.getStatus()).thenReturn((Object)"testStatus");
            Mockito.when((Object)this.transactionReceipt.getBlockHash()).thenReturn((Object)"testBlockHash");
            Mockito.when((Object)this.transactionReceipt.getBlockNumber()).thenReturn((Object)BigInteger.valueOf(1L));
            Mockito.when((Object)this.web3j.ethCall((Transaction)Mockito.any(Transaction.class), (DefaultBlockParameter)Mockito.any(DefaultBlockParameterName.class))).thenReturn((Object)this.ethCallRequest);
            Mockito.when((Object)this.ethCallRequest.sendAsync()).thenReturn((Object)this.ethCallCompletable);
            Mockito.when(this.ethCallCompletable.get()).thenReturn((Object)this.ethCall);
            Mockito.when((Object)this.ethCall.getValue()).thenReturn((Object)"testResultValue");
            Mockito.when((Object)this.web3j.ethGetTransactionCount(Matchers.anyString(), (DefaultBlockParameter)Mockito.any(DefaultBlockParameterName.class))).thenReturn((Object)this.ethCountRequest);
            Mockito.when((Object)this.ethCountRequest.sendAsync()).thenReturn((Object)this.ethCountCompletable);
            Mockito.when(this.ethCountCompletable.get()).thenReturn((Object)this.transactionCount);
            Mockito.when((Object)this.transactionCount.getTransactionCount()).thenReturn((Object)BigInteger.valueOf(10L));
            Mockito.when((Object)this.web3j.ethSendTransaction((Transaction)Mockito.any(Transaction.class))).thenReturn((Object)this.ethSendRequest);
            Mockito.when((Object)this.ethSendRequest.sendAsync()).thenReturn((Object)this.ethSendCompletable);
            Mockito.when(this.ethSendCompletable.get()).thenReturn((Object)this.ethSendTransaction);
            Mockito.when((Object)this.ethSendTransaction.getTransactionHash()).thenReturn((Object)"testTransactionHash");
            Mockito.when((Object)this.web3j.ethSendRawTransaction(Matchers.anyString())).thenReturn((Object)this.ethSendRawRequest);
            Mockito.when((Object)this.ethSendRawRequest.sendAsync()).thenReturn((Object)this.ethSendRawCompletable);
            Mockito.when(this.ethSendRawCompletable.get()).thenReturn((Object)this.ethSendRawTransaction);
            Mockito.when((Object)this.ethSendRawTransaction.getTransactionHash()).thenReturn((Object)"testTransactionHash");
            Mockito.when((Object)this.web3j.ethGetTransactionReceipt(Matchers.anyString())).thenReturn((Object)this.ethSendTransactionReceipt);
            Mockito.when((Object)this.ethSendTransactionReceipt.send()).thenReturn((Object)this.ethGetTransactionReceipt);
            Mockito.when((Object)this.ethGetTransactionReceipt.getTransactionReceipt()).thenReturn(Optional.of(this.rawTransactionalRecept));
            Mockito.when((Object)this.ethGetTransactionReceipt.getResult()).thenReturn((Object)this.rawTransactionalRecept);
            Mockito.when((Object)this.rawTransactionalRecept.getContractAddress()).thenReturn((Object)"testContractAddress");
            this.signalList = new ArrayList();
            ((KieSession)Mockito.doAnswer((Answer)new Answer(){

                public Void answer(InvocationOnMock invocation) {
                    EthereumWorkitemHandlerTest.this.signalList.add(Arrays.toString(invocation.getArguments()));
                    return null;
                }
            }).when((Object)this.kieSession)).signalEvent(Matchers.anyString(), Mockito.any(Object.class));
            Observable logObservable = (Observable)PowerMockito.mock(Observable.class);
            Mockito.when((Object)this.web3j.ethLogObservable((EthFilter)Mockito.any(EthFilter.class))).thenReturn((Object)logObservable);
            Mockito.when((Object)logObservable.subscribe()).thenReturn((Object)this.subscription);
            Mockito.when((Object)logObservable.subscribe((Action1)Mockito.any(Action1.class))).thenReturn((Object)this.subscription);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testGetBalance() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("ServiceURL", (Object)"http://localhost:8545/");
        GetBalanceWorkitemHandler handler = new GetBalanceWorkitemHandler(TEST_WALLET_PASSWORD, "wallet/testwallet.json");
        handler.setWeb3j(this.web3j);
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Assert.assertNotNull((Object)manager.getResults());
        Assert.assertEquals((long)1L, (long)manager.getResults().size());
        Assert.assertTrue((boolean)manager.getResults().containsKey(workItem.getId()));
        Assert.assertTrue((boolean)(((Map)manager.getResults().get(workItem.getId())).get("Balance") instanceof BigDecimal));
        BigDecimal balanceResult = (BigDecimal)((Map)manager.getResults().get(workItem.getId())).get("Balance");
        Assert.assertNotNull((Object)balanceResult);
    }

    @Test
    public void testSendEther() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("ServiceURL", (Object)"http://localhost:8545/");
        workItem.setParameter("Amount", (Object)"10");
        workItem.setParameter("ToAddress", (Object)"0x00211e7e");
        SendEtherWorkitemHandler handler = new SendEtherWorkitemHandler(TEST_WALLET_PASSWORD, "wallet/testwallet.json");
        handler.setWeb3j(this.web3j);
        handler.setTransfer(this.transfer);
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Assert.assertNotNull((Object)manager.getResults());
        Assert.assertEquals((long)1L, (long)manager.getResults().size());
        Assert.assertTrue((boolean)manager.getResults().containsKey(workItem.getId()));
        TransactionReceipt receipt = (TransactionReceipt)((Map)manager.getResults().get(workItem.getId())).get("Receipt");
        Assert.assertNotNull((Object)receipt);
    }

    @Test
    public void testQueryExistingContract() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("ServiceURL", (Object)"http://localhost:8545/");
        workItem.setParameter("ContractAddress", (Object)"0x00211e7e");
        workItem.setParameter("ContractMethodName", (Object)"testQuery");
        workItem.setParameter("MethodOutputType", null);
        QueryExistingContractWorkitemHandler handler = new QueryExistingContractWorkitemHandler(TEST_WALLET_PASSWORD, "wallet/testwallet.json");
        handler.setWeb3j(this.web3j);
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Assert.assertNotNull((Object)manager.getResults());
        Assert.assertEquals((long)1L, (long)manager.getResults().size());
        Assert.assertTrue((boolean)manager.getResults().containsKey(workItem.getId()));
    }

    @Test
    public void testTransactExistingContract() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("ServiceURL", (Object)"http://localhost:8545/");
        workItem.setParameter("ContractAddress", (Object)"0x00211e7e");
        workItem.setParameter("MethodName", (Object)"testQuery");
        workItem.setParameter("MethodInputType", null);
        workItem.setParameter("WaitForReceipt", (Object)"false");
        workItem.setParameter("DepositAmount", (Object)"10");
        TransactExistingContractWorkitemHandler handler = new TransactExistingContractWorkitemHandler(TEST_WALLET_PASSWORD, "wallet/testwallet.json");
        handler.setWeb3j(this.web3j);
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Assert.assertNotNull((Object)manager.getResults());
        Assert.assertEquals((long)1L, (long)manager.getResults().size());
        Assert.assertTrue((boolean)manager.getResults().containsKey(workItem.getId()));
    }

    @Test
    public void testDeployContract() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("ServiceURL", (Object)"http://localhost:8545/");
        workItem.setParameter("ContractPath", (Object)"contract/Storage.bin");
        workItem.setParameter("DepositAmount", (Object)"10");
        workItem.setParameter("WaitForReceipt", (Object)"false");
        DeployContractWorkitemHandler handler = new DeployContractWorkitemHandler(TEST_WALLET_PASSWORD, "wallet/testwallet.json");
        handler.setWeb3j(this.web3j);
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Assert.assertNotNull((Object)manager.getResults());
        Assert.assertEquals((long)1L, (long)manager.getResults().size());
        Assert.assertTrue((boolean)manager.getResults().containsKey(workItem.getId()));
    }

    @Test
    public void testObserveContractUpdates() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("ServiceURL", (Object)"http://localhost:8545/");
        workItem.setParameter("ContractAddress", (Object)"0x00211e7e");
        workItem.setParameter("EventName", (Object)"AmountUpdatedEvent");
        workItem.setParameter("EventReturnType", (Object)"int256");
        workItem.setParameter("SignalName", (Object)"mysignal");
        workItem.setParameter("AbortOnUpdate", (Object)"true");
        ObserveContractEventWorkitemHandler handler = new ObserveContractEventWorkitemHandler(this.kieSession);
        handler.setWeb3j(this.web3j);
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Assert.assertNotNull((Object)manager.getResults());
    }

    @Test
    public void testInvalidParameters() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        DeployContractWorkitemHandler deployContractHandler = new DeployContractWorkitemHandler(TEST_WALLET_PASSWORD, "wallet/testwallet.json");
        try {
            deployContractHandler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
            Assert.fail((String)"Exception on invalid parameters no thrown");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof RuntimeException));
        }
        GetBalanceWorkitemHandler getBalanceHandler = new GetBalanceWorkitemHandler(TEST_WALLET_PASSWORD, "wallet/testwallet.json");
        try {
            getBalanceHandler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
            Assert.fail((String)"Exception on invalid parameters no thrown");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof RuntimeException));
        }
        ObserveContractEventWorkitemHandler observeContractHandler = new ObserveContractEventWorkitemHandler(this.kieSession);
        try {
            observeContractHandler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
            Assert.fail((String)"Exception on invalid parameters no thrown");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof RuntimeException));
        }
        QueryExistingContractWorkitemHandler queryExistingHandler = new QueryExistingContractWorkitemHandler(TEST_WALLET_PASSWORD, "wallet/testwallet.json");
        try {
            queryExistingHandler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
            Assert.fail((String)"Exception on invalid parameters no thrown");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof RuntimeException));
        }
        SendEtherWorkitemHandler sendEtherHandler = new SendEtherWorkitemHandler(TEST_WALLET_PASSWORD, "wallet/testwallet.json");
        try {
            sendEtherHandler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
            Assert.fail((String)"Exception on invalid parameters no thrown");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof RuntimeException));
        }
        TransactExistingContractWorkitemHandler transactExistingHandler = new TransactExistingContractWorkitemHandler(TEST_WALLET_PASSWORD, "wallet/testwallet.json");
        try {
            transactExistingHandler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
            Assert.fail((String)"Exception on invalid parameters no thrown");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof RuntimeException));
        }
    }
}

