/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.exec;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.jbpm.process.workitem.core.AbstractLogOrThrowWorkItemHandler;
import org.jbpm.process.workitem.core.util.RequiredParameterValidator;
import org.jbpm.process.workitem.core.util.Wid;
import org.jbpm.process.workitem.core.util.WidMavenDepends;
import org.jbpm.process.workitem.core.util.WidParameter;
import org.jbpm.process.workitem.core.util.WidResult;
import org.jbpm.process.workitem.core.util.service.WidAction;
import org.jbpm.process.workitem.core.util.service.WidAuth;
import org.jbpm.process.workitem.core.util.service.WidService;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Wid(widfile="ExecShellScriptDefinitions.wid", name="ExecShellScript", displayName="ExecShellScript", defaultHandler="mvel: new org.jbpm.process.workitem.exec.ExecShellScriptWorkItemHandler()", documentation="exec-workitem/index.html", category="exec-workitem", icon="ExecShellScript.png", parameters={@WidParameter(name="ShellScriptLocation", required=true), @WidParameter(name="TimeoutInMillis"), @WidParameter(name="AddEnvironmentVariable", runtimeType="java.util.Map"), @WidParameter(name="RemoveEnvironmentVariable", runtimeType="java.util.List")}, results={@WidResult(name="Output")}, mavenDepends={@WidMavenDepends(group="org.jbpm.contrib", artifact="exec-workitem", version="7.45.0.t20201009")}, serviceInfo=@WidService(category="Exec", description="Execute a command", keywords="execute,shell script", action=@WidAction(title="Execute a shell script"), authinfo=@WidAuth))
public class ExecShellScriptWorkItemHandler
extends AbstractLogOrThrowWorkItemHandler {
    public static final String RESULT = "Output";
    private static final Logger logger = LoggerFactory.getLogger(ExecShellScriptWorkItemHandler.class);

    public void executeWorkItem(WorkItem workItem, WorkItemManager manager) {
        try {
            RequiredParameterValidator.validate(((Object)((Object)this)).getClass(), (WorkItem)workItem);
            String shellScriptLocation = (String)workItem.getParameter("ShellScriptLocation");
            String tout = (String)workItem.getParameter("TimeoutInMillis");
            Long timeout = null;
            timeout = tout != null ? Long.valueOf(Long.parseLong(tout)) : Long.valueOf(1000L);
            Map addEnvironmentVariables = (Map)workItem.getParameter("AddEnvironmentVariable");
            List removeEnvironmentVariables = (List)workItem.getParameter("RemoveEnvironmentVariable");
            logger.debug("ShellScriptLocation " + shellScriptLocation + " Timeout " + timeout);
            ArrayList<String> output = new ArrayList<String>();
            HashMap<String, ArrayList<String>> results = new HashMap<String, ArrayList<String>>();
            try {
                String line;
                Process process;
                ArrayList<String> commandList = new ArrayList<String>();
                commandList.add("sh");
                commandList.add(shellScriptLocation);
                ProcessBuilder processBuilder = new ProcessBuilder(commandList);
                Map<String, String> envVariables = processBuilder.environment();
                if (null != addEnvironmentVariables && !addEnvironmentVariables.isEmpty()) {
                    logger.debug("addEnvironmentVariables " + addEnvironmentVariables);
                    envVariables.putAll(addEnvironmentVariables);
                }
                if (null != removeEnvironmentVariables && !removeEnvironmentVariables.isEmpty()) {
                    logger.debug("removeEnvironmentVariables " + removeEnvironmentVariables);
                    removeEnvironmentVariables.stream().forEach(variable -> {
                        String cfr_ignored_0 = (String)envVariables.remove(variable);
                    });
                }
                if (!(process = processBuilder.start()).waitFor(timeout, TimeUnit.MILLISECONDS)) {
                    logger.error("Terminating the process as the Process timed out: " + timeout);
                    process.destroyForcibly();
                    throw new IOException("Process timed out");
                }
                BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                while ((line = reader.readLine()) != null) {
                    output.add(line);
                    logger.debug("Output line " + line);
                }
            }
            catch (IOException e) {
                logger.error("Error executing the work item IO Exception: " + e.getMessage());
                this.handleException(e);
            }
            catch (InterruptedException e) {
                logger.error("Error executing the work item Interrupted Exception: " + e.getMessage());
                this.handleException(e);
            }
            catch (Exception e) {
                logger.error("Error executing the work item with Exception: " + e.getMessage());
                this.handleException(e);
            }
            results.put(RESULT, output);
            manager.completeWorkItem(workItem.getId(), results);
        }
        catch (Throwable t) {
            this.handleException(t);
        }
    }

    public void abortWorkItem(WorkItem workItem, WorkItemManager manager) {
    }
}

