/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workitem.google.drive;

import com.google.api.client.googleapis.media.MediaHttpDownloaderProgressListener;
import com.google.api.services.drive.Drive;
import java.io.InputStream;
import java.util.Date;
import java.util.HashMap;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.jbpm.document.service.impl.DocumentImpl;
import org.jbpm.process.workitem.core.AbstractLogOrThrowWorkItemHandler;
import org.jbpm.process.workitem.core.util.RequiredParameterValidator;
import org.jbpm.process.workitem.core.util.Wid;
import org.jbpm.process.workitem.core.util.WidMavenDepends;
import org.jbpm.process.workitem.core.util.WidParameter;
import org.jbpm.process.workitem.core.util.WidResult;
import org.jbpm.process.workitem.core.util.service.WidAction;
import org.jbpm.process.workitem.core.util.service.WidAuth;
import org.jbpm.process.workitem.core.util.service.WidService;
import org.jbpm.workitem.google.drive.GoogleDriveAuth;
import org.jbpm.workitem.google.drive.MediaDownloadProgressListener;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Wid(widfile="GoogleDownloadFromDriveDefinitions.wid", name="GoogleDownloadFromDrive", displayName="GoogleDownloadFromDrive", defaultHandler="mvel: new org.jbpm.process.workitem.google.drive.MediaDownloadWorkitemHandler(\"appName\", \"clentSecret\")", documentation="google-drive-workitem/index.html", category="google-drive-workitem", icon="GoogleDownloadFromDrive.png", parameters={@WidParameter(name="DocumentPath", required=true)}, results={@WidResult(name="Document", runtimeType="org.jbpm.document.Document")}, mavenDepends={@WidMavenDepends(group="org.jbpm.contrib", artifact="google-drive-workitem", version="7.45.0.t20201009")}, serviceInfo=@WidService(category="Google Drive", description="Upload and download media to/from Google Drive", keywords="google,drive,media,download", action=@WidAction(title="Download media from Google Drive"), authinfo=@WidAuth(required=true, params={"appName", "clentSecret"}, paramsdescription={"Google app name", "Google client secret"}, referencesite="https://developers.google.com/drive/api/v3/about-auth")))
public class MediaDownloadWorkitemHandler
extends AbstractLogOrThrowWorkItemHandler {
    private String appName;
    private String clientSecret;
    private GoogleDriveAuth auth = new GoogleDriveAuth();
    private static final Logger logger = LoggerFactory.getLogger(MediaDownloadWorkitemHandler.class);
    private static final String RESULTS_DOCUMENT = "Document";

    public MediaDownloadWorkitemHandler(String appName, String clentSecret) {
        this.appName = appName;
        this.clientSecret = clentSecret;
    }

    public void executeWorkItem(WorkItem workItem, WorkItemManager workItemManager) {
        HashMap<String, DocumentImpl> results = new HashMap<String, DocumentImpl>();
        String documentPath = (String)workItem.getParameter("DocumentPath");
        try {
            RequiredParameterValidator.validate(((Object)((Object)this)).getClass(), (WorkItem)workItem);
            Drive drive = this.auth.getDriveService(this.appName, this.clientSecret);
            Drive.Files.Get request = drive.files().get(documentPath);
            request.getMediaHttpDownloader().setProgressListener((MediaHttpDownloaderProgressListener)new MediaDownloadProgressListener());
            request.getMediaHttpDownloader().setDirectDownloadEnabled(true);
            InputStream docInputStream = request.executeMediaAsInputStream();
            DocumentImpl doc = new DocumentImpl();
            String docBaseName = FilenameUtils.getBaseName((String)documentPath);
            String docExtension = FilenameUtils.getExtension((String)documentPath);
            doc.setName(docBaseName + "." + docExtension);
            doc.setIdentifier(documentPath);
            doc.setLastModified(new Date());
            doc.setContent(IOUtils.toByteArray((InputStream)docInputStream));
            results.put(RESULTS_DOCUMENT, doc);
            workItemManager.completeWorkItem(workItem.getId(), results);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void abortWorkItem(WorkItem wi, WorkItemManager wim) {
    }

    public void setAuth(GoogleDriveAuth auth) {
        this.auth = auth;
    }
}

