/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.mavenembedder;

import org.apache.maven.cli.KieMavenCli;
import org.jbpm.process.workitem.mavenembedder.MavenEmbedderUtils;
import org.kie.api.executor.Command;
import org.kie.api.executor.CommandContext;
import org.kie.api.executor.ExecutionResults;
import org.kie.api.runtime.process.WorkItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenEmbedderCommand
implements Command {
    private static final Logger logger = LoggerFactory.getLogger(MavenEmbedderCommand.class);
    private static final String RESULTS_VALUES = "MavenResults";

    public ExecutionResults execute(CommandContext ctx) throws Exception {
        try {
            String goals = (String)this.getData(ctx, "Goals");
            String commandLineOptions = (String)this.getData(ctx, "CLOptions");
            String workDir = (String)this.getData(ctx, "WorkDirectory");
            String projectRoot = (String)this.getData(ctx, "ProjectRoot");
            if (goals == null || workDir == null || projectRoot == null) {
                throw new IllegalArgumentException("Invalid command inputs.");
            }
            ExecutionResults results = new ExecutionResults();
            logger.debug("About to execute maven {} with options {} with working directory {}", new Object[]{goals, commandLineOptions, workDir});
            results.setData(MavenEmbedderUtils.executeMavenGoals(new KieMavenCli(projectRoot), RESULTS_VALUES, projectRoot, commandLineOptions, goals, workDir));
            return results;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    protected Object getData(CommandContext ctx, String name) {
        WorkItem workItem = (WorkItem)ctx.getData("workItem");
        Object data = null;
        if (workItem != null) {
            data = workItem.getParameter(name);
        }
        if (data == null) {
            data = ctx.getData(name);
        }
        return data;
    }
}

