/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.pdf;

import freemarker.cache.StringTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateExceptionHandler;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Date;
import java.util.HashMap;
import org.jbpm.document.service.impl.DocumentImpl;
import org.jbpm.process.workitem.core.AbstractLogOrThrowWorkItemHandler;
import org.jbpm.process.workitem.core.util.RequiredParameterValidator;
import org.jbpm.process.workitem.core.util.Wid;
import org.jbpm.process.workitem.core.util.WidMavenDepends;
import org.jbpm.process.workitem.core.util.WidParameter;
import org.jbpm.process.workitem.core.util.WidResult;
import org.jbpm.process.workitem.core.util.service.WidAction;
import org.jbpm.process.workitem.core.util.service.WidService;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xhtmlrenderer.pdf.ITextRenderer;

@Wid(widfile="GeneratePDFDefinitions.wid", name="GeneratePDF", displayName="GeneratePDF", defaultHandler="mvel: new org.jbpm.process.workitem.pdf.GeneratePDFWorkitemHandler()", documentation="pdf-workitem/index.html", category="pdf-workitem", icon="GeneratePDF.png", parameters={@WidParameter(name="TemplateXHTML", required=true), @WidParameter(name="PDFName")}, results={@WidResult(name="PDFDocument", runtimeType="org.jbpm.document.Document")}, mavenDepends={@WidMavenDepends(group="org.jbpm.contrib", artifact="pdf-workitem", version="7.25.0.Final")}, serviceInfo=@WidService(category="PDF", description="Create PDF from xhtml template using freemarker", keywords="pdf,generate,template,document,freemarker,xhtml", action=@WidAction(title="Generate PDF document")))
public class GeneratePDFWorkitemHandler
extends AbstractLogOrThrowWorkItemHandler {
    private static final Logger logger = LoggerFactory.getLogger(GeneratePDFWorkitemHandler.class);
    private static final String RESULTS_VALUE = "PDFDocument";
    private String resultXHTML;

    public void executeWorkItem(WorkItem workItem, WorkItemManager workItemManager) {
        try {
            RequiredParameterValidator.validate(((Object)((Object)this)).getClass(), (WorkItem)workItem);
            HashMap<String, DocumentImpl> results = new HashMap<String, DocumentImpl>();
            String templateXHTML = (String)workItem.getParameter("TemplateXHTML");
            String pdfName = (String)workItem.getParameter("PDFName");
            if (pdfName == null || pdfName.isEmpty()) {
                pdfName = "generatedpdf";
            }
            Configuration cfg = new Configuration(Configuration.VERSION_2_3_26);
            cfg.setDefaultEncoding("UTF-8");
            cfg.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
            cfg.setLogTemplateExceptions(false);
            StringTemplateLoader stringLoader = new StringTemplateLoader();
            stringLoader.putTemplate("pdfTemplate", templateXHTML);
            cfg.setTemplateLoader((TemplateLoader)stringLoader);
            StringWriter stringWriter = new StringWriter();
            Template pdfTemplate = cfg.getTemplate("pdfTemplate");
            pdfTemplate.process((Object)workItem.getParameters(), (Writer)stringWriter);
            this.resultXHTML = stringWriter.toString();
            ITextRenderer renderer = new ITextRenderer();
            renderer.setDocumentFromString(this.resultXHTML);
            renderer.layout();
            DocumentImpl document = new DocumentImpl();
            document.setName(pdfName + ".pdf");
            document.setLastModified(new Date());
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            renderer.createPDF((OutputStream)baos);
            document.setContent(baos.toByteArray());
            results.put(RESULTS_VALUE, document);
            workItemManager.completeWorkItem(workItem.getId(), results);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            this.handleException(e);
        }
    }

    public void abortWorkItem(WorkItem workItem, WorkItemManager manager) {
    }

    public String getResultXHTML() {
        return this.resultXHTML;
    }
}

